/*
 * $Id$
 */

package org.nuiton.license.plugin.model.descriptor.io.xpp3;

  //---------------------------------/
 //- Imported classes and packages -/
//---------------------------------/

import java.io.Writer;
import java.text.DateFormat;
import java.util.Iterator;
import java.util.Locale;
import org.codehaus.plexus.util.xml.pull.MXSerializer;
import org.codehaus.plexus.util.xml.pull.XmlSerializer;
import org.nuiton.license.plugin.model.descriptor.FileSet;
import org.nuiton.license.plugin.model.descriptor.Header;
import org.nuiton.license.plugin.model.descriptor.LicenseProjectDescriptor;

/**
 * Class LicenseProjectDescriptorXpp3Writer.
 * 
 * @version $Revision$ $Date$
 */
public class LicenseProjectDescriptorXpp3Writer
{

      //--------------------------/
     //- Class/Member Variables -/
    //--------------------------/

    /**
     * Field NAMESPACE.
     */
    private static final String NAMESPACE = null;


      //-----------/
     //- Methods -/
    //-----------/

    /**
     * Method write.
     * 
     * @param writer
     * @param licenseProjectDescriptor
     * @throws java.io.IOException
     */
    public void write( Writer writer, LicenseProjectDescriptor licenseProjectDescriptor )
        throws java.io.IOException
    {
        XmlSerializer serializer = new MXSerializer();
        serializer.setProperty( "http://xmlpull.org/v1/doc/properties.html#serializer-indentation", "  " );
        serializer.setProperty( "http://xmlpull.org/v1/doc/properties.html#serializer-line-separator", "\n" );
        serializer.setOutput( writer );
        serializer.startDocument( licenseProjectDescriptor.getModelEncoding(), null );
        writeLicenseProjectDescriptor( licenseProjectDescriptor, "project", serializer );
        serializer.endDocument();
    } //-- void write( Writer, LicenseProjectDescriptor )

    /**
     * Method writeFileSet.
     * 
     * @param fileSet
     * @param serializer
     * @param tagName
     * @throws java.io.IOException
     */
    private void writeFileSet( FileSet fileSet, String tagName, XmlSerializer serializer )
        throws java.io.IOException
    {
        if ( fileSet != null )
        {
            serializer.startTag( NAMESPACE, tagName );
            if ( fileSet.isUseDefaultExcludes() != true )
            {
                serializer.startTag( NAMESPACE, "useDefaultExcludes" ).text( String.valueOf( fileSet.isUseDefaultExcludes() ) ).endTag( NAMESPACE, "useDefaultExcludes" );
            }
            if ( fileSet.getBasedir() != null )
            {
                serializer.startTag( NAMESPACE, "basedir" ).text( fileSet.getBasedir() ).endTag( NAMESPACE, "basedir" );
            }
            if ( ( fileSet.getIncludes() != null ) && ( fileSet.getIncludes().size() > 0 ) )
            {
                serializer.startTag( NAMESPACE, "includes" );
                for ( Iterator iter = fileSet.getIncludes().iterator(); iter.hasNext(); )
                {
                    String include = (String) iter.next();
                    serializer.startTag( NAMESPACE, "include" ).text( include ).endTag( NAMESPACE, "include" );
                }
                serializer.endTag( NAMESPACE, "includes" );
            }
            if ( fileSet.getInclude() != null )
            {
                serializer.startTag( NAMESPACE, "include" ).text( fileSet.getInclude() ).endTag( NAMESPACE, "include" );
            }
            if ( ( fileSet.getExcludes() != null ) && ( fileSet.getExcludes().size() > 0 ) )
            {
                serializer.startTag( NAMESPACE, "excludes" );
                for ( Iterator iter = fileSet.getExcludes().iterator(); iter.hasNext(); )
                {
                    String exclude = (String) iter.next();
                    serializer.startTag( NAMESPACE, "exclude" ).text( exclude ).endTag( NAMESPACE, "exclude" );
                }
                serializer.endTag( NAMESPACE, "excludes" );
            }
            if ( fileSet.getExclude() != null )
            {
                serializer.startTag( NAMESPACE, "exclude" ).text( fileSet.getExclude() ).endTag( NAMESPACE, "exclude" );
            }
            if ( fileSet.getLineEnding() != null )
            {
                serializer.startTag( NAMESPACE, "lineEnding" ).text( fileSet.getLineEnding() ).endTag( NAMESPACE, "lineEnding" );
            }
            serializer.endTag( NAMESPACE, tagName );
        }
    } //-- void writeFileSet( FileSet, String, XmlSerializer )

    /**
     * Method writeHeader.
     * 
     * @param header
     * @param serializer
     * @param tagName
     * @throws java.io.IOException
     */
    private void writeHeader( Header header, String tagName, XmlSerializer serializer )
        throws java.io.IOException
    {
        if ( header != null )
        {
            serializer.startTag( NAMESPACE, tagName );
            if ( header.getLicenseName() != null )
            {
                serializer.startTag( NAMESPACE, "licenseName" ).text( header.getLicenseName() ).endTag( NAMESPACE, "licenseName" );
            }
            if ( header.getCommentStyle() != null )
            {
                serializer.startTag( NAMESPACE, "commentStyle" ).text( header.getCommentStyle() ).endTag( NAMESPACE, "commentStyle" );
            }
            if ( ( header.getFileSets() != null ) && ( header.getFileSets().size() > 0 ) )
            {
                serializer.startTag( NAMESPACE, "fileSets" );
                for ( Iterator iter = header.getFileSets().iterator(); iter.hasNext(); )
                {
                    FileSet o = (FileSet) iter.next();
                    writeFileSet( o, "fileSet", serializer );
                }
                serializer.endTag( NAMESPACE, "fileSets" );
            }
            if ( header.getFileSet() != null )
            {
                writeFileSet( (FileSet) header.getFileSet(), "fileSet", serializer );
            }
            serializer.endTag( NAMESPACE, tagName );
        }
    } //-- void writeHeader( Header, String, XmlSerializer )

    /**
     * Method writeLicenseProjectDescriptor.
     * 
     * @param licenseProjectDescriptor
     * @param serializer
     * @param tagName
     * @throws java.io.IOException
     */
    private void writeLicenseProjectDescriptor( LicenseProjectDescriptor licenseProjectDescriptor, String tagName, XmlSerializer serializer )
        throws java.io.IOException
    {
        if ( licenseProjectDescriptor != null )
        {
            serializer.startTag( NAMESPACE, tagName );
            if ( licenseProjectDescriptor.getMainLicense() != null )
            {
                serializer.startTag( NAMESPACE, "mainLicense" ).text( licenseProjectDescriptor.getMainLicense() ).endTag( NAMESPACE, "mainLicense" );
            }
            if ( ( licenseProjectDescriptor.getHeaders() != null ) && ( licenseProjectDescriptor.getHeaders().size() > 0 ) )
            {
                serializer.startTag( NAMESPACE, "headers" );
                for ( Iterator iter = licenseProjectDescriptor.getHeaders().iterator(); iter.hasNext(); )
                {
                    Header o = (Header) iter.next();
                    writeHeader( o, "header", serializer );
                }
                serializer.endTag( NAMESPACE, "headers" );
            }
            if ( licenseProjectDescriptor.getHeader() != null )
            {
                writeHeader( (Header) licenseProjectDescriptor.getHeader(), "header", serializer );
            }
            serializer.endTag( NAMESPACE, tagName );
        }
    } //-- void writeLicenseProjectDescriptor( LicenseProjectDescriptor, String, XmlSerializer )


}
