/*
 * #%L
 * Maven helper plugin
 * 
 * $Author: tchemit $
 * $LastChangedDate: 2010-04-12 12:59:27 +0200 (lun., 12 avril 2010) $
 * $LastChangedRevision: 693 $
 * $Id: FileUpdater.java 693 2010-04-12 10:59:27Z tchemit $
 * $HeadURL: http://svn.nuiton.org/svn/maven-helper-plugin/tags/maven-helper-plugin-1.2.3/src/main/java/org/nuiton/io/FileUpdater.java $
 * %%
 * Copyright (C) 2009 - 2010 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as 
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */

package org.nuiton.io;

import java.io.File;

/**
 * Contract to be realized to test if a file is up to date.
 * <p/>
 * use {@link #isFileUpToDate(File)} to determine if a file is up to date.
 *
 * @author tchemit <chemit@codelutin.com>
 */
public interface FileUpdater {

    /**
     * @param f file to test
     * @return {@code true} if file is up to date, {@code false} otherwise.
     */
    boolean isFileUpToDate(File f);

}
