/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.io.xpp3;

import java.beans.PropertyDescriptor;
import java.io.IOException;
import java.text.ParseException;
import java.util.Set;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.codehaus.plexus.util.xml.pull.XmlPullParser;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;
import org.nuiton.io.xpp3.DataConverter;

public abstract class PropertyMapper {
    protected final String name;
    protected final String propertyName;
    protected final DataConverter type;
    protected final Class<?> containerType;
    protected final PropertyDescriptor descriptor;
    protected final boolean onlyOne;

    protected PropertyMapper(String tagName, String propertyName, Class<?> containerType, DataConverter type, boolean onlyOne, PropertyDescriptor descriptor) {
        this.name = tagName;
        this.propertyName = propertyName;
        this.type = type;
        this.onlyOne = onlyOne;
        this.containerType = containerType;
        this.descriptor = descriptor;
    }

    protected abstract Object getDataFromXml(XmlPullParser var1) throws XmlPullParserException, Exception;

    public void setProperty(Object src, XmlPullParser parser, Set<String> parsed, boolean strict) throws XmlPullParserException, IOException {
        if (this.onlyOne && parsed.contains(this.name)) {
            throw new XmlPullParserException("Duplicated tag: '" + parser.getName() + "'", parser, null);
        }
        parsed.add(this.name);
        try {
            Object r = this.getDataFromXml(parser);
            if (r != null) {
                this.descriptor.getWriteMethod().invoke(src, r);
            }
        }
        catch (XmlPullParserException e) {
            throw e;
        }
        catch (NumberFormatException e) {
            if (strict) {
                throw new XmlPullParserException(e.getMessage());
            }
        }
        catch (ParseException e) {
            if (strict) {
                throw new XmlPullParserException(e.getMessage());
            }
        }
        catch (Exception e) {
            throw new XmlPullParserException(e.getMessage());
        }
    }

    public PropertyDescriptor getDescriptor() {
        return this.descriptor;
    }

    public boolean isOnlyOne() {
        return this.onlyOne;
    }

    public String getPropertyName() {
        return this.propertyName;
    }

    public String getTagName() {
        return this.name;
    }

    public DataConverter getType() {
        return this.type;
    }

    public Class<?> getContainerType() {
        return this.containerType;
    }

    public String getName() {
        return this.name;
    }

    public String toString() {
        ToStringBuilder toStringBuilder = new ToStringBuilder((Object)this);
        toStringBuilder.append("name", (Object)this.name);
        toStringBuilder.append("propertyName", (Object)this.propertyName);
        toStringBuilder.append("onlyOne", this.onlyOne);
        toStringBuilder.append("type", (Object)this.type);
        toStringBuilder.append("containerType", this.containerType);
        return toStringBuilder.toString();
    }

    public static class AttributeValueToProperty
    extends PropertyMapper {
        public AttributeValueToProperty(String tagName, String propertyName, Class<?> containerType, DataConverter type, boolean onlyOne, PropertyDescriptor descriptor) {
            super(tagName, propertyName, containerType, type, onlyOne, descriptor);
        }

        @Override
        protected Object getDataFromXml(XmlPullParser parser) throws Exception {
            String t = parser.getAttributeValue("", this.name);
            Object result = null;
            if (t != null && !(t = t.trim()).isEmpty()) {
                result = this.type.convert(t);
            }
            return result;
        }
    }

    public static class TagTextContentToProperty
    extends PropertyMapper {
        public TagTextContentToProperty(String tagName, String propertyName, Class<?> containerType, DataConverter type, boolean onlyOne, PropertyDescriptor descriptor) {
            super(tagName, propertyName, containerType, type, onlyOne, descriptor);
        }

        @Override
        protected Object getDataFromXml(XmlPullParser parser) throws XmlPullParserException, Exception {
            String t = parser.nextText();
            Object result = null;
            if (t != null && !(t = t.trim()).isEmpty()) {
                result = this.type.convert(t);
            }
            return result;
        }
    }
}

