/**
 * *##% Maven helper plugin
 * Copyright (C) 2009 CodeLutin
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 *
 * You should have received a copy of the GNU General Lesser Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>. ##%*
 */
package org.nuiton.license.plugin;

import org.nuiton.util.PluginConfig;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import static org.junit.Assert.*;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

import java.io.File;
import java.io.IOException;
import org.junit.AfterClass;
import org.nuiton.util.BasePluginTestCase;

/** @author chemit */
public class LicensePluginTest extends BasePluginTestCase {

    @BeforeClass
    public static void initClass() throws Exception {
        initConfigs(LicensePluginTest.class, "testOne");
    }

    @AfterClass
    public static void afterClass() throws Exception {
        configItr = null;
        testDir = null;
    }

    @Before
    @Override
    public void setUp() throws Exception {
        super.setUp();
        LicensePlugin plugin = (LicensePlugin) mojo;
        plugin.setOutputDirectory(new File(getBaseDir(), plugin.getOutputDirectory().toString()));
        if (!plugin.getOutputDirectory().exists()) {
            if (!plugin.getOutputDirectory().mkdirs()) {
                throw new IOException("could not create directory : " + plugin.getOutputDirectory());
            }
        }
        plugin.setLicenseFile(new File(pomFile.getParentFile(), plugin.getLicenseFile().toString()));
    }

    @Test
    @PluginConfig(pomName = "testOne.xml", goalName = "add-license")
    public void testOne() throws MojoExecutionException, MojoFailureException {
        assertNotNull(mojo);

        LicensePlugin p = (LicensePlugin) mojo;

        long t0 = p.getLicenseFile().lastModified();

        // always assume pom is older than any file
        // since we can not ensure order of copy test resources
        p.getProject().getFile().setLastModified(0);

        p.execute();

        long t1 = p.getLicenseFile().lastModified();

        assertEquals(t0, t1);

        p.setForce(true);

        p.execute();
        t1 = p.getLicenseFile().lastModified();

        assertTrue(t1 > t0);
    }
}
