/**
 * *##% Maven helper plugin
 * Copyright (C) 2009 CodeLutin
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 *
 * You should have received a copy of the GNU General Lesser Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>. ##%*
 */
package org.nuiton.license;

import org.junit.Test;

import java.io.File;
import java.util.Map;

/** @author chemit */
public class LicenseResolverTest extends BaseLicenseTestCase {

    @Test(expected = IllegalArgumentException.class)
    public void testResolvIllegalArgumentException1() throws Exception {

        LicenseResolver resolver = new LicenseResolver();
        // no baseURL
        // no licenseName
        // no licenses.txt
        resolver.resolv(null);
    }

    @Test(expected = IllegalArgumentException.class)
    public void testResolvIllegalArgumentException2() throws Exception {

        LicenseResolver resolver = new LicenseResolver();

        // no baseURL
        // no licenseName
        // no licenses.txt
        resolver.resolv("");
    }

    @Test(expected = IllegalArgumentException.class)
    public void testResolvIllegalArgumentException3() throws Exception {

        LicenseResolver resolver = new LicenseResolver();

        // no baseURL
        // no licenseName
        // no licenses.txt
        resolver.resolv("   ");
    }

    @Test(expected = IllegalArgumentException.class)
    public void testResolvIllegalArgumentException4() throws Exception {

        LicenseResolver resolver = new LicenseResolver();

        // no baseURL
        // no licenses.txt
        resolver.resolv("dummy");
    }

    @Test(expected = IllegalArgumentException.class)
    public void testResolvIllegalArgumentException5() throws Exception {

        LicenseResolver resolver = new LicenseResolver();


        resolver.setBaseURL("dummy");
        // no licenses.txt
        resolver.resolv("dummy");
    }

    @Test
    public void testResolv() throws Exception {

        LicenseResolver resolver = new LicenseResolver();

        long timestamp = System.currentTimeMillis();
        String licenseName = "dummy_" + timestamp;

        File repo = createLicenseRepository(false);

        resolver.setBaseURL(repo.toURI().toURL().toString());

        License license;

        try {
            // no licenses.properties
            resolver.resolv(licenseName);
            fail();
        } catch (IllegalArgumentException e) {
            assertTrue(true);
        }

        addLicenseToRepository(repo, licenseName);

        //FileUtil.writeString(new File(repo, "licenses.properties"), licenseName + "=My dummy license\n", encoding);
        //license = resolver.resolv(licenseName);
        //assertNull(license);

        Map<String, String> licenseNames = resolver.getLicenseNames();
        assertNotNull(licenseNames);
        assertEquals(1, licenseNames.size());
        assertTrue(licenseNames.containsKey(licenseName));

        // create dummy licenses
        //File file = new File(repo, licenseName);
        //file.mkdirs();
        //FileUtil.writeString(new File(file, "license.txt"), "license", encoding);
        //FileUtil.writeString(new File(file, "header.txt"), "header", encoding);

        license = resolver.resolv(licenseName);
        assertNotNull(license);
        assertEquals(licenseName, license.getName());
        assertNotNull(license.getLicenseContent(encoding));
        assertNotNull(license.getHeaderContent(encoding));
        assertEquals("license:" + licenseName, license.getLicenseContent(encoding));
        assertEquals("header:" + licenseName, license.getHeaderContent(encoding));

    }

}
