package org.nuiton.util;

import java.io.File;

/**
 * Une classe pour définir les entrées-sortie d'un plugin.
 *
 * En entrée, on peut avoir un ou plusieurs répertoires ({@link #inputs}.
 * <p/>
 * En sortie, on ne peut avoir qu'un seul répertoire ({@link #output}.
 * 
 *
 * @author chemit
 * @since 1.0.1
 */
public class PluginIOContext {

    File[] inputs;
    File output;

    public File[] getInputs() {
        return inputs;
    }

    public File getOutput() {
        return output;
    }

    public void setInput(File input) {
        this.inputs = new File[]{input};
    }

    public void setInputs(File[] inputs) {
        this.inputs = inputs;
    }

    public void setOutput(File output) {
        this.output = output;
    }
}
