/*
 * #%L
 * NuitonMatrix
 * 
 * $Id: Vector.java 471 2014-04-10 12:44:04Z bpoussin $
 * $HeadURL: https://svn.nuiton.org/nuiton-matrix/tags/nuiton-matrix-2.4/nuiton-matrix/src/main/java/org/nuiton/math/matrix/Vector.java $
 * %%
 * Copyright (C) 2004 - 2010 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as 
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */

package org.nuiton.math.matrix;

/**
 * Vector.
 *
 * Created: 6 octobre 2005 02:51:12 CEST
 *
 * @author Benjamin POUSSIN <poussin@codelutin.com>
 * @version $Revision: 471 $
 *
 * Last update: $Date: 2014-04-10 14:44:04 +0200 (Thu, 10 Apr 2014) $
 * by : $Author: bpoussin $
 */
public interface Vector { // Vector

    /**
     * Init vector, before this method call, vector is in indetermined state.
     * multiple call to init method must be permit. Only first call must do
     * some work, extra call must do nothing
     * 
     * @param capacity 
     */
    public void init(int capacity);

    /**
     * @deprecated since 2.1, use {@link #getMaxOccurrence()} instead
     */
    @Deprecated
    public double getMaxOccurence();

    /**
     * Retourne la valeur la plus utilise dans le vector
     * @return
     */
    public double getMaxOccurrence();

    public double getValue(int pos);

    public void setValue(int pos, double value);

    public int size();

    /**
     * Permet de savoir si paste est implanté par ce vector.
     * 
     * @param v vector to test
     * @return <tt>true</tt> if operation is supported
     */
    public boolean isImplementedPaste(Vector v);

    /**
     * Permet de savoir si add est implanté par ce vector.
     * 
     * @param v vector to test
     * @return <tt>true</tt> if operation is supported
     */
    public boolean isImplementedAdd(Vector v);

    /**
     * Permet de savoir si minus est implanté par ce vector.
     * 
     * @param v vector to test
     * @return <tt>true</tt> if operation is supported
     */
    public boolean isImplementedMinus(Vector v);

    /**
     * Permet de savoir si map est implanté par ce vector.

     * @return <tt>true</tt> if operation is supported
     */
    public boolean isImplementedMap();

    /**
     * Copie les valeurs du vector passé en argument dans ce vector.
     * 
     * @param source vector to paste
     */
    public void paste(Vector source);

    /**
     * Ajoute les valeurs du vector passé en argument a ce vector.
     * 
     * @param v vector to add
     */
    public void add(Vector v);

    /**
     * Soustrait les valeurs du vector passé en argument a ce vector.
     * 
     * @param v vector to minus
     */
    public void minus(Vector v);

    /**
     * applique a chaque valeur du vector la {@link MapFunction}.
     * 
     * ATTENTION cette function ne doit pas converser d'etat interne qui
     * modifierait son comportement a chaque execution, sinon cette methode
     * ne fonctionne pas, car pour les Vector implanter a base de Map
     * la fonction n'est appliqué qu'au defaultValue et au valeur deja existante
     * 
     * @param f funtion to apply
     */
    public void map(MapFunction f);

} // Vector

