/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.math.matrix.gui;

import javax.swing.event.TableModelListener;
import javax.swing.table.TableCellRenderer;
import org.nuiton.i18n.I18n;
import org.nuiton.math.matrix.MatrixND;
import org.nuiton.math.matrix.gui.MatrixTableModel;

public class MatrixTableModelOption
implements MatrixTableModel {
    protected MatrixTableModel delegate;
    protected boolean sumOption;
    protected boolean meanOption;
    protected boolean transposeOption;

    public MatrixTableModelOption(MatrixTableModel delegate) {
        this(delegate, false, false, false);
    }

    public MatrixTableModelOption(MatrixTableModel delegate, boolean sumOption, boolean meanOption, boolean transposeOption) {
        this.delegate = delegate;
        this.sumOption = sumOption;
        this.meanOption = meanOption;
        this.transposeOption = transposeOption;
    }

    public boolean isSumOption() {
        return this.sumOption;
    }

    public void setSumOption(boolean sumOption) {
        this.sumOption = sumOption;
    }

    public boolean isMeanOption() {
        return this.meanOption;
    }

    public void setMeanOption(boolean meanOption) {
        this.meanOption = meanOption;
    }

    public boolean isTransposeOption() {
        return this.transposeOption;
    }

    public void setTransposeOption(boolean transposeOption) {
        this.transposeOption = transposeOption;
    }

    @Override
    public int getRowCount() {
        int result = -1;
        result = this.transposeOption ? this.delegate.getColumnCount() : this.delegate.getRowCount();
        if (this.sumOption) {
            ++result;
        }
        if (this.meanOption) {
            ++result;
        }
        return result;
    }

    @Override
    public int getColumnCount() {
        int result = -1;
        result = this.transposeOption ? this.delegate.getRowCount() : this.delegate.getColumnCount();
        if (this.sumOption) {
            ++result;
        }
        if (this.meanOption) {
            ++result;
        }
        return result;
    }

    @Override
    public String getColumnName(int columnIndex) {
        Object result = null;
        result = this.sumOption && columnIndex == this.delegate.getColumnCount() + 0 ? null : (this.meanOption && columnIndex == this.delegate.getColumnCount() + 1 ? null : this.delegate.getColumnName(columnIndex));
        return result;
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        return this.delegate.getColumnClass(columnIndex);
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return this.delegate.isCellEditable(rowIndex, columnIndex);
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        int rowCount = this.delegate.getRowCount();
        int columnCount = this.delegate.getColumnCount();
        Object result = null;
        result = this.transposeOption ? this.getValueAtTranposable(columnIndex, rowIndex, rowCount, columnCount) : this.getValueAtTranposable(rowIndex, columnIndex, rowCount, columnCount);
        return result;
    }

    protected Object getValueAtTranposable(int rowIndex, int columnIndex, int rowCount, int columnCount) {
        Object result = null;
        if (rowIndex >= rowCount) {
            if (columnIndex == 0) {
                result = rowIndex == rowCount + 1 ? I18n.t((String)"nuitonmatrix.gui.model.mean", (Object[])new Object[0]) : (this.sumOption ? I18n.t((String)"nuitonmatrix.gui.model.sum", (Object[])new Object[0]) : I18n.t((String)"nuitonmatrix.gui.model.mean", (Object[])new Object[0]));
            } else if (columnIndex == columnCount + 1) {
                if (rowIndex == rowCount + 1) {
                    result = this.delegate.getMatrix().meanAll();
                }
            } else if (columnIndex == columnCount) {
                if (rowIndex == rowCount) {
                    result = this.sumOption ? Double.valueOf(this.delegate.getMatrix().sumAll()) : Double.valueOf(this.delegate.getMatrix().sumAll());
                }
            } else {
                result = rowIndex == rowCount + 1 ? this.getComputedValueForColumn(columnIndex, true) : (this.sumOption ? this.getComputedValueForColumn(columnIndex, false) : this.getComputedValueForColumn(columnIndex, true));
            }
        } else if (columnIndex >= columnCount) {
            if (rowIndex == 0) {
                result = columnIndex == columnCount + 1 ? I18n.t((String)"nuitonmatrix.gui.model.mean", (Object[])new Object[0]) : (this.sumOption ? I18n.t((String)"nuitonmatrix.gui.model.sum", (Object[])new Object[0]) : I18n.t((String)"nuitonmatrix.gui.model.mean", (Object[])new Object[0]));
            } else if (rowIndex != rowCount + 1 && rowIndex != rowCount) {
                result = columnIndex == columnCount + 1 ? this.getComputedValueForRow(rowIndex, true) : (this.sumOption ? this.getComputedValueForRow(rowIndex, false) : this.getComputedValueForRow(rowIndex, true));
            }
        } else {
            result = this.delegate.getValueAt(rowIndex, columnIndex);
        }
        return result;
    }

    protected Double getComputedValueForRow(int delegateRowIndex, boolean mean) {
        double sum = 0.0;
        double count = 0.0;
        for (int col = this.delegate.getAdditionalColumns(); col < this.delegate.getColumnCount(); ++col) {
            sum += ((Double)this.delegate.getValueAt(delegateRowIndex, col)).doubleValue();
            count += 1.0;
        }
        double result = sum;
        if (mean) {
            result = sum / count;
        }
        return result;
    }

    protected Double getComputedValueForColumn(int delegateColumnIndex, boolean mean) {
        double sum = 0.0;
        double count = 0.0;
        for (int row = this.delegate.getAdditionalRows(); row < this.delegate.getRowCount(); ++row) {
            sum += ((Double)this.delegate.getValueAt(row, delegateColumnIndex)).doubleValue();
            count += 1.0;
        }
        double result = sum;
        if (mean) {
            result = sum / count;
        }
        return result;
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        if (this.transposeOption) {
            this.delegate.setValueAt(aValue, rowIndex, columnIndex);
        } else {
            this.delegate.setValueAt(aValue, columnIndex, rowIndex);
        }
    }

    @Override
    public void addTableModelListener(TableModelListener l) {
        this.delegate.addTableModelListener(l);
    }

    @Override
    public void removeTableModelListener(TableModelListener l) {
        this.delegate.removeTableModelListener(l);
    }

    @Override
    public void setMatrix(MatrixND m) {
        this.delegate.setMatrix(m);
    }

    @Override
    public MatrixND getMatrix() {
        return this.delegate.getMatrix();
    }

    @Override
    public TableCellRenderer getMatrixCellRenderer() {
        return this.delegate.getMatrixCellRenderer();
    }

    @Override
    public int getAdditionalRows() {
        int result = 0;
        if (this.sumOption) {
            ++result;
        }
        if (this.meanOption) {
            ++result;
        }
        return result;
    }

    @Override
    public int getAdditionalColumns() {
        int result = 0;
        if (this.sumOption) {
            ++result;
        }
        if (this.meanOption) {
            ++result;
        }
        return result;
    }
}

