/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.jrst.plugin;

import java.io.File;
import java.io.IOException;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.codehaus.plexus.util.DirectoryScanner;
import org.nuiton.jrst.JRST;
import org.nuiton.jrst.plugin.GenerationJRstException;
import org.nuiton.util.MirroredFileUpdater;
import org.nuiton.util.PluginHelper;

public class JRstPlugin
extends AbstractMojo {
    protected static final String[] DEFAULT_INCLUDE_RESOURCES = new String[]{"**\\/*.png", "**\\/*.jpeg", "**\\/*.jpg", "**\\/*.gif"};
    protected File directoryIn;
    protected String inputEncoding = "UTF-8";
    protected File directoryOut;
    protected String outputEncoding = "UTF-8";
    protected File resourceDirectoryOut;
    protected boolean ignoreErrors = true;
    protected String overwrite = "ifnewer";
    protected String defaultLocale = "en";
    protected boolean verbose;
    protected boolean force;
    protected String[] includeResources;
    protected int numberFilesGenerates;

    public JRST.Overwrite getOverwrite() {
        JRST.Overwrite result = JRST.Overwrite.NEVER;
        if (this.overwrite.contains("new")) {
            result = JRST.Overwrite.IFNEWER;
        } else if ("true".equalsIgnoreCase(this.overwrite) || "alltime".equalsIgnoreCase(this.overwrite)) {
            result = JRST.Overwrite.ALLTIME;
        }
        return result;
    }

    public void execute() throws MojoExecutionException {
        block2: {
            try {
                this.actionGenerate();
            }
            catch (GenerationJRstException e) {
                this.getLog().error((CharSequence)("Error during generation for :\n" + GenerationJRstException.getFilesErrors()));
                if (this.ignoreErrors) break block2;
                throw new MojoExecutionException("Error during generation");
            }
        }
        this.actionCopy();
    }

    protected void actionGenerate() {
        String[] files;
        this.getLog().info((CharSequence)"Generating reStructuredText files into xDoc");
        RstUpdater rstUpdater = new RstUpdater(this.directoryIn, this.directoryOut, this.defaultLocale);
        this.numberFilesGenerates = 0;
        DirectoryScanner ds = new DirectoryScanner();
        ds.setBasedir(this.directoryIn);
        ds.setIncludes(new String[]{"**\\/*.rst"});
        ds.scan();
        for (String file : files = ds.getIncludedFiles()) {
            File in = new File(this.directoryIn, file);
            if (!this.force && rstUpdater.isFileUpToDate(in)) {
                if (!this.verbose) continue;
                this.getLog().info((CharSequence)("Skip up-to-date reStructuredText file : " + in));
                continue;
            }
            this.doAction(in, rstUpdater.getMirrorFile(in));
        }
        this.getLog().info((CharSequence)("Generating " + this.numberFilesGenerates + " files to " + this.directoryOut));
    }

    public boolean doAction(File in, File out) {
        block3: {
            this.getLog().info((CharSequence)("Using " + in));
            try {
                JRST.generate((String)"xdoc", (File)in, (String)this.inputEncoding, (File)out, (String)this.outputEncoding, (JRST.Overwrite)this.getOverwrite());
                ++this.numberFilesGenerates;
            }
            catch (Exception e) {
                this.getLog().error((Throwable)e);
                if (this.ignoreErrors) break block3;
                throw new GenerationJRstException(in.getAbsolutePath());
            }
        }
        if (out != null && this.verbose) {
            this.getLog().info((CharSequence)("Generating " + out));
        }
        return true;
    }

    protected void actionCopy() {
        this.getLog().info((CharSequence)"Copy resources files");
        RessourceUpdater resourceUpdater = new RessourceUpdater(this.directoryIn, this.resourceDirectoryOut, this.defaultLocale);
        DirectoryScanner ds = new DirectoryScanner();
        ds.setBasedir(this.directoryIn);
        ds.setIncludes(this.includeResources == null || this.includeResources.length == 0 ? DEFAULT_INCLUDE_RESOURCES : this.includeResources);
        ds.scan();
        for (String file : ds.getIncludedFiles()) {
            File in = new File(this.directoryIn, file);
            if (!this.force && resourceUpdater.isFileUpToDate(in)) {
                if (!this.verbose) continue;
                this.getLog().info((CharSequence)("Skip up-to-date resource file : " + in));
                continue;
            }
            File out = resourceUpdater.getMirrorFile(in);
            if (this.verbose) {
                this.getLog().info((CharSequence)("Copy resource " + in + " to " + out));
            }
            try {
                PluginHelper.copy((File)in, (File)out);
            }
            catch (IOException e) {
                this.getLog().error((Throwable)e);
            }
        }
    }

    protected static class RessourceUpdater
    extends MirroredFileUpdater {
        protected String defaultLocale;

        protected RessourceUpdater(File sourceDirectory, File destinationDirectory, String defaultLocale) {
            super("", "", sourceDirectory, destinationDirectory);
            this.defaultLocale = defaultLocale;
        }

        public File getMirrorFile(File f) {
            String file = f.getAbsolutePath().substring(this.prefixSourceDirecotory);
            file = file.replaceFirst("([/\\\\])rst([/\\\\])", "$1$2");
            if (this.defaultLocale != null && !"".equals(this.defaultLocale)) {
                file = file.replaceFirst("([/\\\\])" + this.defaultLocale + "([/\\\\])", "$1");
            }
            return new File(this.destinationDirectory, file);
        }
    }

    protected static class RstUpdater
    extends MirroredFileUpdater {
        protected String defaultLocale;

        protected RstUpdater(File sourceDirectory, File destinationDirectory, String defaultLocale) {
            super("", "", sourceDirectory, destinationDirectory);
            this.defaultLocale = defaultLocale;
        }

        public File getMirrorFile(File f) {
            String file = f.getAbsolutePath().substring(this.prefixSourceDirecotory);
            file = file.replace(".rst", ".xml").replaceFirst("([/\\\\])rst([/\\\\])", "$1xdoc$2");
            if (this.defaultLocale != null && !"".equals(this.defaultLocale)) {
                file = file.replaceFirst("([/\\\\])" + this.defaultLocale + "([/\\\\])", "$1");
            }
            return new File(this.destinationDirectory, file);
        }
    }
}

