/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.jrst;

import java.io.FileNotFoundException;
import java.io.Reader;
import java.io.StringReader;
import java.net.URL;
import javax.xml.transform.URIResolver;
import org.apache.maven.doxia.module.xdoc.XdocParser;
import org.apache.maven.doxia.parser.ParseException;
import org.apache.maven.doxia.sink.Sink;
import org.dom4j.Document;
import org.nuiton.jrst.JRSTGenerator;
import org.nuiton.jrst.JRSTReader;
import org.nuiton.jrst.JRSTResourceResolver;
import org.nuiton.util.Resource;

public class JrstParser
extends XdocParser {
    public void parse(Reader source, Sink sink) throws ParseException {
        try {
            JRSTReader jrst = new JRSTReader();
            Document doc = jrst.read(source);
            JRSTGenerator gen = new JRSTGenerator();
            String xsl = "/xsl/rst2xdoc.xsl";
            URL stylesheet = Resource.getURL((String)xsl);
            if (stylesheet == null) {
                throw new FileNotFoundException("Can't find stylesheet: " + xsl);
            }
            gen.setUriResolver((URIResolver)new JRSTResourceResolver(xsl));
            doc = gen.transform(doc, stylesheet, new String[0]);
            StringReader reader = new StringReader(doc.asXML());
            super.parse((Reader)reader, sink);
        }
        catch (Exception e) {
            throw new ParseException("Can't parse rst file", e);
        }
    }
}

