/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.jredmine;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Date;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import junit.framework.Assert;
import org.nuiton.io.rest.DefaultRestClientConfiguration;
import org.nuiton.io.rest.RestClientConfiguration;
import org.nuiton.io.xpp3.AbstractXpp3Reader;
import org.nuiton.io.xpp3.PropertyMapper;
import org.nuiton.io.xpp3.Xpp3Helper;
import org.nuiton.jredmine.model.Attachment;
import org.nuiton.jredmine.model.Issue;
import org.nuiton.jredmine.model.IssueCategory;
import org.nuiton.jredmine.model.IssuePriority;
import org.nuiton.jredmine.model.IssueStatus;
import org.nuiton.jredmine.model.News;
import org.nuiton.jredmine.model.Project;
import org.nuiton.jredmine.model.RedmineModelEnum;
import org.nuiton.jredmine.model.TimeEntry;
import org.nuiton.jredmine.model.Tracker;
import org.nuiton.jredmine.model.User;
import org.nuiton.jredmine.model.Version;
import org.nuiton.jredmine.model.io.xpp3.RedmineDataConverter;

public abstract class TestHelper {
    protected static File basedir;
    protected static RestClientConfiguration DEFAULT_CONFIGURATION;
    protected static Properties defaultConfig;
    protected static Properties userConfig;
    protected static EnumMap<RedmineModelEnum, List<?>> memoryModel;

    public static void initDefaultConfiguration() throws IOException {
        if (DEFAULT_CONFIGURATION != null) {
            return;
        }
        InputStream stream = TestHelper.class.getResourceAsStream("/test-config.properties");
        defaultConfig = new Properties();
        defaultConfig.load(stream);
        userConfig = new Properties(defaultConfig);
        for (String key : System.getenv().keySet()) {
            String env = System.getenv(key);
            if (!key.startsWith("test.") || env == null || env.trim().isEmpty()) continue;
            userConfig.setProperty(key, env);
        }
        DefaultRestClientConfiguration configuration = new DefaultRestClientConfiguration();
        String url = userConfig.getProperty("test.redmineUrl");
        configuration.setRestUrl(new URL(url));
        String username = userConfig.getProperty("test.redmineUsername");
        configuration.setRestUsername(username);
        String password = userConfig.getProperty("test.redminePassword");
        configuration.setRestPassword(password);
        String e = userConfig.getProperty("test.encoding");
        configuration.setEncoding(e);
        String v = userConfig.getProperty("test.verbose");
        configuration.setVerbose(Boolean.valueOf(v).booleanValue());
        if (configuration.isVerbose()) {
            System.out.println("default properties ==============================");
            defaultConfig.list(System.out);
            System.out.println("users   properties ==============================");
            userConfig.list(System.out);
        }
        System.out.println("DEFAULT CONFIGURATION :\n" + configuration);
        DEFAULT_CONFIGURATION = configuration;
    }

    public static RestClientConfiguration getTestConfiguration() throws IOException {
        if (DEFAULT_CONFIGURATION == null) {
            TestHelper.initDefaultConfiguration();
        }
        DefaultRestClientConfiguration configuration = new DefaultRestClientConfiguration();
        TestHelper.copyConfiguration(DEFAULT_CONFIGURATION, (RestClientConfiguration)configuration);
        if (TestHelper.isVerbose()) {
            System.out.println("will use configuration : " + configuration);
        }
        return configuration;
    }

    public static void copyConfiguration(RestClientConfiguration src, RestClientConfiguration dst) {
        if (src.getRestUrl() != null) {
            dst.setRestUrl(src.getRestUrl());
        }
        if (src.getRestUsername() != null) {
            dst.setRestUsername(src.getRestUsername());
        }
        if (src.getRestPassword() != null) {
            dst.setRestPassword(src.getRestPassword());
        }
        if (src.getEncoding() != null) {
            dst.setEncoding(src.getEncoding());
        }
        dst.setVerbose(src.isVerbose());
    }

    public static File getBasedir() {
        if (basedir == null) {
            String path = System.getenv("basedir");
            basedir = new File(path == null ? new File("").getAbsolutePath() : path);
            if (TestHelper.isVerbose()) {
                System.out.println("basedir = " + basedir.getAbsolutePath());
            }
        }
        return basedir;
    }

    public static void setBasedir(File basedir) {
        TestHelper.basedir = basedir;
    }

    public static boolean isVerbose() {
        if (DEFAULT_CONFIGURATION == null) {
            try {
                TestHelper.initDefaultConfiguration();
            }
            catch (IOException ex) {
                throw new RuntimeException(ex);
            }
        }
        return DEFAULT_CONFIGURATION.isVerbose();
    }

    public static File getTestDir(String type, String prefix) {
        String rep = type;
        rep = rep.replaceAll("\\.", File.separator);
        File f = new File(TestHelper.getBasedir(), prefix);
        File testDir = new File(f, rep);
        return testDir;
    }

    public static File getFile(File base, String ... paths) {
        StringBuilder buffer = new StringBuilder();
        for (String path : paths) {
            buffer.append(File.separator).append(path);
        }
        File f = new File(base, buffer.substring(1));
        return f;
    }

    public static String getRelativePath(File base, File file) {
        String result = file.getAbsolutePath().substring(base.getAbsolutePath().length() + 1);
        return result;
    }

    public static List<Attachment> getAttachments() {
        return TestHelper.getModel(Attachment.class);
    }

    public static List<Issue> getIssues() {
        return TestHelper.getModel(Issue.class);
    }

    public static List<Project> getProjects() {
        return TestHelper.getModel(Project.class);
    }

    public static List<Tracker> getTrackers() {
        return TestHelper.getModel(Tracker.class);
    }

    public static List<User> getUsers() {
        return TestHelper.getModel(User.class);
    }

    public static List<Version> getVersions() {
        return TestHelper.getModel(Version.class);
    }

    public static <T> List<T> getModel(Class<T> type) {
        if (memoryModel == null) {
            try {
                TestHelper.loadMemoryModel();
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
        }
        return memoryModel.get(RedmineModelEnum.valueOf(type));
    }

    public static void tearDownClass() throws Exception {
        if (memoryModel != null) {
            memoryModel.clear();
            memoryModel = null;
        }
    }

    public static <T> void assertMyListEquals(Class<T> type, List<T> expecteds, T ... actuals) throws Exception {
        Assert.assertNotNull(actuals);
        Assert.assertEquals((int)expecteds.size(), (int)actuals.length);
        int j = expecteds.size();
        for (int i = 0; i < j; ++i) {
            T actual = actuals[i];
            T expected = expecteds.get(i);
            TestHelper.assertMyEquals(type, expected, actual);
        }
    }

    public static void assertMyEquals(Class<?> type, Object expected, Object actual) throws Exception {
        Assert.assertNotNull((Object)expected);
        Assert.assertNotNull((Object)actual);
        AbstractXpp3Reader reader = (AbstractXpp3Reader)Xpp3Helper.getReader(type);
        Map mappers = reader.getMappers(type);
        for (PropertyMapper m : mappers.values()) {
            Object expectedValue = m.getDescriptor().getReadMethod().invoke(expected, new Object[0]);
            Object actualValue = m.getDescriptor().getReadMethod().invoke(actual, new Object[0]);
            Assert.assertEquals((String)("error in attribute " + m.getPropertyName() + " for " + expected), (Object)expectedValue, (Object)actualValue);
        }
    }

    public static EnumMap<RedmineModelEnum, List<?>> getMemoryModel() {
        return memoryModel;
    }

    public static void loadMemoryModel() throws Exception {
        memoryModel = new EnumMap(RedmineModelEnum.class);
        ArrayList<Object> list = new ArrayList<Object>();
        Attachment tempA = new Attachment();
        tempA.setAuthorId(((Integer)RedmineDataConverter.Integer.convert("4")).intValue());
        tempA.setContainerId(((Integer)RedmineDataConverter.Integer.convert("1")).intValue());
        tempA.setId(((Integer)RedmineDataConverter.Integer.convert("1")).intValue());
        tempA.setFilesize(((Integer)RedmineDataConverter.Integer.convert("411")).intValue());
        tempA.setDownloads(((Integer)RedmineDataConverter.Integer.convert("0")).intValue());
        tempA.setCreatedOn((Date)RedmineDataConverter.Datetime.convert("2009-09-05T12:56:41+02:00"));
        tempA.setContainerType((String)RedmineDataConverter.Text.convert("Version"));
        tempA.setContentType((String)RedmineDataConverter.Text.convert("application/json"));
        tempA.setDigest((String)RedmineDataConverter.Text.convert("6ea84342c7475c05fb077b4aca832f9a"));
        tempA.setDiskFilename((String)RedmineDataConverter.Text.convert("090905125641_get_issue.json"));
        tempA.setFilename((String)RedmineDataConverter.Text.convert("get_issue.json"));
        list.add(tempA);
        tempA = new Attachment();
        tempA.setAuthorId(((Integer)RedmineDataConverter.Integer.convert("4")).intValue());
        tempA.setContainerId(((Integer)RedmineDataConverter.Integer.convert("1")).intValue());
        tempA.setId(((Integer)RedmineDataConverter.Integer.convert("1")).intValue());
        tempA.setFilesize(((Integer)RedmineDataConverter.Integer.convert("411")).intValue());
        tempA.setDownloads(((Integer)RedmineDataConverter.Integer.convert("0")).intValue());
        tempA.setCreatedOn((Date)RedmineDataConverter.Datetime.convert("2009-09-05T12:56:41+02:00"));
        tempA.setContainerType((String)RedmineDataConverter.Text.convert("Version"));
        tempA.setContentType((String)RedmineDataConverter.Text.convert("application/json"));
        tempA.setDigest((String)RedmineDataConverter.Text.convert("6ea84342c7475c05fb077b4aca832f9a"));
        tempA.setDiskFilename((String)RedmineDataConverter.Text.convert("090905125641_get_issue.json2"));
        tempA.setFilename((String)RedmineDataConverter.Text.convert("get_issue.json2"));
        list.add(tempA);
        memoryModel.put(RedmineModelEnum.attachment, list);
        list = new ArrayList();
        Issue tempI = new Issue();
        tempI.setAuthorId(((Integer)RedmineDataConverter.Integer.convert("5")).intValue());
        tempI.setCategoryId(((Integer)RedmineDataConverter.Integer.convert("2")).intValue());
        tempI.setDoneRatio(((Integer)RedmineDataConverter.Integer.convert("0")).intValue());
        tempI.setLockVersion(((Integer)RedmineDataConverter.Integer.convert("7")).intValue());
        tempI.setPriorityId(((Integer)RedmineDataConverter.Integer.convert("4")).intValue());
        tempI.setProjectId(((Integer)RedmineDataConverter.Integer.convert("1")).intValue());
        tempI.setStatusId(((Integer)RedmineDataConverter.Integer.convert("3")).intValue());
        tempI.setTrackerId(((Integer)RedmineDataConverter.Integer.convert("1")).intValue());
        tempI.setFixedVersionId(((Integer)RedmineDataConverter.Integer.convert("1")).intValue());
        tempI.setId(((Integer)RedmineDataConverter.Integer.convert("3")).intValue());
        tempI.setParentId(((Integer)RedmineDataConverter.Integer.convert("3")).intValue());
        tempI.setRootId(((Integer)RedmineDataConverter.Integer.convert("3")).intValue());
        tempI.setLft(((Integer)RedmineDataConverter.Integer.convert("1")).intValue());
        tempI.setRgt(((Integer)RedmineDataConverter.Integer.convert("2")).intValue());
        tempI.setCreatedOn((Date)RedmineDataConverter.Datetime.convert("2009-09-04T20:11:52+02:00"));
        tempI.setUpdatedOn((Date)RedmineDataConverter.Datetime.convert("2009-09-06T00:37:40+02:00"));
        tempI.setStartDate((Date)RedmineDataConverter.Date.convert("2009-09-04"));
        tempI.setDescription((String)RedmineDataConverter.Text.convert("avec une description !"));
        tempI.setSubject((String)RedmineDataConverter.Text.convert("yes!"));
        list.add(tempI);
        tempI = new Issue();
        tempI.setAuthorId(((Integer)RedmineDataConverter.Integer.convert("5")).intValue());
        tempI.setCategoryId(((Integer)RedmineDataConverter.Integer.convert("2")).intValue());
        tempI.setDoneRatio(((Integer)RedmineDataConverter.Integer.convert("0")).intValue());
        tempI.setLockVersion(((Integer)RedmineDataConverter.Integer.convert("7")).intValue());
        tempI.setPriorityId(((Integer)RedmineDataConverter.Integer.convert("4")).intValue());
        tempI.setProjectId(((Integer)RedmineDataConverter.Integer.convert("1")).intValue());
        tempI.setStatusId(((Integer)RedmineDataConverter.Integer.convert("3")).intValue());
        tempI.setTrackerId(((Integer)RedmineDataConverter.Integer.convert("1")).intValue());
        tempI.setFixedVersionId(((Integer)RedmineDataConverter.Integer.convert("1")).intValue());
        tempI.setId(((Integer)RedmineDataConverter.Integer.convert("4")).intValue());
        tempI.setCreatedOn((Date)RedmineDataConverter.Datetime.convert("2009-09-04T20:11:52+02:00"));
        tempI.setUpdatedOn((Date)RedmineDataConverter.Datetime.convert("2009-09-06T00:37:40+02:00"));
        tempI.setStartDate((Date)RedmineDataConverter.Date.convert("2009-09-04"));
        tempI.setDescription((String)RedmineDataConverter.Text.convert("avec une description !2"));
        tempI.setSubject((String)RedmineDataConverter.Text.convert("yes!2"));
        list.add(tempI);
        memoryModel.put(RedmineModelEnum.issue, list);
        list = new ArrayList();
        Project tempP = new Project();
        tempP.setCreatedOn((Date)RedmineDataConverter.Datetime.convert("2009-09-04T18:11:54+02:00"));
        tempP.setUpdatedOn((Date)RedmineDataConverter.Datetime.convert("2009-09-04T18:11:54+02:00"));
        tempP.setIdentifier((String)RedmineDataConverter.Text.convert("one"));
        tempP.setName((String)RedmineDataConverter.Text.convert("one"));
        tempP.setId(((Integer)RedmineDataConverter.Integer.convert("1")).intValue());
        tempP.setLft(((Integer)RedmineDataConverter.Integer.convert("1")).intValue());
        tempP.setRgt(((Integer)RedmineDataConverter.Integer.convert("2")).intValue());
        tempP.setProjectsCount(((Integer)RedmineDataConverter.Integer.convert("0")).intValue());
        tempP.setStatus(((Integer)RedmineDataConverter.Integer.convert("1")).intValue());
        tempP.setIsPublic(((Boolean)RedmineDataConverter.Boolean.convert("true")).booleanValue());
        list.add(tempP);
        tempP = new Project();
        tempP.setCreatedOn((Date)RedmineDataConverter.Datetime.convert("2009-09-05T16:22:14+02:00"));
        tempP.setUpdatedOn((Date)RedmineDataConverter.Datetime.convert("2009-09-05T16:22:29+02:00"));
        tempP.setIdentifier((String)RedmineDataConverter.Text.convert("two"));
        tempP.setName((String)RedmineDataConverter.Text.convert("two"));
        tempP.setId(((Integer)RedmineDataConverter.Integer.convert("2")).intValue());
        tempP.setProjectsCount(((Integer)RedmineDataConverter.Integer.convert("0")).intValue());
        tempP.setStatus(((Integer)RedmineDataConverter.Integer.convert("1")).intValue());
        tempP.setIsPublic(((Boolean)RedmineDataConverter.Boolean.convert("false")).booleanValue());
        list.add(tempP);
        memoryModel.put(RedmineModelEnum.project, list);
        list = new ArrayList();
        Tracker tempT = new Tracker();
        tempT.setId(((Integer)RedmineDataConverter.Integer.convert("1")).intValue());
        tempT.setProjectId(((Integer)RedmineDataConverter.Integer.convert("1")).intValue());
        tempT.setTrackerId(((Integer)RedmineDataConverter.Integer.convert("1")).intValue());
        tempT.setPosition(((Integer)RedmineDataConverter.Integer.convert("1")).intValue());
        tempT.setIsInChlog(((Boolean)RedmineDataConverter.Boolean.convert("true")).booleanValue());
        tempT.setIsInRoadmap(((Boolean)RedmineDataConverter.Boolean.convert("false")).booleanValue());
        tempT.setName((String)RedmineDataConverter.Text.convert("Anomalie"));
        list.add(tempT);
        tempT = new Tracker();
        tempT.setId(((Integer)RedmineDataConverter.Integer.convert("2")).intValue());
        tempT.setIsInChlog(((Boolean)RedmineDataConverter.Boolean.convert("true")).booleanValue());
        tempT.setIsInRoadmap(((Boolean)RedmineDataConverter.Boolean.convert("true")).booleanValue());
        tempT.setName((String)RedmineDataConverter.Text.convert("Evolution"));
        tempT.setPosition(((Integer)RedmineDataConverter.Integer.convert("2")).intValue());
        tempT.setProjectId(((Integer)RedmineDataConverter.Integer.convert("1")).intValue());
        tempT.setTrackerId(((Integer)RedmineDataConverter.Integer.convert("2")).intValue());
        list.add(tempT);
        tempT = new Tracker();
        tempT.setId(((Integer)RedmineDataConverter.Integer.convert("3")).intValue());
        tempT.setIsInChlog(((Boolean)RedmineDataConverter.Boolean.convert("false")).booleanValue());
        tempT.setIsInRoadmap(((Boolean)RedmineDataConverter.Boolean.convert("false")).booleanValue());
        tempT.setName((String)RedmineDataConverter.Text.convert("Assistance"));
        tempT.setPosition(((Integer)RedmineDataConverter.Integer.convert("3")).intValue());
        tempT.setProjectId(((Integer)RedmineDataConverter.Integer.convert("1")).intValue());
        tempT.setTrackerId(((Integer)RedmineDataConverter.Integer.convert("3")).intValue());
        list.add(tempT);
        memoryModel.put(RedmineModelEnum.tracker, list);
        list = new ArrayList();
        User tempU = new User();
        tempU.setCreatedOn((Date)RedmineDataConverter.Datetime.convert("2009-09-04T17:24:46+02:00"));
        tempU.setUpdatedOn((Date)RedmineDataConverter.Datetime.convert("2009-09-06T01:23:59+02:00"));
        tempU.setLastLoginOn((Date)RedmineDataConverter.Datetime.convert("2009-09-06T01:23:59+02:00"));
        tempU.setId(((Integer)RedmineDataConverter.Integer.convert("1")).intValue());
        tempU.setMemberId(((Integer)RedmineDataConverter.Integer.convert("5")).intValue());
        tempU.setRoleId(((Integer)RedmineDataConverter.Integer.convert("3")).intValue());
        tempU.setStatus(((Integer)RedmineDataConverter.Integer.convert("1")).intValue());
        tempU.setAdmin(((Boolean)RedmineDataConverter.Boolean.convert("true")).booleanValue());
        tempU.setMailNotification(((Boolean)RedmineDataConverter.Boolean.convert("true")).booleanValue());
        tempU.setFirstname((String)RedmineDataConverter.Text.convert("Redmine"));
        tempU.setHashedPassword((String)RedmineDataConverter.Text.convert("70c881d4a26984ddce795f6f71817c9cf4480e79"));
        tempU.setLanguage((String)RedmineDataConverter.Text.convert("fr"));
        tempU.setLastname((String)RedmineDataConverter.Text.convert("Admin"));
        tempU.setLogin((String)RedmineDataConverter.Text.convert("admin"));
        tempU.setMail((String)RedmineDataConverter.Text.convert("dummy@codelutin.com"));
        tempU.setIdentityUrl((String)RedmineDataConverter.Text.convert("yo"));
        list.add(tempU);
        tempU = new User();
        tempU.setAdmin(((Boolean)RedmineDataConverter.Boolean.convert("true")).booleanValue());
        tempU.setCreatedOn((Date)RedmineDataConverter.Datetime.convert("2009-09-04T19:49:02+02:00"));
        tempU.setFirstname((String)RedmineDataConverter.Text.convert("tony"));
        tempU.setHashedPassword((String)RedmineDataConverter.Text.convert("8aed1322e5450badb078e1fb60a817a1df25a2ca"));
        tempU.setId(((Integer)RedmineDataConverter.Integer.convert("5")).intValue());
        tempU.setLanguage((String)RedmineDataConverter.Text.convert("fr"));
        tempU.setLastLoginOn((Date)RedmineDataConverter.Datetime.convert("2009-09-04T19:49:38+02:00"));
        tempU.setLastname((String)RedmineDataConverter.Text.convert("chemit2"));
        tempU.setLogin((String)RedmineDataConverter.Text.convert("tchemit2"));
        tempU.setMail((String)RedmineDataConverter.Text.convert("chemit@codelutin.com"));
        tempU.setMailNotification(((Boolean)RedmineDataConverter.Boolean.convert("false")).booleanValue());
        tempU.setMemberId(((Integer)RedmineDataConverter.Integer.convert("4")).intValue());
        tempU.setRoleId(((Integer)RedmineDataConverter.Integer.convert("3")).intValue());
        tempU.setStatus(((Integer)RedmineDataConverter.Integer.convert("1")).intValue());
        tempU.setUpdatedOn((Date)RedmineDataConverter.Datetime.convert("2009-09-04T19:49:38+02:00"));
        list.add(tempU);
        tempU = new User();
        tempU.setAdmin(((Boolean)RedmineDataConverter.Boolean.convert("false")).booleanValue());
        tempU.setCreatedOn((Date)RedmineDataConverter.Datetime.convert("2009-09-05T16:24:11+02:00"));
        tempU.setFirstname((String)RedmineDataConverter.Text.convert("dev"));
        tempU.setHashedPassword((String)RedmineDataConverter.Text.convert("70c881d4a26984ddce795f6f71817c9cf4480e79"));
        tempU.setId(((Integer)RedmineDataConverter.Integer.convert("7")).intValue());
        tempU.setLanguage((String)RedmineDataConverter.Text.convert("fr"));
        tempU.setLastLoginOn((Date)RedmineDataConverter.Datetime.convert("2009-09-06T16:34:39+02:00"));
        tempU.setLastname((String)RedmineDataConverter.Text.convert("dev"));
        tempU.setLogin((String)RedmineDataConverter.Text.convert("dev"));
        tempU.setMail((String)RedmineDataConverter.Text.convert("dev3@ynot-home.info"));
        tempU.setMailNotification(((Boolean)RedmineDataConverter.Boolean.convert("false")).booleanValue());
        tempU.setMemberId(((Integer)RedmineDataConverter.Integer.convert("9")).intValue());
        tempU.setRoleId(((Integer)RedmineDataConverter.Integer.convert("4")).intValue());
        tempU.setStatus(((Integer)RedmineDataConverter.Integer.convert("1")).intValue());
        tempU.setUpdatedOn((Date)RedmineDataConverter.Datetime.convert("2009-09-06T16:34:39+02:00"));
        list.add(tempU);
        memoryModel.put(RedmineModelEnum.user, list);
        list = new ArrayList();
        Version tempV = new Version();
        tempV.setCreatedOn((Date)RedmineDataConverter.Datetime.convert("2009-09-06T02:47:39+02:00"));
        tempV.setDescription((String)RedmineDataConverter.Text.convert("yo"));
        tempV.setId(((Integer)RedmineDataConverter.Integer.convert("9")).intValue());
        tempV.setName((String)RedmineDataConverter.Text.convert("yor"));
        tempV.setSharing((String)RedmineDataConverter.Text.convert("none"));
        tempV.setStatus((String)RedmineDataConverter.Text.convert("open"));
        tempV.setProjectId(((Integer)RedmineDataConverter.Integer.convert("1")).intValue());
        tempV.setUpdatedOn((Date)RedmineDataConverter.Datetime.convert("2009-09-06T02:50:49+02:00"));
        list.add(tempV);
        tempV = new Version();
        tempV.setCreatedOn((Date)RedmineDataConverter.Datetime.convert("2009-09-06T03:05:09+02:00"));
        tempV.setDescription((String)RedmineDataConverter.Text.convert("ysssoye"));
        tempV.setId(((Integer)RedmineDataConverter.Integer.convert("13")).intValue());
        tempV.setName((String)RedmineDataConverter.Text.convert("rrrrrrrrrouuuuuua"));
        tempV.setProjectId(((Integer)RedmineDataConverter.Integer.convert("1")).intValue());
        tempV.setUpdatedOn((Date)RedmineDataConverter.Datetime.convert("2009-09-06T03:05:09+02:00"));
        list.add(tempV);
        tempV = new Version();
        tempV.setCreatedOn((Date)RedmineDataConverter.Datetime.convert("2009-09-06T03:07:58+02:00"));
        tempV.setDescription((String)RedmineDataConverter.Text.convert("ysssoye"));
        tempV.setId(((Integer)RedmineDataConverter.Integer.convert("15")).intValue());
        tempV.setName((String)RedmineDataConverter.Text.convert("aaaauuuuuua"));
        tempV.setProjectId(((Integer)RedmineDataConverter.Integer.convert("1")).intValue());
        tempV.setUpdatedOn((Date)RedmineDataConverter.Datetime.convert("2009-09-06T03:07:58+02:00"));
        list.add(tempV);
        tempV = new Version();
        tempV.setCreatedOn((Date)RedmineDataConverter.Datetime.convert("2009-09-06T04:12:25+02:00"));
        tempV.setDescription((String)RedmineDataConverter.Text.convert("ysssoyeppppppppppppppppp"));
        tempV.setId(((Integer)RedmineDataConverter.Integer.convert("16")).intValue());
        tempV.setName((String)RedmineDataConverter.Text.convert("aaaau"));
        tempV.setProjectId(((Integer)RedmineDataConverter.Integer.convert("1")).intValue());
        tempV.setUpdatedOn((Date)RedmineDataConverter.Datetime.convert("2009-09-06T04:13:20+02:00"));
        list.add(tempV);
        tempV = new Version();
        tempV.setCreatedOn((Date)RedmineDataConverter.Datetime.convert("2009-09-06T03:05:40+02:00"));
        tempV.setDescription((String)RedmineDataConverter.Text.convert("ysssoye"));
        tempV.setId(((Integer)RedmineDataConverter.Integer.convert("14")).intValue());
        tempV.setName((String)RedmineDataConverter.Text.convert("aaaaaaaaaarrrrrrrrrouuuuuua"));
        tempV.setProjectId(((Integer)RedmineDataConverter.Integer.convert("1")).intValue());
        tempV.setUpdatedOn((Date)RedmineDataConverter.Datetime.convert("2009-09-06T03:05:40+02:00"));
        list.add(tempV);
        tempV = new Version();
        tempV.setCreatedOn((Date)RedmineDataConverter.Datetime.convert("2009-09-05T00:39:15+02:00"));
        tempV.setId(((Integer)RedmineDataConverter.Integer.convert("5")).intValue());
        tempV.setName((String)RedmineDataConverter.Text.convert("2"));
        tempV.setProjectId(((Integer)RedmineDataConverter.Integer.convert("1")).intValue());
        tempV.setUpdatedOn((Date)RedmineDataConverter.Datetime.convert("2009-09-05T00:39:15+02:00"));
        list.add(tempV);
        tempV = new Version();
        tempV.setCreatedOn((Date)RedmineDataConverter.Datetime.convert("2009-09-04T18:13:05+02:00"));
        tempV.setId(((Integer)RedmineDataConverter.Integer.convert("1")).intValue());
        tempV.setName((String)RedmineDataConverter.Text.convert("1.0.0"));
        tempV.setProjectId(((Integer)RedmineDataConverter.Integer.convert("1")).intValue());
        tempV.setUpdatedOn((Date)RedmineDataConverter.Datetime.convert("2009-09-04T18:13:05+02:00"));
        list.add(tempV);
        tempV = new Version();
        tempV.setCreatedOn((Date)RedmineDataConverter.Datetime.convert("2009-09-06T03:00:12+02:00"));
        tempV.setDescription((String)RedmineDataConverter.Text.convert("yoye"));
        tempV.setEffectiveDate((Date)RedmineDataConverter.Date.convert("2009-09-06"));
        tempV.setId(((Integer)RedmineDataConverter.Integer.convert("11")).intValue());
        tempV.setName((String)RedmineDataConverter.Text.convert("yaouuuuuua"));
        tempV.setProjectId(((Integer)RedmineDataConverter.Integer.convert("1")).intValue());
        tempV.setUpdatedOn((Date)RedmineDataConverter.Datetime.convert("2009-09-06T03:00:12+02:00"));
        list.add(tempV);
        tempV = new Version();
        tempV.setCreatedOn((Date)RedmineDataConverter.Datetime.convert("2009-09-06T02:50:59+02:00"));
        tempV.setDescription((String)RedmineDataConverter.Text.convert("yoye"));
        tempV.setEffectiveDate((Date)RedmineDataConverter.Date.convert("2009-09-06"));
        tempV.setId(((Integer)RedmineDataConverter.Integer.convert("10")).intValue());
        tempV.setName((String)RedmineDataConverter.Text.convert("ya"));
        tempV.setProjectId(((Integer)RedmineDataConverter.Integer.convert("1")).intValue());
        tempV.setUpdatedOn((Date)RedmineDataConverter.Datetime.convert("2009-09-06T02:54:16+02:00"));
        list.add(tempV);
        tempV = new Version();
        tempV.setCreatedOn((Date)RedmineDataConverter.Datetime.convert("2009-09-06T03:00:37+02:00"));
        tempV.setDescription((String)RedmineDataConverter.Text.convert("ysssoye"));
        tempV.setEffectiveDate((Date)RedmineDataConverter.Date.convert("2009-09-06"));
        tempV.setId(((Integer)RedmineDataConverter.Integer.convert("12")).intValue());
        tempV.setName((String)RedmineDataConverter.Text.convert("ouuuuuua"));
        tempV.setProjectId(((Integer)RedmineDataConverter.Integer.convert("1")).intValue());
        tempV.setUpdatedOn((Date)RedmineDataConverter.Datetime.convert("2009-09-06T03:00:42+02:00"));
        list.add(tempV);
        memoryModel.put(RedmineModelEnum.version, list);
        list = new ArrayList();
        IssueStatus tempIS = new IssueStatus();
        tempIS.setId(1);
        tempIS.setName("Nouveau");
        tempIS.setPosition(1);
        tempIS.setDefaultDoneRatio(10);
        tempIS.setIsClosed(false);
        tempIS.setIsDefault(true);
        list.add(tempIS);
        tempIS = new IssueStatus();
        tempIS.setId(2);
        tempIS.setName("Assign\u00e9");
        tempIS.setPosition(2);
        tempIS.setIsClosed(false);
        tempIS.setIsDefault(false);
        list.add(tempIS);
        tempIS = new IssueStatus();
        tempIS.setId(3);
        tempIS.setName("R\u00e9solu");
        tempIS.setPosition(3);
        tempIS.setIsClosed(false);
        tempIS.setIsDefault(false);
        list.add(tempIS);
        tempIS = new IssueStatus();
        tempIS.setId(4);
        tempIS.setName("Commentaire");
        tempIS.setPosition(4);
        tempIS.setIsClosed(false);
        tempIS.setIsDefault(false);
        list.add(tempIS);
        tempIS = new IssueStatus();
        tempIS.setId(5);
        tempIS.setName("Ferm\u00e9");
        tempIS.setPosition(5);
        tempIS.setIsClosed(true);
        tempIS.setIsDefault(false);
        list.add(tempIS);
        tempIS = new IssueStatus();
        tempIS.setId(6);
        tempIS.setPosition(6);
        tempIS.setName("Rejet\u00e9");
        tempIS.setIsClosed(true);
        tempIS.setIsDefault(false);
        list.add(tempIS);
        memoryModel.put(RedmineModelEnum.issueStatus, list);
        list = new ArrayList();
        IssuePriority tempIP = new IssuePriority();
        tempIP.setId(3);
        tempIP.setParentId(1);
        tempIP.setProjectId(2);
        tempIP.setName("Bas");
        tempIP.setPosition(1);
        tempIP.setOpt("IPRI");
        tempIP.setIsDefault(false);
        tempIP.setActive(true);
        list.add(tempIP);
        tempIP = new IssuePriority();
        tempIP.setId(4);
        tempIP.setName("Normal");
        tempIP.setPosition(2);
        tempIP.setOpt("IPRI");
        tempIP.setIsDefault(true);
        list.add(tempIP);
        tempIP = new IssuePriority();
        tempIP.setId(5);
        tempIP.setName("Haut");
        tempIP.setPosition(3);
        tempIP.setOpt("IPRI");
        tempIP.setIsDefault(false);
        list.add(tempIP);
        tempIP = new IssuePriority();
        tempIP.setId(6);
        tempIP.setName("Urgent");
        tempIP.setPosition(4);
        tempIP.setOpt("IPRI");
        tempIP.setIsDefault(false);
        list.add(tempIP);
        tempIP = new IssuePriority();
        tempIP.setId(7);
        tempIP.setName("Imm\u00e9diat");
        tempIP.setPosition(5);
        tempIP.setOpt("IPRI");
        tempIP.setIsDefault(false);
        list.add(tempIP);
        memoryModel.put(RedmineModelEnum.issuePriority, list);
        list = new ArrayList();
        IssueCategory tempIC = new IssueCategory();
        tempIC.setId(1);
        tempIC.setName("categorie one");
        tempIC.setProjectId(1);
        list.add(tempIC);
        tempIC = new IssueCategory();
        tempIC.setId(2);
        tempIC.setName("categorie two");
        tempIC.setProjectId(1);
        list.add(tempIC);
        memoryModel.put(RedmineModelEnum.issueCategory, list);
        list = new ArrayList();
        News tempN = new News();
        tempN.setId(85);
        tempN.setCreatedOn((Date)RedmineDataConverter.Datetime.convert("2009-09-17T21:50:26+02:00"));
        tempN.setProjectId(1);
        tempN.setAuthorId(4);
        tempN.setCommentsCount(0);
        tempN.setDescription("description");
        tempN.setSummary("summary");
        tempN.setTitle("title");
        list.add(tempN);
        tempN = new News();
        tempN.setId(86);
        tempN.setCreatedOn((Date)RedmineDataConverter.Datetime.convert("2009-09-17T21:55:26+02:00"));
        tempN.setProjectId(1);
        tempN.setAuthorId(4);
        tempN.setCommentsCount(0);
        tempN.setDescription("description2");
        tempN.setSummary("summary2");
        tempN.setTitle("title2");
        list.add(tempN);
        memoryModel.put(RedmineModelEnum.news, list);
        list = new ArrayList();
        TimeEntry tempE = new TimeEntry();
        tempE.setCreatedOn((Date)RedmineDataConverter.Datetime.convert("2009-12-31T23:02:02+01:00"));
        tempE.setUpdatedOn((Date)RedmineDataConverter.Datetime.convert("2009-12-31T23:02:02+01:00"));
        tempE.setSpentOn((Date)RedmineDataConverter.Date.convert("2009-12-31"));
        tempE.setId(1);
        tempE.setProjectId(1);
        tempE.setUserId(4);
        tempE.setIssueId(6);
        tempE.setActivityId(8);
        tempE.setHours(1.0f);
        tempE.setTmonth(12);
        tempE.setTyear(2009);
        tempE.setTweek(53);
        tempE.setComments("Test");
        list.add(tempE);
        tempE = new TimeEntry();
        tempE.setCreatedOn((Date)RedmineDataConverter.Datetime.convert("2009-12-31T23:10:01+01:00"));
        tempE.setUpdatedOn((Date)RedmineDataConverter.Datetime.convert("2009-12-31T23:10:01+01:00"));
        tempE.setSpentOn((Date)RedmineDataConverter.Date.convert("2009-12-31"));
        tempE.setId(2);
        tempE.setProjectId(1);
        tempE.setUserId(4);
        tempE.setIssueId(6);
        tempE.setActivityId(9);
        tempE.setHours(2.0f);
        tempE.setTmonth(12);
        tempE.setTyear(2009);
        tempE.setTweek(53);
        tempE.setComments("deuxi\u00e8me temps");
        list.add(tempE);
        memoryModel.put(RedmineModelEnum.timeEntry, list);
    }
}

