/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.jredmine;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.io.rest.RestClient;
import org.nuiton.io.rest.RestClientConfiguration;
import org.nuiton.jredmine.DefaultRedmineAnonymousService;
import org.nuiton.jredmine.RedmineService;
import org.nuiton.jredmine.RedmineServiceException;
import org.nuiton.jredmine.RedmineServiceImplementor;
import org.nuiton.jredmine.model.Attachment;
import org.nuiton.jredmine.model.News;
import org.nuiton.jredmine.model.Project;
import org.nuiton.jredmine.model.TimeEntry;
import org.nuiton.jredmine.model.Version;
import org.nuiton.jredmine.rest.RedmineRestClient;

public class DefaultRedmineService
extends DefaultRedmineAnonymousService
implements RedmineService {
    protected static final Log log = LogFactory.getLog(DefaultRedmineService.class);

    @Override
    public RedmineServiceImplementor init(RestClientConfiguration configuration) throws RedmineServiceException {
        RedmineServiceImplementor result = this.delegateImplementor.init(configuration);
        return result;
    }

    @Override
    public RedmineServiceImplementor init(RestClient session) throws RedmineServiceException {
        return this.delegateImplementor.init(session);
    }

    @Override
    public Project[] getUserProjects() throws RedmineServiceException {
        this.checkLoggued();
        Project[] result = this.getDatas(RedmineRestClient.GET_USER_PROJECTS, Project.class, new Object[0]);
        return result;
    }

    @Override
    public Version addVersion(String projectName, Version version) throws RedmineServiceException {
        Version result = this.sendData(RedmineRestClient.ADD_VERSION, Version.class, projectName, version);
        return result;
    }

    @Override
    public Version updateVersion(String projectName, Version version) throws RedmineServiceException {
        Version result = this.sendData(RedmineRestClient.UPDATE_VERSION, Version.class, projectName, version);
        return result;
    }

    @Override
    public Version nextVersion(String projectName, String oldVersionName, Version newVersion) throws RedmineServiceException {
        Version result = this.sendData(RedmineRestClient.NEXT_VERSION, Version.class, projectName, oldVersionName, newVersion);
        return result;
    }

    @Override
    public Attachment addAttachment(String projectName, String versionName, Attachment attachement) throws RedmineServiceException {
        Attachment result = this.sendData(RedmineRestClient.ADD_ATTACHMENT, Attachment.class, projectName, versionName, attachement);
        return result;
    }

    @Override
    public News addNews(String projectName, News news) throws RedmineServiceException {
        News result = this.sendData(RedmineRestClient.ADD_NEWS, News.class, projectName, news);
        return result;
    }

    @Override
    public TimeEntry addIssueTimeEntry(String projectName, String issueId, TimeEntry entry) throws RedmineServiceException {
        TimeEntry result = this.sendData(RedmineRestClient.ADD_ISSUE_TIME_ENTRY, TimeEntry.class, projectName, issueId, entry);
        return result;
    }
}

