/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.jpa.templates;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Set;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;
import javax.persistence.MappedSuperclass;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import javax.persistence.OrderColumn;
import javax.persistence.PrePersist;
import javax.persistence.Version;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.eugene.java.extension.ObjectModelAnnotation;
import org.nuiton.eugene.models.object.ObjectModel;
import org.nuiton.eugene.models.object.ObjectModelAttribute;
import org.nuiton.eugene.models.object.ObjectModelClass;
import org.nuiton.eugene.models.object.ObjectModelClassifier;
import org.nuiton.eugene.models.object.ObjectModelElement;
import org.nuiton.eugene.models.object.ObjectModelJavaModifier;
import org.nuiton.eugene.models.object.ObjectModelModifier;
import org.nuiton.eugene.models.object.ObjectModelOperation;
import org.nuiton.eugene.models.object.xml.ObjectModelAttributeImpl;
import org.nuiton.jpa.api.AbstractJpaEntity;
import org.nuiton.jpa.api.JpaEntities;
import org.nuiton.jpa.api.JpaEntityIdFactoryResolver;
import org.nuiton.jpa.api.JpaEntityVisitable;
import org.nuiton.jpa.api.JpaEntityVisitor;
import org.nuiton.jpa.templates.AbstractJpaTransformer;
import org.nuiton.jpa.templates.JpaTemplatesGeneratorUtil;

public class JpaEntityTransformer
extends AbstractJpaTransformer {
    private static final Log log = LogFactory.getLog(JpaEntityTransformer.class);
    public static final String PROPERTY_VERSION = "version";
    public static final String PROPERTY_CREATE_DATE = "createDate";

    public void transformFromClass(ObjectModelClass input) {
        boolean generateConcrete;
        String packageName = JpaTemplatesGeneratorUtil.getEntityPackage(this, (ObjectModel)this.model, (ObjectModelClassifier)input);
        String entityAbstractName = JpaTemplatesGeneratorUtil.getEntityAbstractName(input);
        String entityConcreteName = JpaTemplatesGeneratorUtil.getEntityConcreteName(input);
        boolean generateAbstract = !this.isInClassPath(packageName, entityAbstractName);
        boolean bl = generateConcrete = !this.isInClassPath(packageName, entityConcreteName);
        if (generateAbstract) {
            this.generateAbstract(input, packageName, entityAbstractName);
        }
        if (generateConcrete) {
            this.generateImpl(input, packageName, entityAbstractName, entityConcreteName);
        }
    }

    protected ObjectModelClass generateAbstract(ObjectModelClass input, String packageName, String entityAbstractName) {
        boolean hasAMultipleProperty;
        boolean generateVisitor;
        String superClass;
        boolean superClassIsEntity = this.isSuperClassEntity(input);
        if (superClassIsEntity) {
            ObjectModelClass superClassModel = (ObjectModelClass)input.getSuperclasses().iterator().next();
            superClass = JpaTemplatesGeneratorUtil.getEntityPackage(this, (ObjectModel)this.model, (ObjectModelClassifier)superClassModel) + "." + JpaTemplatesGeneratorUtil.getEntityConcreteName(superClassModel);
        } else {
            superClass = JpaTemplatesGeneratorUtil.getEntitySuperClassTagValue((ObjectModel)this.model, (ObjectModelClassifier)input);
            if (superClass == null) {
                superClass = AbstractJpaEntity.class.getName();
            } else {
                superClassIsEntity = true;
            }
        }
        ObjectModelClass output = this.createAbstractClass(entityAbstractName, packageName);
        this.setSuperClass(output, superClass);
        this.addAnnotation((ObjectModelClassifier)output, (ObjectModelElement)output, MappedSuperclass.class);
        String entityContractName = packageName + "." + input.getName() + "Entity";
        boolean addUserEntityContract = this.isInClassPath(entityContractName);
        if (addUserEntityContract) {
            this.addInterface((ObjectModelClassifier)output, entityContractName);
        }
        String prefix = this.getConstantPrefix((ObjectModelClassifier)input, "PROPERTY_");
        this.setConstantPrefix(prefix);
        boolean serializableFound = this.addInterfaces(input, output);
        if (superClassIsEntity) {
            serializableFound = true;
        }
        this.addSerializable(input, output, serializableFound);
        boolean useIdGenerator = JpaTemplatesGeneratorUtil.useIdFactory((ObjectModel)this.getModel());
        if (useIdGenerator) {
            ObjectModelOperation operation = this.addOperation((ObjectModelClassifier)output, "prePersist", Void.TYPE, new ObjectModelModifier[]{ObjectModelJavaModifier.PUBLIC});
            this.addAnnotation((ObjectModelClassifier)output, (ObjectModelElement)operation, PrePersist.class);
            this.addImport((ObjectModelClassifier)output, JpaEntityIdFactoryResolver.class);
            this.setOperationBody(operation, "\n        if (this.id == null) {\n            this.id = new JpaEntityIdFactoryResolver().newId(this);\n        }\n    ");
        }
        if (generateVisitor = JpaTemplatesGeneratorUtil.useGenerateVisitors((ObjectModel)this.getModel())) {
            this.addInterface((ObjectModelClassifier)output, JpaEntityVisitable.class);
            ObjectModelOperation operation = this.addOperation((ObjectModelClassifier)output, "accept", Void.TYPE, new ObjectModelModifier[]{ObjectModelJavaModifier.PUBLIC});
            this.addAnnotation((ObjectModelClassifier)output, (ObjectModelElement)operation, Override.class);
            this.addParameter(operation, JpaEntityVisitor.class, "visitor");
            this.setOperationBody(operation, "\n        visitor.visit(this);\n    ");
        }
        boolean usePCS = JpaTemplatesGeneratorUtil.useGeneratePropertyChangeListeners((ObjectModel)this.getModel());
        Set constantNames = this.addConstantsFromDependency((ObjectModelClassifier)input, (ObjectModelClassifier)output);
        List<ObjectModelAttribute> properties = JpaTemplatesGeneratorUtil.getProperties(input);
        ObjectModelAttributeImpl idAttr = new ObjectModelAttributeImpl();
        idAttr.setDeclaringElement((ObjectModelElement)input);
        idAttr.setName("id");
        idAttr.setType(String.class.getName());
        properties.add(0, (ObjectModelAttribute)idAttr);
        boolean generateTechnicalFields = JpaTemplatesGeneratorUtil.useGenerateExtraTechnicalFields((ObjectModel)this.getModel(), (ObjectModelClassifier)input);
        if (generateTechnicalFields) {
            ObjectModelAttributeImpl versionAttr = new ObjectModelAttributeImpl();
            versionAttr.setDeclaringElement((ObjectModelElement)input);
            versionAttr.setName(PROPERTY_VERSION);
            versionAttr.setType(Integer.TYPE.getName());
            properties.add(1, (ObjectModelAttribute)versionAttr);
            ObjectModelAttributeImpl createDateAttr = new ObjectModelAttributeImpl();
            createDateAttr.setDeclaringElement((ObjectModelElement)input);
            createDateAttr.setName(PROPERTY_CREATE_DATE);
            createDateAttr.setType(Date.class.getName());
            createDateAttr.setDefaultValue("new Date()");
            properties.add(2, (ObjectModelAttribute)createDateAttr);
        }
        for (ObjectModelAttribute attr : properties) {
            this.createPropertyConstant(output, attr, prefix, constantNames);
        }
        for (ObjectModelAttribute attr : properties) {
            this.createProperty(input, output, attr, usePCS, generateTechnicalFields);
        }
        if (usePCS) {
            this.createPropertyChangeSupport(output);
        }
        if (hasAMultipleProperty = JpaTemplatesGeneratorUtil.containsMutiple(properties)) {
            this.createGetChildMethod(output);
            this.addImport((ObjectModelClassifier)output, JpaEntities.class);
        }
        if (this.isVerbose()) {
            log.info((Object)("will generate " + output.getQualifiedName()));
        }
        return output;
    }

    protected ObjectModelClass generateImpl(ObjectModelClass input, String packageName, String entityAbstractName, String entityConcreteName) {
        ObjectModelClass output = this.createClass(entityConcreteName, packageName);
        this.setSuperClass(output, entityAbstractName);
        this.addAnnotation((ObjectModelClassifier)output, (ObjectModelElement)output, Entity.class);
        this.addConstant((ObjectModelClassifier)output, "serialVersionUID", "long", "1L", (ObjectModelModifier)ObjectModelJavaModifier.PRIVATE);
        if (this.isVerbose()) {
            log.info((Object)("will generate " + output.getQualifiedName()));
        }
        return output;
    }

    protected void addPropertyAnnotations(ObjectModelClass input, ObjectModelClass output, ObjectModelAttribute inputProperty, ObjectModelAttribute property, boolean generateTechnicalFields) {
        boolean enumeration;
        String propertyName = inputProperty.getName();
        String propertyType = inputProperty.getType();
        if ("id".equals(propertyName)) {
            this.addAnnotation((ObjectModelClassifier)output, (ObjectModelElement)property, Id.class);
            if (JpaTemplatesGeneratorUtil.generateEntityGeneratedValueAnnotation((ObjectModel)this.model, input)) {
                this.addAnnotation((ObjectModelClassifier)output, (ObjectModelElement)property, GeneratedValue.class);
            }
            return;
        }
        if (PROPERTY_VERSION.equals(propertyName) && generateTechnicalFields) {
            this.addAnnotation((ObjectModelClassifier)output, (ObjectModelElement)property, Version.class);
            return;
        }
        ObjectModelAttribute reverseAttribute = inputProperty.getReverseAttribute();
        boolean nMultiplicity = reverseAttribute != null && JpaTemplatesGeneratorUtil.isNMultiplicity((ObjectModelAttribute)reverseAttribute);
        boolean bidirection = reverseAttribute != null && reverseAttribute.isNavigable();
        boolean isInverse = false;
        if (bidirection) {
            String inverseValue = JpaTemplatesGeneratorUtil.getInverseTagValue(inputProperty);
            isInverse = StringUtils.isNotEmpty((CharSequence)inverseValue) ? Boolean.parseBoolean(inverseValue) : JpaTemplatesGeneratorUtil.isFirstAttribute((ObjectModelAttribute)inputProperty);
        }
        boolean composite = inputProperty.isComposite();
        boolean entity = this.isEntity(input, propertyType);
        boolean bl = enumeration = ((ObjectModel)this.getModel()).getEnumeration(propertyType) != null;
        if (JpaTemplatesGeneratorUtil.isNMultiplicity((ObjectModelAttribute)inputProperty)) {
            boolean withOrdererStereotype;
            ObjectModelAnnotation annotation = nMultiplicity ? this.addAnnotation((ObjectModelClassifier)output, (ObjectModelElement)property, ManyToMany.class) : this.addAnnotation((ObjectModelClassifier)output, (ObjectModelElement)property, OneToMany.class);
            if (composite) {
                this.addAnnotationParameter((ObjectModelClassifier)output, annotation, "cascade", CascadeType.ALL);
                this.addAnnotationParameter((ObjectModelClassifier)output, annotation, "orphanRemoval", true);
            }
            if (bidirection && !isInverse) {
                this.addAnnotationParameter((ObjectModelClassifier)output, annotation, "mappedBy", reverseAttribute.getName());
            }
            boolean bl2 = withOrdererStereotype = inputProperty.isOrdered() || JpaTemplatesGeneratorUtil.hasOrderedStereotype((ObjectModelAttribute)inputProperty);
            if (withOrdererStereotype) {
                this.addAnnotation((ObjectModelClassifier)output, (ObjectModelElement)property, OrderColumn.class);
            }
            return;
        }
        if (enumeration) {
            ObjectModelAnnotation annotation = this.addAnnotation((ObjectModelClassifier)output, (ObjectModelElement)property, Enumerated.class);
            this.addAnnotationParameter((ObjectModelClassifier)output, annotation, "value", EnumType.STRING);
        }
        if (entity) {
            if (nMultiplicity) {
                this.addAnnotation((ObjectModelClassifier)output, (ObjectModelElement)property, ManyToOne.class);
            } else {
                this.addAnnotation((ObjectModelClassifier)output, (ObjectModelElement)property, OneToOne.class);
            }
        }
    }

    protected void createProperty(ObjectModelClass input, ObjectModelClass output, ObjectModelAttribute attr, boolean usePCS, boolean geneTechnicalFields) {
        boolean booleanProperty;
        String attrName = JpaTemplatesGeneratorUtil.getAttributeName(attr);
        String attrType = JpaTemplatesGeneratorUtil.getAttributeType(attr);
        boolean multiple = JpaTemplatesGeneratorUtil.isNMultiplicity((ObjectModelAttribute)attr);
        String constantName = this.getConstantName(attrName);
        String simpleType = JpaTemplatesGeneratorUtil.getSimpleName((String)attrType);
        if (multiple) {
            Class<?> collectionType = JpaTemplatesGeneratorUtil.getCollectionType(attr);
            Class<?> collectionInstanceType = JpaTemplatesGeneratorUtil.getCollectionInstanceType(attr);
            this.createGetChildMethod(output, attrName, attrType, simpleType);
            this.createGetChildByIdMethod(output, attrName, attrType, simpleType);
            this.createIsEmptyMethod(output, attrName);
            this.createSizeMethod(output, attrName);
            this.createAddChildMethod(output, attrName, attrType, constantName, collectionInstanceType, usePCS);
            this.createAddAllChildrenMethod(output, attrName, attrType, constantName, collectionInstanceType, usePCS);
            this.createRemoveChildMethod(output, attrName, attrType, constantName, usePCS);
            this.createRemoveAllChildrenMethod(output, attrName, attrType, constantName, usePCS);
            this.createContainsChildMethod(output, attrName, attrType, constantName, usePCS);
            this.createContainsChildByIdMethod(output, attrName, attrType, constantName, usePCS);
            this.createContainsAllChildrenMethod(output, attrName, attrType, constantName, usePCS);
            attrType = collectionType.getName() + "<" + attrType + ">";
            simpleType = JpaTemplatesGeneratorUtil.getSimpleName((String)attrType);
        }
        String getterPrefix = (booleanProperty = JpaTemplatesGeneratorUtil.isBooleanPrimitive((ObjectModelAttribute)attr)) && !multiple ? "is" : "get";
        if (booleanProperty && !multiple) {
            this.createGetMethod(output, attrName, attrType, getterPrefix);
        }
        if (multiple || !booleanProperty) {
            ObjectModelOperation getMethod = this.createGetMethod(output, attrName, attrType, getterPrefix);
            if ("id".equals(attrName)) {
                this.addAnnotation((ObjectModelClassifier)output, (ObjectModelElement)getMethod, Override.class);
            }
        }
        this.createSetMethod(output, attrName, attrType, simpleType, constantName, getterPrefix, usePCS);
        ObjectModelAttribute attribute = this.addAttribute((ObjectModelClassifier)output, attrName, attrType, attr.getDefaultValue(), new ObjectModelModifier[]{ObjectModelJavaModifier.PROTECTED});
        this.addPropertyAnnotations(input, output, attr, attribute, geneTechnicalFields);
    }

    protected ObjectModelOperation createGetMethod(ObjectModelClass output, String attrName, String attrType, String methodPrefix) {
        ObjectModelOperation operation = this.addOperation((ObjectModelClassifier)output, this.getJavaBeanMethodName(methodPrefix, attrName), attrType, new ObjectModelModifier[]{ObjectModelJavaModifier.PUBLIC});
        this.setOperationBody(operation, "\n        return " + attrName + ";\n" + "    ");
        return operation;
    }

    protected void createGetChildMethod(ObjectModelClass output, String attrName, String attrType, String simpleType) {
        ObjectModelOperation operation = this.addOperation((ObjectModelClassifier)output, this.getJavaBeanMethodName("get", attrName), attrType, new ObjectModelModifier[]{ObjectModelJavaModifier.PUBLIC});
        this.addParameter(operation, "int", "index");
        this.setOperationBody(operation, "\n        " + simpleType + " o = getChild(" + attrName + ", index);\n" + "        return o;\n" + "    ");
    }

    protected void createGetChildByIdMethod(ObjectModelClass output, String attrName, String attrType, String simpleType) {
        ObjectModelOperation operation = this.addOperation((ObjectModelClassifier)output, this.getJavaBeanMethodName("get", attrName + "ById"), attrType, new ObjectModelModifier[]{ObjectModelJavaModifier.PUBLIC});
        this.addParameter(operation, "String", "id");
        this.setOperationBody(operation, "\n        " + simpleType + " o = JpaEntities.findById(" + attrName + ", id);\n" + "        return o;\n" + "    ");
    }

    protected void createIsEmptyMethod(ObjectModelClass output, String attrName) {
        ObjectModelOperation operation = this.addOperation((ObjectModelClassifier)output, this.getJavaBeanMethodName("is", attrName) + "Empty", Boolean.TYPE, new ObjectModelModifier[]{ObjectModelJavaModifier.PUBLIC});
        this.setOperationBody(operation, "\n        return " + attrName + " == null || " + attrName + ".isEmpty();\n" + "    ");
    }

    protected void createSizeMethod(ObjectModelClass output, String attrName) {
        ObjectModelOperation operation = this.addOperation((ObjectModelClassifier)output, this.getJavaBeanMethodName("size", attrName), Integer.TYPE, new ObjectModelModifier[]{ObjectModelJavaModifier.PUBLIC});
        this.setOperationBody(operation, "\n        return " + attrName + " == null ? 0 : " + attrName + ".size();\n" + "    ");
    }

    protected void createAddChildMethod(ObjectModelClass output, String attrName, String attrType, String constantName, Class<?> collectionInstanceType, boolean usePCS) {
        ObjectModelOperation operation = this.addOperation((ObjectModelClassifier)output, this.getJavaBeanMethodName("add", attrName), "void", new ObjectModelModifier[]{ObjectModelJavaModifier.PUBLIC});
        this.addParameter(operation, attrType, attrName);
        this.addImport((ObjectModelClassifier)output, collectionInstanceType);
        String getMethodName = this.getJavaBeanMethodName("get", attrName);
        String setMethodName = this.getJavaBeanMethodName("set", attrName);
        String instanceName = collectionInstanceType.getSimpleName() + "<" + JpaTemplatesGeneratorUtil.getSimpleName((String)attrType) + ">";
        StringBuilder buffer = new StringBuilder("\n        if (" + getMethodName + "() == null) {\n" + "            " + setMethodName + "(new " + instanceName + "());\n" + "        }\n" + "        " + getMethodName + "().add(" + attrName + ");\n" + "    ");
        if (usePCS) {
            buffer.append("    firePropertyChange(" + constantName + ", null, " + attrName + ");\n" + "    ");
        }
        this.setOperationBody(operation, buffer.toString());
    }

    protected void createAddAllChildrenMethod(ObjectModelClass output, String attrName, String attrType, String constantName, Class<?> collectionInstanceType, boolean usePCS) {
        ObjectModelOperation operation = this.addOperation((ObjectModelClassifier)output, this.getJavaBeanMethodName("addAll", attrName), "void", new ObjectModelModifier[]{ObjectModelJavaModifier.PUBLIC});
        this.addParameter(operation, Collection.class.getName() + "<" + attrType + ">", attrName);
        String getMethodName = this.getJavaBeanMethodName("get", attrName);
        String setMethodName = this.getJavaBeanMethodName("set", attrName);
        String instanceName = collectionInstanceType.getSimpleName() + "<" + JpaTemplatesGeneratorUtil.getSimpleName((String)attrType) + ">";
        StringBuilder buffer = new StringBuilder("\n        if (" + getMethodName + "() == null) {\n" + "            " + setMethodName + "(new " + instanceName + "());\n" + "        }\n" + "        " + getMethodName + "().addAll(" + attrName + ");\n" + "    ");
        if (usePCS) {
            buffer.append("    firePropertyChange(" + constantName + ", null, " + attrName + ");\n" + "    ");
        }
        this.setOperationBody(operation, buffer.toString());
    }

    protected void createRemoveChildMethod(ObjectModelClass output, String attrName, String attrType, String constantName, boolean usePCS) {
        ObjectModelOperation operation = this.addOperation((ObjectModelClassifier)output, this.getJavaBeanMethodName("remove", attrName), "boolean", new ObjectModelModifier[]{ObjectModelJavaModifier.PUBLIC});
        this.addParameter(operation, attrType, attrName);
        String methodName = this.getJavaBeanMethodName("get", attrName);
        StringBuilder buffer = new StringBuilder();
        buffer.append("\n        boolean removed = " + methodName + "() != null && " + methodName + "().remove(" + attrName + ");");
        if (usePCS) {
            buffer.append("\n        if (removed) {\n            firePropertyChange(" + constantName + ", " + attrName + ", null);\n" + "        }");
        }
        buffer.append("\n        return removed;\n    ");
        this.setOperationBody(operation, buffer.toString());
    }

    protected void createRemoveAllChildrenMethod(ObjectModelClass output, String attrName, String attrType, String constantName, boolean usePCS) {
        ObjectModelOperation operation = this.addOperation((ObjectModelClassifier)output, this.getJavaBeanMethodName("removeAll", attrName), "boolean", new ObjectModelModifier[]{ObjectModelJavaModifier.PUBLIC});
        this.addParameter(operation, "java.util.Collection<" + attrType + ">", attrName);
        StringBuilder buffer = new StringBuilder();
        String methodName = this.getJavaBeanMethodName("get", attrName);
        buffer.append("\n        boolean  removed = " + methodName + "() != null && " + methodName + "().removeAll(" + attrName + ");");
        if (usePCS) {
            buffer.append("\n        if (removed) {\n            firePropertyChange(" + constantName + ", " + attrName + ", null);\n" + "        }");
        }
        buffer.append("\n        return removed;\n    ");
        this.setOperationBody(operation, buffer.toString());
    }

    protected void createContainsChildMethod(ObjectModelClass output, String attrName, String attrType, String constantName, boolean usePCS) {
        ObjectModelOperation operation = this.addOperation((ObjectModelClassifier)output, this.getJavaBeanMethodName("contains", attrName), "boolean", new ObjectModelModifier[]{ObjectModelJavaModifier.PUBLIC});
        this.addParameter(operation, attrType, attrName);
        StringBuilder buffer = new StringBuilder();
        String methodName = this.getJavaBeanMethodName("get", attrName);
        buffer.append("\n        boolean contains = " + methodName + "() != null && " + methodName + "().contains(" + attrName + ");\n" + "        return contains;\n" + "    ");
        this.setOperationBody(operation, buffer.toString());
    }

    protected void createContainsChildByIdMethod(ObjectModelClass output, String attrName, String attrType, String constantName, boolean usePCS) {
        ObjectModelOperation operation = this.addOperation((ObjectModelClassifier)output, this.getJavaBeanMethodName("contains", attrName + "ById"), "boolean", new ObjectModelModifier[]{ObjectModelJavaModifier.PUBLIC});
        this.addParameter(operation, "String", "id");
        StringBuilder buffer = new StringBuilder();
        String getMethodName = this.getJavaBeanMethodName("get", attrName);
        String methodName = this.getJavaBeanMethodName("get", attrName + "ById");
        buffer.append("\n        boolean contains = " + getMethodName + "() != null && " + methodName + "(id) != null;\n" + "        return contains;\n" + "    ");
        this.setOperationBody(operation, buffer.toString());
    }

    protected void createContainsAllChildrenMethod(ObjectModelClass output, String attrName, String attrType, String constantName, boolean usePCS) {
        ObjectModelOperation operation = this.addOperation((ObjectModelClassifier)output, this.getJavaBeanMethodName("containsAll", attrName), "boolean", new ObjectModelModifier[]{ObjectModelJavaModifier.PUBLIC});
        this.addParameter(operation, Collection.class.getName() + "<" + attrType + ">", attrName);
        StringBuilder buffer = new StringBuilder();
        String getMethodName = this.getJavaBeanMethodName("get", attrName);
        String methodName = this.getJavaBeanMethodName("get", attrName);
        buffer.append("\n        boolean  contains = " + getMethodName + "() != null && " + methodName + "().containsAll(" + attrName + ");\n" + "        return contains;\n" + "    ");
        this.setOperationBody(operation, buffer.toString());
    }

    protected void createSetMethod(ObjectModelClass output, String attrName, String attrType, String simpleType, String constantName, String getterPrefix, boolean usePCS) {
        ObjectModelOperation operation = this.addOperation((ObjectModelClassifier)output, this.getJavaBeanMethodName("set", attrName), "void", new ObjectModelModifier[]{ObjectModelJavaModifier.PUBLIC});
        this.addParameter(operation, attrType, attrName);
        if (usePCS) {
            String methodName = this.getJavaBeanMethodName(getterPrefix, attrName);
            this.setOperationBody(operation, "\n        " + simpleType + " oldValue = " + methodName + "();\n" + "        this." + attrName + " = " + attrName + ";\n" + "        firePropertyChange(" + constantName + ", oldValue, " + attrName + ");\n" + "    ");
        } else {
            this.setOperationBody(operation, "\n        this." + attrName + " = " + attrName + ";\n" + "    ");
        }
    }

    protected void createGetChildMethod(ObjectModelClass output) {
        ObjectModelOperation getChild = this.addOperation((ObjectModelClassifier)output, "getChild", "<T> T", new ObjectModelModifier[]{ObjectModelJavaModifier.PROTECTED});
        this.addImport((ObjectModelClassifier)output, List.class);
        this.addParameter(getChild, "java.util.Collection<T>", "childs");
        this.addParameter(getChild, "int", "index");
        this.setOperationBody(getChild, "\n        T result = null;\n        if (childs != null) {\n            if (childs instanceof List) {\n                if (index < childs.size()) {\n                    result = ((List<T>) childs).get(index);\n                }\n            } else {\n                int i = 0;\n                for (T o : childs) {\n                    if (index == i) {\n                        result = o;\n                        break;\n                    }\n                    i++;\n                }\n            }\n        }\n        return result;\n    ");
    }

    protected void createPropertyChangeSupport(ObjectModelClass output) {
        this.addAttribute((ObjectModelClassifier)output, "pcs", PropertyChangeSupport.class, "new PropertyChangeSupport(this)", new ObjectModelModifier[]{ObjectModelJavaModifier.PROTECTED, ObjectModelJavaModifier.FINAL, ObjectModelJavaModifier.TRANSIENT});
        ObjectModelOperation operation = this.addOperation((ObjectModelClassifier)output, "addPropertyChangeListener", "void", new ObjectModelModifier[]{ObjectModelJavaModifier.PUBLIC});
        this.addParameter(operation, PropertyChangeListener.class, "listener");
        this.setOperationBody(operation, "\n        pcs.addPropertyChangeListener(listener);\n    ");
        operation = this.addOperation((ObjectModelClassifier)output, "addPropertyChangeListener", "void", new ObjectModelModifier[]{ObjectModelJavaModifier.PUBLIC});
        this.addParameter(operation, String.class, "propertyName");
        this.addParameter(operation, PropertyChangeListener.class, "listener");
        this.setOperationBody(operation, "\n        pcs.addPropertyChangeListener(propertyName, listener);\n    ");
        operation = this.addOperation((ObjectModelClassifier)output, "removePropertyChangeListener", "void", new ObjectModelModifier[]{ObjectModelJavaModifier.PUBLIC});
        this.addParameter(operation, PropertyChangeListener.class, "listener");
        this.setOperationBody(operation, "\n        pcs.removePropertyChangeListener(listener);\n    ");
        operation = this.addOperation((ObjectModelClassifier)output, "removePropertyChangeListener", "void", new ObjectModelModifier[]{ObjectModelJavaModifier.PUBLIC});
        this.addParameter(operation, String.class, "propertyName");
        this.addParameter(operation, PropertyChangeListener.class, "listener");
        this.setOperationBody(operation, "\n        pcs.removePropertyChangeListener(propertyName, listener);\n    ");
        operation = this.addOperation((ObjectModelClassifier)output, "firePropertyChange", "void", new ObjectModelModifier[]{ObjectModelJavaModifier.PROTECTED});
        this.addParameter(operation, String.class, "propertyName");
        this.addParameter(operation, Object.class, "oldValue");
        this.addParameter(operation, Object.class, "newValue");
        this.setOperationBody(operation, "\n        pcs.firePropertyChange(propertyName, oldValue, newValue);\n    ");
        operation = this.addOperation((ObjectModelClassifier)output, "firePropertyChange", "void", new ObjectModelModifier[]{ObjectModelJavaModifier.PROTECTED});
        this.addParameter(operation, String.class, "propertyName");
        this.addParameter(operation, Object.class, "newValue");
        this.setOperationBody(operation, "\n        firePropertyChange(propertyName, null, newValue);\n    ");
    }
}

