package jaxx.runtime.swing.editor;

import java.awt.BorderLayout;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.DefaultBoundedRangeModel;
import javax.swing.JLabel;
import javax.swing.JSpinner;
import javax.swing.SpinnerDateModel;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.binding.DefaultJAXXBinding;
import jaxx.runtime.binding.SimpleJAXXObjectBinding;
import jaxx.runtime.context.DefaultJAXXContext;
import jaxx.runtime.swing.Table;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import static org.nuiton.i18n.I18n.t;

public class SimpleTimeEditor extends Table implements JAXXObject {

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_HOUR_ENABLED = "hour.enabled";
    public static final String BINDING_HOUR_VALUE = "hour.value";
    public static final String BINDING_LABEL_M_VISIBLE = "labelM.visible";
    public static final String BINDING_MINUTE_ENABLED = "minute.enabled";
    public static final String BINDING_MINUTE_MODEL_VALUE = "minuteModel.value";
    public static final String BINDING_SECOND_ENABLED = "second.enabled";
    public static final String BINDING_SECOND_MODEL_VALUE = "secondModel.value";
    public static final String BINDING_SECOND_VISIBLE = "second.visible";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAK1Vz08TQRR+FEoFJIqoAcGkiiatIVv8ES4chJQSJG1JLCbEXpx2J3TMdHbdmYXVBuOf4J+gdy8m3jwZD549eDH+C8Z48Gp8s7t0t7BojTZ0w85735vvvfe911dfIS0duPSQeJ7huEKxNjU2Vra3NxsPaVOtUtl0mK0sB4LPQApSdRgzu+dSwVy9rOGFEF4oWm3bElTE0EtlGJXqMaeyRalScLEX0ZSyUOualzzbdQ6idkklRX3x/VvqufnsZQrAs5HdKKaS/RMqymSoDClmKjiDN+2SAidiB2k4TOwg33F9VuREyipp00fwFDJlGLaJg8EUXO4/ZT+Gj/dsBZkrW6TB6YKCaz1E5R5ea1CTIdSosbbN6Rael/wD2/YDDCtIty2TcgWF/sEVjYgijLWZcBWtBHFmdZZeGKBmMyGos0pCcwwkadMSpn+qjyYiU6ZFhMmpo+B6/5zWA0wUZahluRjibJzORshHu4x0PYc5aVC+jl3r8S3r00OeQab6bTopRkW/zR6yBInGMQ7M9CSGYjUisUZqGqhD2nHxWMFU/ai+76IpUPbUIWXrgL715/nJT2+/vFk7kHMG7z6X6BqbRpSZ7Vg2NoDpq08FWnYV44UKsZfqMCIpx1H2R3U2gVgtNCM5vG9Cww0NN9aJbGGIdObzu/fnH3wchNQajHKLmGtE+9+BEdVysAoWNz379rLP6OTeCXyexu9gJNarHUH3smE3q267QQNR5hbms/h34+Z89np+H/13CXexpBc7PtDYoUpLJvDNZwvZm4sLC+iXoULPEE7ueIfJUvCSy+97WNzZhOJ2M2yMfPgxWXu9fFDgAUx4+lj3qMjp+zDMBGeC+hsjXAaJG2LMltQ1rWjok9YAhIK3wwHI+c/5IzVMKZhsWQ57YglF+ApnO6Ltr5+5Ts/c6mfRElIRoaRRLFW3SnexTkOKeuh8UmcWDuK65+qrbvnJ6/8WoTtSfbAZbxJOhUmcNUY51n+mE8mlGJqMyp3qva1SrJ/5TrgjDElVJVo/uW6b9crJ5XUHj7KLL6w+KB6IbrwTw/1WNAkFCaB/um3w39qT2WWSIQsFF0LBM1nz149ekppfLp/cxcrxXaz8ry7WSsXN6upxXaxFvwd9djH2C9JHXfusTdTsWPi/bXYARVK/AEEVXF4NCQAA";
    private static final Log log = LogFactory.getLog(SimpleTimeEditor.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    protected List<Object> $activeBindings = new ArrayList<Object>();
    protected Map<String, Object> $bindingSources = new HashMap<String, Object>();
    protected final Map<String, JAXXBinding> $bindings = new TreeMap<String, JAXXBinding>();
    protected Map<String, Object> $objectMap = new HashMap<String, Object>();
    protected Map<?, ?> $previousValues = new HashMap<Object, Object>();
    private boolean allComponentsCreated;
    protected final JAXXContext delegateContext = new DefaultJAXXContext();

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected SimpleTimeEditorHandler handler;
    protected JSpinner hour;
    protected JLabel labelH;
    protected JLabel labelM;
    protected JSpinner minute;
    protected SpinnerDateModel minuteModel;
    protected SimpleTimeEditorModel model;
    protected JSpinner second;
    protected SpinnerDateModel secondModel;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private SimpleTimeEditor $Table0 = this;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/

    public void init() { handler.init(); }
    public void setBean(Serializable bean) { model.setBean(bean); }
    public void setProperty(String property ) { model.setProperty(property); }
    public void setDate(Date date) { model.setDate(date); }
    public void setSecondEditable(boolean isSecondEditable) { model.setSecondEditable(isSecondEditable); }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public SimpleTimeEditor() {
        $initialize();
    }

    public SimpleTimeEditor(JAXXContext parentContext) {
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------- JAXXObject implementation ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void applyDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).applyDataBinding();
        }
        processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public Map<String, Object> get$objectMap() {
        return $objectMap;
    }

    @Override
    public JAXXBinding getDataBinding(String bindingId) {
        return $bindings.get(bindingId);
    }

    @Override
    public JAXXBinding[] getDataBindings() {
        return $bindings.values().toArray(new JAXXBinding[$bindings.size()]);
    }

    @Override
    public Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    @Override
    public void processDataBinding(String $binding, boolean $force) {
        if (!$force && $activeBindings.contains($binding)) { 
            return;
        }
        $activeBindings.add($binding);
        try {
            if (allComponentsCreated && $bindings.containsKey($binding)) {
                getDataBinding($binding).processDataBinding();
            }
        } finally {
            $activeBindings.remove($binding);
        }
    }

    @Override
    public void processDataBinding(String $binding) {
        processDataBinding($binding, false);
    }

    @Override
    public void registerDataBinding(JAXXBinding binding) {
        $bindings.put(binding.getId(), binding);
    }

    @Override
    public void removeDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).removeDataBinding();
        }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- JAXXContext implementation  ---------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    @Override
    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    @Override
    public JAXXContext getDelegateContext() {
        return delegateContext;
    }

    @Override
    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return SwingUtil.getParentContainer(this, clazz);
    }

    @Override
    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return SwingUtil.getParentContainer(source, clazz);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    @Override
    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    @Override
    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doStateChanged__on__hour(ChangeEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.updateTimeModelFromHour((Integer)hour.getValue());
    }

    public void doStateChanged__on__minute(ChangeEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.updateTimeModelFromMinute(minuteModel.getDate());
    }

    public void doStateChanged__on__second(ChangeEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.updateTimeModelFromSecond(secondModel.getDate());
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public SimpleTimeEditorHandler getHandler() {
        return handler;
    }

    public JSpinner getHour() {
        return hour;
    }

    public JLabel getLabelH() {
        return labelH;
    }

    public JLabel getLabelM() {
        return labelM;
    }

    public JSpinner getMinute() {
        return minute;
    }

    public SpinnerDateModel getMinuteModel() {
        return minuteModel;
    }

    public SimpleTimeEditorModel getModel() {
        return model;
    }

    public JSpinner getSecond() {
        return second;
    }

    public SpinnerDateModel getSecondModel() {
        return secondModel;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void createHandler() {
        $objectMap.put("handler", handler = new SimpleTimeEditorHandler(this));
    }

    protected void createHour() {
        $objectMap.put("hour", hour = new JSpinner());
        
        hour.setName("hour");
        hour.addChangeListener(JAXXUtil.getEventListener(ChangeListener.class, "stateChanged", this, "doStateChanged__on__hour"));
    }

    protected void createLabelH() {
        $objectMap.put("labelH", labelH = new JLabel());
        
        labelH.setName("labelH");
        labelH.setText(t("timeeditor.H"));
    }

    protected void createLabelM() {
        $objectMap.put("labelM", labelM = new JLabel());
        
        labelM.setName("labelM");
        labelM.setText(t("timeeditor.M"));
    }

    protected void createMinute() {
        $objectMap.put("minute", minute = new JSpinner());
        
        minute.setName("minute");
        minute.addChangeListener(JAXXUtil.getEventListener(ChangeListener.class, "stateChanged", this, "doStateChanged__on__minute"));
    }

    protected void createMinuteModel() {
        $objectMap.put("minuteModel", minuteModel = new SpinnerDateModel());
    }

    protected void createModel() {
        $objectMap.put("model", model = new SimpleTimeEditorModel());
    }

    protected void createSecond() {
        $objectMap.put("second", second = new JSpinner());
        
        second.setName("second");
        second.addChangeListener(JAXXUtil.getEventListener(ChangeListener.class, "stateChanged", this, "doStateChanged__on__second"));
    }

    protected void createSecondModel() {
        $objectMap.put("secondModel", secondModel = new SpinnerDateModel());
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        // inline complete setup of $Table0
        add(hour, new GridBagConstraints(0, 0, 1, 1, 0.33, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        add(labelH, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        add(minute, new GridBagConstraints(2, 0, 1, 1, 0.33, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        add(labelM, new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        add(second, new GridBagConstraints(4, 0, 1, 1, 0.33, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        
        // apply 8 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
        
        // apply 7 property setters
        minuteModel.setCalendarField(java.util.Calendar.MINUTE);
        secondModel.setCalendarField(java.util.Calendar.SECOND);
        hour.setModel(new SpinnerNumberModel(0, 0, 23, 1));
        labelH.setHorizontalAlignment(javax.swing.SwingConstants.CENTER);
        minute.setModel(minuteModel);
        labelM.setHorizontalAlignment(javax.swing.SwingConstants.CENTER);
        second.setModel(secondModel);
    }

    private void $initialize() {
        if (allComponentsCreated) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        $objectMap.put("$Table0", $Table0);
        createModel();
        createMinuteModel();
        createSecondModel();
        createHandler();
        createHour();
        createLabelH();
        createMinute();
        createLabelM();
        createSecond();
        // inline creation of $Table0
        setName("$Table0");
        
        // registers 8 data bindings
        $registerDefaultBindings();
        $completeSetup();
    }

    private void $registerDefaultBindings() {
        // register 8 data bindings
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_MINUTE_MODEL_VALUE, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("date", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    minuteModel.setValue(handler.setMinuteModel(model.getDate()));
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("date", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_SECOND_MODEL_VALUE, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("date", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    secondModel.setValue(handler.setSecondModel(model.getDate()));
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("date", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_HOUR_VALUE, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("timeModel", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    hour.setValue(model.getTimeModel() / 3600);
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("timeModel", this);
                }
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_HOUR_ENABLED, true ,"enabled") {
        
            @Override
            public void processDataBinding() {
                hour.setEnabled(isEnabled());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_MINUTE_ENABLED, true ,"enabled") {
        
            @Override
            public void processDataBinding() {
                minute.setEnabled(isEnabled());
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_LABEL_M_VISIBLE, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("secondEditable", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    labelM.setVisible(model.isSecondEditable());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("secondEditable", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_SECOND_VISIBLE, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("secondEditable", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    second.setVisible(model.isSecondEditable());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("secondEditable", this);
                }
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_SECOND_ENABLED, true ,"enabled") {
        
            @Override
            public void processDataBinding() {
                second.setEnabled(isEnabled());
            }
        });
    }

}