/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.jaxx.widgets.extra.tree;

import java.util.ArrayList;
import java.util.Collection;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import org.nuiton.jaxx.widgets.extra.tree.TreeFilter;

public class FilterTreeModel
implements TreeModel {
    protected Collection<TreeModelListener> treeModelListeners;
    protected TreeModel delegateModel;
    protected TreeFilter treeFilter;

    public FilterTreeModel(TreeModel delegateModel) {
        this(delegateModel, null);
    }

    public FilterTreeModel(TreeModel delegateModel, TreeFilter filter) {
        this.delegateModel = delegateModel;
        this.treeFilter = filter;
        this.treeModelListeners = new ArrayList<TreeModelListener>();
    }

    public void setFilter(TreeFilter treeFilter) {
        this.treeFilter = treeFilter;
        TreePath path = new TreePath(this.delegateModel.getRoot());
        this.fireTreeStructureChanged(path);
    }

    protected void fireTreeStructureChanged(TreePath path) {
        TreeModelEvent event = new TreeModelEvent((Object)this.delegateModel, path);
        for (TreeModelListener current : this.treeModelListeners) {
            current.treeStructureChanged(event);
        }
    }

    @Override
    public int getChildCount(Object parent) {
        int realCount = this.delegateModel.getChildCount(parent);
        int filterCount = 0;
        for (int i = 0; i < realCount; ++i) {
            Object child = this.delegateModel.getChild(parent, i);
            if (this.treeFilter != null && !this.treeFilter.include(this.delegateModel, child)) continue;
            ++filterCount;
        }
        return filterCount;
    }

    @Override
    public Object getChild(Object parent, int index) {
        int cnt = -1;
        for (int i = 0; i < this.delegateModel.getChildCount(parent); ++i) {
            Object child = this.delegateModel.getChild(parent, i);
            if (this.treeFilter == null || this.treeFilter.include(this.delegateModel, child)) {
                ++cnt;
            }
            if (cnt != index) continue;
            return child;
        }
        return null;
    }

    @Override
    public Object getRoot() {
        return this.delegateModel.getRoot();
    }

    @Override
    public boolean isLeaf(Object node) {
        return this.delegateModel.isLeaf(node);
    }

    @Override
    public void valueForPathChanged(TreePath path, Object newValue) {
        this.delegateModel.valueForPathChanged(path, newValue);
    }

    @Override
    public int getIndexOfChild(Object parent, Object child) {
        return this.delegateModel.getIndexOfChild(parent, child);
    }

    @Override
    public void addTreeModelListener(TreeModelListener l) {
        this.delegateModel.addTreeModelListener(l);
        this.treeModelListeners.add(l);
    }

    @Override
    public void removeTreeModelListener(TreeModelListener l) {
        this.delegateModel.removeTreeModelListener(l);
        this.treeModelListeners.remove(l);
    }
}

