/*
 * Decompiled with CFR 0.152.
 */
package jaxx.runtime.validator.swing;

import java.awt.Color;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JTable;
import javax.swing.RowSorter;
import javax.swing.SortOrder;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.JAXXValidator;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.validator.swing.SwingValidator;
import jaxx.runtime.validator.swing.SwingValidatorMessage;
import jaxx.runtime.validator.swing.SwingValidatorMessageListMouseListener;
import jaxx.runtime.validator.swing.SwingValidatorMessageTableMouseListener;
import jaxx.runtime.validator.swing.SwingValidatorMessageTableRenderer;
import jaxx.runtime.validator.swing.meta.Validator;
import jaxx.runtime.validator.swing.meta.ValidatorField;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;
import org.nuiton.util.ReflectUtil;
import org.nuiton.validator.NuitonValidatorProvider;
import org.nuiton.validator.NuitonValidatorScope;
import org.nuiton.validator.bean.BeanValidator;
import org.nuiton.validator.bean.BeanValidatorFactory;
import org.nuiton.validator.bean.BeanValidatorUtil;

public class SwingValidatorUtil
extends BeanValidatorUtil {
    private static final Log log = LogFactory.getLog(SwingValidatorUtil.class);
    protected static EnumMap<NuitonValidatorScope, ImageIcon> icons;
    protected static EnumMap<NuitonValidatorScope, Color> colors;

    public static EnumMap<NuitonValidatorScope, ImageIcon> getIcons() {
        if (icons == null) {
            icons = new EnumMap(NuitonValidatorScope.class);
            icons.put(NuitonValidatorScope.FATAL, SwingUtil.createImageIcon((String)"fatal.png"));
            icons.put(NuitonValidatorScope.ERROR, SwingUtil.createImageIcon((String)"error.png"));
            icons.put(NuitonValidatorScope.WARNING, SwingUtil.createImageIcon((String)"warning.png"));
            icons.put(NuitonValidatorScope.INFO, SwingUtil.createImageIcon((String)"info.png"));
        }
        return icons;
    }

    public static EnumMap<NuitonValidatorScope, Color> getColors() {
        if (colors == null) {
            colors = new EnumMap(NuitonValidatorScope.class);
            colors.put(NuitonValidatorScope.FATAL, Color.MAGENTA);
            colors.put(NuitonValidatorScope.ERROR, Color.RED);
            colors.put(NuitonValidatorScope.WARNING, Color.YELLOW);
            colors.put(NuitonValidatorScope.INFO, Color.GREEN);
        }
        return colors;
    }

    public static Color getColor(NuitonValidatorScope scope) {
        Color c = scope == null ? null : SwingValidatorUtil.getColors().get(scope);
        return c;
    }

    public static ImageIcon getIcon(NuitonValidatorScope scope) {
        ImageIcon icon = scope == null ? null : SwingValidatorUtil.getIcons().get(scope);
        return icon;
    }

    public static ImageIcon getFatalIcon() {
        return SwingValidatorUtil.getIcons().get(NuitonValidatorScope.FATAL);
    }

    public static ImageIcon getErrorIcon() {
        return SwingValidatorUtil.getIcons().get(NuitonValidatorScope.ERROR);
    }

    public static ImageIcon getWarningIcon() {
        return SwingValidatorUtil.getIcons().get(NuitonValidatorScope.WARNING);
    }

    public static ImageIcon getInfoIcon() {
        return SwingValidatorUtil.getIcons().get(NuitonValidatorScope.INFO);
    }

    protected SwingValidatorUtil() {
    }

    public static <O> SwingValidator<O> newValidator(Class<O> type, String context) {
        if (BeanValidatorFactory.isDefaultCreator()) {
            BeanValidatorFactory.setCreator((BeanValidatorFactory.BeanValidatorCreator)new DefaultSwingValidatorCreator());
        }
        SwingValidator validator = (SwingValidator)BeanValidatorFactory.newBeanValidator(type, (String)context, (NuitonValidatorScope[])new NuitonValidatorScope[0]);
        return validator;
    }

    public static List<String> initUI(JAXXValidator ui) {
        ArrayList<String> validatorIds = new ArrayList<String>();
        Map validators = ReflectUtil.getFieldAnnotation(ui.getClass(), Validator.class, (boolean)true);
        for (Map.Entry entry : validators.entrySet()) {
            Field field = (Field)entry.getKey();
            Validator annotation = (Validator)entry.getValue();
            String validatorId = annotation.validatorId();
            validatorIds.add(validatorId);
            if (!log.isInfoEnabled()) continue;
            log.info((Object)("Detect validator [" + annotation.validatorId() + "]  on field " + field.getName()));
        }
        return Collections.unmodifiableList(validatorIds);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void installFields(JAXXValidator ui) {
        Map<JComponent, ValidatorField> editors = SwingValidatorUtil.getValidatorEditors(ui);
        try {
            for (String validatorId : ui.getValidatorIds()) {
                SwingValidator validator = (SwingValidator)ui.getValidator(validatorId);
                for (Map.Entry<JComponent, ValidatorField> entry : editors.entrySet()) {
                    ValidatorField fieldAnnotation = entry.getValue();
                    JComponent editor = entry.getKey();
                    if (!validatorId.equals(fieldAnnotation.validatorId())) continue;
                    String propertyName = fieldAnnotation.propertyName();
                    if (log.isInfoEnabled()) {
                        log.info((Object)("Detects for validator [" + validatorId + "] property " + propertyName + " for editor " + fieldAnnotation.editorName()));
                    }
                    validator.setFieldRepresentation(propertyName, editor);
                }
            }
        }
        finally {
            editors.clear();
        }
    }

    public static void installUI(JAXXValidator ui) {
        SwingValidatorUtil.installFields(ui);
        List<String> validatorIds = ui.getValidatorIds();
        for (String validatorId : validatorIds) {
            SwingValidator validator = (SwingValidator)ui.getValidator(validatorId);
            validator.installUIs();
            validator.reloadBean();
        }
    }

    public static void installUI(JTable errorTable, SwingValidatorMessageTableRenderer render) {
        errorTable.setDefaultRenderer(Object.class, render);
        errorTable.getRowSorter().setSortKeys(Arrays.asList(new RowSorter.SortKey(0, SortOrder.ASCENDING)));
        SwingUtil.setI18nTableHeaderRenderer((JTable)errorTable, (String[])new String[]{I18n.n_((String)"validator.scope.header", (Object[])new Object[0]), I18n.n_((String)"validator.scope.header.tip", (Object[])new Object[0]), I18n.n_((String)"validator.field.header", (Object[])new Object[0]), I18n.n_((String)"validator.field.header.tip", (Object[])new Object[0]), I18n.n_((String)"validator.message.header", (Object[])new Object[0]), I18n.n_((String)"validator.message.header.tip", (Object[])new Object[0])});
        SwingValidatorUtil.registerErrorTableMouseListener(errorTable);
        SwingUtil.fixTableColumnWidth((JTable)errorTable, (int)0, (int)25);
    }

    public static SwingValidatorMessageListMouseListener registerErrorListMouseListener(JList list) {
        SwingValidatorMessageListMouseListener listener = SwingValidatorUtil.getErrorListMouseListener(list);
        if (listener != null) {
            return listener;
        }
        listener = new SwingValidatorMessageListMouseListener();
        if (log.isDebugEnabled()) {
            log.debug((Object)listener.toString());
        }
        list.addMouseListener(listener);
        return listener;
    }

    public static SwingValidatorMessageTableMouseListener registerErrorTableMouseListener(JTable table) {
        SwingValidatorMessageTableMouseListener listener = SwingValidatorUtil.getErrorTableMouseListener(table);
        if (listener != null) {
            return listener;
        }
        listener = new SwingValidatorMessageTableMouseListener();
        if (log.isDebugEnabled()) {
            log.debug((Object)listener.toString());
        }
        table.addMouseListener(listener);
        return listener;
    }

    public static SwingValidatorMessageListMouseListener getErrorListMouseListener(JList list) {
        if (list != null) {
            for (MouseListener listener : list.getMouseListeners()) {
                if (!(listener instanceof SwingValidatorMessageListMouseListener)) continue;
                return (SwingValidatorMessageListMouseListener)listener;
            }
        }
        return null;
    }

    public static SwingValidatorMessageTableMouseListener getErrorTableMouseListener(JTable table) {
        if (table != null) {
            for (MouseListener listener : table.getMouseListeners()) {
                if (!(listener instanceof SwingValidatorMessageTableMouseListener)) continue;
                return (SwingValidatorMessageTableMouseListener)listener;
            }
        }
        return null;
    }

    public static String getMessage(SwingValidatorMessage model) {
        String text = model.getMessage();
        if (model.getField() != null) {
            text = model.getI18nError(text);
        }
        return text;
    }

    public static String getFieldName(SwingValidatorMessage model, String value) {
        String text = null;
        JComponent editor = model.getEditor();
        if (editor != null) {
            text = (String)editor.getClientProperty("validatorLabel");
        }
        if (text == null) {
            text = value;
        }
        return text;
    }

    public static void listenValidatorContextNameAndRefreshFields(SwingValidator<?> validator, final JAXXValidator ui) {
        PropertyChangeListener listener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                SwingValidator validator = (SwingValidator)((Object)evt.getSource());
                if (log.isInfoEnabled()) {
                    log.info((Object)("Context name changed to [" + evt.getNewValue() + "] for validator " + validator.getType()));
                }
                ui.registerValidatorFields();
            }
        };
        validator.addPropertyChangeListener("context", listener);
    }

    public static void setValidatorBean(JAXXObject ui, Object bean, String ... excludeIds) {
        if (!JAXXValidator.class.isAssignableFrom(ui.getClass())) {
            return;
        }
        JAXXValidator jaxxValidator = (JAXXValidator)ui;
        List<String> validatorIds = jaxxValidator.getValidatorIds();
        if (excludeIds.length > 0) {
            validatorIds = new ArrayList<String>(validatorIds);
            for (String excludeId : excludeIds) {
                validatorIds.remove(excludeId);
            }
        }
        for (String validatorId : validatorIds) {
            BeanValidator<?> beanValidator = jaxxValidator.getValidator(validatorId);
            if (bean != null && !beanValidator.getType().isAssignableFrom(bean.getClass())) continue;
            beanValidator.setBean(bean);
        }
    }

    public static void setValidatorChanged(JAXXObject ui, boolean newValue, String ... excludeIds) {
        if (!JAXXValidator.class.isAssignableFrom(ui.getClass())) {
            return;
        }
        JAXXValidator jaxxValidator = (JAXXValidator)ui;
        List<String> validatorIds = jaxxValidator.getValidatorIds();
        if (excludeIds.length > 0) {
            validatorIds = new ArrayList<String>(validatorIds);
            for (String excludeId : excludeIds) {
                validatorIds.remove(excludeId);
            }
        }
        for (String validatorId : validatorIds) {
            BeanValidator<?> beanValidator = jaxxValidator.getValidator(validatorId);
            beanValidator.setChanged(newValue);
        }
    }

    protected static Map<JComponent, ValidatorField> getValidatorEditors(JAXXValidator ui) {
        HashMap<JComponent, ValidatorField> editors = new HashMap<JComponent, ValidatorField>();
        Map validatorFields = null;
        Map validatorMethods = null;
        try {
            JComponent editor;
            ValidatorField fieldAnnotation;
            validatorFields = ReflectUtil.getFieldAnnotation(ui.getClass(), ValidatorField.class, (boolean)true);
            validatorMethods = ReflectUtil.getMethodAnnotation(ui.getClass(), ValidatorField.class, (boolean)true);
            for (Map.Entry fieldEntry : validatorFields.entrySet()) {
                Field field = (Field)fieldEntry.getKey();
                field.setAccessible(true);
                fieldAnnotation = (ValidatorField)fieldEntry.getValue();
                editor = (JComponent)field.get(ui);
                editors.put(editor, fieldAnnotation);
            }
            for (Map.Entry fieldEntry : validatorMethods.entrySet()) {
                Method method = (Method)fieldEntry.getKey();
                method.setAccessible(true);
                fieldAnnotation = (ValidatorField)fieldEntry.getValue();
                editor = (JComponent)method.invoke((Object)ui, new Object[0]);
                editors.put(editor, fieldAnnotation);
            }
        }
        catch (Exception e) {
            throw new IllegalStateException("Could not init validators on ui " + ui, e);
        }
        finally {
            if (validatorFields != null) {
                validatorFields.clear();
            }
            if (validatorMethods != null) {
                validatorMethods.clear();
            }
        }
        return editors;
    }

    public static class DefaultSwingValidatorCreator
    implements BeanValidatorFactory.BeanValidatorCreator {
        public <O> BeanValidator<O> newBeanValidator(NuitonValidatorProvider provider, Class<O> type, String context, NuitonValidatorScope ... scopes) {
            SwingValidator<O> beanValidator = new SwingValidator<O>(provider, type, context, scopes);
            return beanValidator;
        }
    }
}

