/*
 * Decompiled with CFR 0.152.
 */
package jaxx.runtime.validator.swing;

import java.awt.Container;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import jaxx.runtime.validator.BeanValidator;
import jaxx.runtime.validator.BeanValidatorField;
import jaxx.runtime.validator.BeanValidatorListener;
import jaxx.runtime.validator.BeanValidatorScope;
import jaxx.runtime.validator.swing.SwingValidatorMessageListModel;
import jaxx.runtime.validator.swing.SwingValidatorMessageTableModel;
import jaxx.runtime.validator.swing.ui.AbstractBeanValidatorUI;
import jaxx.runtime.validator.swing.ui.IconValidationUI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdesktop.jxlayer.JXLayer;

public class SwingValidator<B>
extends BeanValidator<B> {
    private static final Log log = LogFactory.getLog(SwingValidator.class);
    private static final Class<? extends AbstractBeanValidatorUI> DEFAULT_UI_CLASS = IconValidationUI.class;
    protected final Map<String, JComponent> fieldRepresentation = new HashMap<String, JComponent>();
    protected SwingValidatorMessageListModel errorListModel;
    protected SwingValidatorMessageTableModel errorTableModel;
    protected Class<? extends AbstractBeanValidatorUI> uiClass;

    public SwingValidator(Class<B> beanClass, String contextName, BeanValidatorScope ... filterScopes) {
        super(beanClass, contextName, filterScopes);
    }

    public SwingValidator(Class<B> beanClass, String contextName) {
        this(beanClass, contextName, FILTER_SCOPES_EMPTY);
    }

    public void reloadBean() {
        Object b = this.getBean();
        if (b != null) {
            this.setBean(null);
            this.setBean(b);
        }
    }

    public JComponent getFieldRepresentation(String fieldname) {
        return this.fieldRepresentation.get(fieldname);
    }

    public Class<? extends AbstractBeanValidatorUI> getUiClass() {
        return this.uiClass;
    }

    public void setErrorListModel(SwingValidatorMessageListModel errorListModel) {
        this.errorListModel = errorListModel;
        if (errorListModel != null) {
            errorListModel.registerValidator(this);
        }
    }

    public void setErrorTableModel(SwingValidatorMessageTableModel errorTableModel) {
        this.errorTableModel = errorTableModel;
        if (errorTableModel != null) {
            errorTableModel.registerValidator(this);
        }
    }

    public void setUiClass(Class<? extends AbstractBeanValidatorUI> uiClass) {
        this.uiClass = uiClass;
    }

    @Override
    public void setContextName(String contextName) {
        super.setContextName(contextName);
        if (this.fieldRepresentation != null) {
            this.installUIs();
        }
    }

    public void setFieldRepresentation(String fieldname, JComponent c) {
        BeanValidatorField field = this.getField(fieldname);
        if (field == null) {
            if (log.isWarnEnabled()) {
                log.warn((Object)("the field '" + fieldname + "' is not defined in validator (no rules on it)"));
            }
            return;
        }
        if (log.isInfoEnabled()) {
            log.info((Object)("register field [" + fieldname + "] with component : " + c.getName()));
        }
        this.fieldRepresentation.put(fieldname, c);
    }

    public void setFieldRepresentation(Map<String, JComponent> fieldRepresentation) {
        for (Map.Entry<String, JComponent> e : fieldRepresentation.entrySet()) {
            this.setFieldRepresentation(e.getKey(), e.getValue());
        }
    }

    @Override
    public SwingValidator<?> getParentValidator() {
        return (SwingValidator)super.getParentValidator();
    }

    @Override
    public void setParentValidator(SwingValidator<?> parentValidator) {
        super.setParentValidator(parentValidator);
    }

    public void installUIs() {
        if (this.fieldRepresentation == null) {
            throw new NullPointerException("fieldRepresentation is null, must init before invoking installUIs method...");
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (SwingValidator.this.uiClass == null) {
                    SwingValidator.this.uiClass = DEFAULT_UI_CLASS;
                }
                for (Map.Entry<String, JComponent> entry : SwingValidator.this.fieldRepresentation.entrySet()) {
                    try {
                        SwingValidator.this.setMessageRepresentation(entry.getKey(), null, entry.getValue(), SwingValidator.this.uiClass);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            }
        });
    }

    protected void setMessageRepresentation(String fieldname, JComponent old, JComponent c, Class<? extends AbstractBeanValidatorUI> uiClass) throws InvocationTargetException, IllegalAccessException, InstantiationException, NoSuchMethodException {
        Object ui;
        Container container;
        if (old == c) {
            return;
        }
        BeanValidatorField field = this.getField(fieldname);
        if (field == null) {
            return;
        }
        if (old != null && (container = old.getParent()) instanceof JXLayer) {
            JXLayer jx = (JXLayer)container;
            ui = jx.getUI();
            if (ui != null && ui instanceof AbstractBeanValidatorUI) {
                this.removeBeanValidatorListener((AbstractBeanValidatorUI)ui);
            }
            jx.setUI(null);
        }
        if (c != null && (container = c.getParent()) instanceof JXLayer) {
            Constructor<? extends AbstractBeanValidatorUI> cons = uiClass.getConstructor(BeanValidatorField.class);
            ui = cons.newInstance(field);
            ui.setEnabled(true);
            JXLayer jx = (JXLayer)container;
            this.addBeanValidatorListener((BeanValidatorListener)ui);
            jx.setUI(ui);
        }
    }
}

