/*
 * *##% 
 * JAXX Action
 * Copyright (C) 2008 - 2009 CodeLutin
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 *
 * You should have received a copy of the GNU General Lesser Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * ##%*
 */
/**
 * ##% Copyright (C) 2008 Code Lutin, Tony Chemit
 * This program is free software; you
 * can redistribute it and/or modify it under the terms of the GNU General
 * Public License as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version. This program is
 * distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
 * without even the implied warranty of MERCHANTABILITY or FITNESS FOR A
 * PARTICULAR PURPOSE. See the GNU General Public License for more details. You
 * should have received a copy of the GNU General Public License along with this
 * program; if not, write to the Free Software Foundation, Inc., 59 Temple Place
 * - Suite 330, Boston, MA 02111-1307, USA. 
 * ##%
 */
package org.nuiton.jaxx.util.config;

import org.nuiton.jaxx.util.AbstractUIAction;
import org.nuiton.jaxx.util.DialogUI;
import org.nuiton.jaxx.util.UIHelper;

import java.awt.event.ActionEvent;

/** @author chemit */
public class CancelAction<E extends Enum<E>, H extends DialogConfigUIHandler<E, ?, ?>> extends AbstractUIAction<H> {
    private static final long serialVersionUID = 1L;

    public CancelAction(DialogUI<? extends H> dialogUI, boolean showLabel) {
        super(null, UIHelper.createActionIcon("cancel-config"), dialogUI);
        if (showLabel) {
            String text = org.nuiton.i18n.I18n._("lutinui.config.cancel");
            putValue(NAME, text);
            putValue(DISPLAYED_MNEMONIC_INDEX_KEY, 0);
            putValue(MNEMONIC_KEY, (int) text.charAt(0));
        }
        String libelle = org.nuiton.i18n.I18n._("lutinui.config.cancel.tooltip");
        putValue(SHORT_DESCRIPTION, libelle);

    }

    public void actionPerformed(ActionEvent e) {
        getUi().dispose();
    }
}