/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.jaxx.util;

import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.lang.reflect.Constructor;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.ImageIcon;
import javax.swing.JDialog;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.jaxx.util.DialogUIHandler;
import org.nuiton.jaxx.util.UIHelper;

public abstract class DialogUI<H extends DialogUIHandler<?, ?>>
extends JDialog
implements WindowListener {
    protected static Log log = LogFactory.getLog(DialogUI.class);
    private H handler;

    public AbstractAction newAction(Class<?> actionClass, Object ... params) {
        Constructor<?> constructor = null;
        for (Constructor<?> cons : actionClass.getConstructors()) {
            Class<?>[] prototype = cons.getParameterTypes();
            if (prototype.length <= 0 || !DialogUI.class.isAssignableFrom(prototype[0])) continue;
            constructor = cons;
            break;
        }
        if (constructor == null) {
            throw new IllegalStateException("could not find a matching constructor for " + actionClass);
        }
        Object[] parameters = new Object[1 + params.length];
        parameters[0] = this;
        System.arraycopy(params, 0, parameters, 1, params.length);
        try {
            AbstractAction action = (AbstractAction)constructor.newInstance(parameters);
            if (log.isInfoEnabled()) {
                log.info((Object)action);
            }
            return action;
        }
        catch (Exception e) {
            throw new IllegalStateException("could not init the action " + actionClass + " for reason : " + e.getMessage());
        }
    }

    public abstract AbstractButton getHelp();

    public abstract Object getObjectById(String var1);

    protected DialogUI() {
        UIHelper.setQuitAction(this);
        this.addWindowListener(this);
    }

    public H getHandler() {
        return this.handler;
    }

    public void setHandler(H handler) {
        this.handler = handler;
    }

    protected ImageIcon createActionIcon(String name) {
        return UIHelper.createActionIcon(name);
    }

    @Override
    public void windowOpened(WindowEvent e) {
    }

    @Override
    public void windowClosed(WindowEvent e) {
    }

    @Override
    public void windowClosing(WindowEvent e) {
    }

    @Override
    public void windowIconified(WindowEvent e) {
    }

    @Override
    public void windowDeiconified(WindowEvent e) {
    }

    @Override
    public void windowActivated(WindowEvent e) {
    }

    @Override
    public void windowDeactivated(WindowEvent e) {
    }

    @Override
    public synchronized void addWindowListener(WindowListener l) {
        super.addWindowListener(l);
        if (log.isDebugEnabled()) {
            log.debug((Object)("after added (" + this.getWindowListeners().length + ") : " + l));
        }
    }

    @Override
    public synchronized void removeWindowListener(WindowListener l) {
        super.removeWindowListener(l);
        if (log.isDebugEnabled()) {
            log.debug((Object)("after removed (" + this.getWindowListeners().length + ") : " + l));
        }
    }
}

