/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.jaxx.tab;

import java.awt.Component;
import java.lang.reflect.Field;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import javax.swing.JComponent;
import javax.swing.JTabbedPane;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.swing.JAXXTab;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.jaxx.tab.TabContentConfig;
import org.nuiton.jaxx.tab.TabModel;

public abstract class TabFactory {
    protected static Log log = LogFactory.getLog(TabFactory.class);
    protected Map<String, TabContentConfig> configs = this.initFactory();
    protected Map<String, JAXXTab> cache = new TreeMap<String, JAXXTab>();
    protected Map<String, TabModel> models = new TreeMap<String, TabModel>();

    protected abstract Map<String, TabContentConfig> initFactory();

    protected abstract void initTab(JAXXTab var1, String var2, TabContentConfig var3);

    protected JAXXTab newTab(String tabName) {
        this.checkRegistredConfig(tabName);
        if (this.cache.containsKey(tabName)) {
            return this.cache.get(tabName);
        }
        TabContentConfig config = this.configs.get(tabName);
        try {
            JAXXTab instance = config.impl().newInstance();
            if (log.isDebugEnabled()) {
                log.debug((Object)("new tab       : " + instance));
            }
            this.cache.put(tabName, instance);
            this.initJAXXTab(config, instance);
            this.initTab(instance, tabName, config);
            return instance;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public Set<String> keySet() {
        return this.cache.keySet();
    }

    public TabContentConfig getConfig(String tabName) {
        this.checkRegistredConfig(tabName);
        return this.configs.get(tabName);
    }

    public JAXXTab getUI(String tabName) {
        return this.cache.get(tabName);
    }

    public TabModel getModel(String tabName, Object ... params) {
        TabModel tabModel;
        if (this.models.containsKey(tabName)) {
            return this.models.get(tabName);
        }
        TabContentConfig config = this.getConfig(tabName);
        try {
            tabModel = this.initTabModel(config, params);
            if (log.isDebugEnabled()) {
                log.debug((Object)("new tab model : " + tabModel));
            }
            this.models.put(tabName, tabModel);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return tabModel;
    }

    protected TabModel initTabModel(TabContentConfig config, Object ... params) throws InstantiationException, IllegalAccessException {
        TabModel tabModel = config.model().newInstance();
        return tabModel;
    }

    public void showTab(JTabbedPane container, String tabName) {
        TabContentConfig config = this.getConfig(tabName);
        JAXXTab comp = this.newTab(tabName);
        int index = this.getTabIndex(container, (JComponent)comp);
        if (index == -1) {
            this.registerTab(container, tabName, config, comp);
        }
        container.setSelectedComponent((Component)comp);
    }

    public void closeTab(JTabbedPane container, String tabName) {
        TabContentConfig config = this.getConfig(tabName);
        JComponent comp = (JComponent)this.cache.get(tabName);
        int index = this.getTabIndex(container, comp);
        if (index != -1) {
            container.removeTabAt(index);
            if (log.isDebugEnabled()) {
                log.debug((Object)(config + " index " + index));
            }
        }
    }

    public int getTabIndex(JTabbedPane container, JComponent comp) {
        if (container != null && comp != null) {
            for (int i = 0; i < container.getTabCount(); ++i) {
                Component o = container.getComponentAt(i);
                if (!o.equals(comp)) continue;
                return i;
            }
        }
        return -1;
    }

    public void resetCache() {
        this.cache.clear();
        this.models.clear();
    }

    protected TabFactory() {
    }

    protected JComponent addTabHeader(JTabbedPane container, String tabName, TabContentConfig config, JAXXTab comp) {
        return null;
    }

    protected void registerTab(JTabbedPane container, String tabName, TabContentConfig config, JAXXTab comp) {
        container.addTab(tabName, (Component)comp);
        JComponent header = this.addTabHeader(container, tabName, config, comp);
        if (header != null) {
            container.setTabComponentAt(container.getTabCount() - 1, header);
        }
    }

    protected void initJAXXTab(TabContentConfig config, JAXXTab instance) throws NoSuchFieldException, IllegalAccessException {
        if (instance instanceof JAXXObject) {
            JAXXObject ui = (JAXXObject)instance;
            for (String dynamicField : config.dynamicFields()) {
                String dynamciName = dynamicField + '_' + config.name();
                Object obj = ui.getObjectById(dynamicField);
                Field m = ui.getClass().getDeclaredField("$objectMap");
                m.setAccessible(true);
                Map map = (Map)m.get(ui);
                map.put(dynamciName, obj);
            }
        }
    }

    protected void checkRegistredConfig(String tabName) {
        if (!this.configs.containsKey(tabName)) {
            throw new IllegalStateException("can not find a registered TabContentConfig for tab name  " + tabName);
        }
    }
}

