/**
 * ##% Copyright (C) 2008 Code Lutin, Tony Chemit
 * This program is free software; you
 * can redistribute it and/or modify it under the terms of the GNU General
 * Public License as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version. This program is
 * distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
 * without even the implied warranty of MERCHANTABILITY or FITNESS FOR A
 * PARTICULAR PURPOSE. See the GNU General Public License for more details. You
 * should have received a copy of the GNU General Public License along with this
 * program; if not, write to the Free Software Foundation, Inc., 59 Temple Place
 * - Suite 330, Boston, MA 02111-1307, USA. 
 * ##%
 */
package org.nuiton.jaxx.action;

import static org.nuiton.i18n.I18n._;

import javax.swing.AbstractButton;
import javax.swing.Action;

/**
 * Implementation of configuration's resolver for annotation {@link ToggleActionConfig}
 *
 * @author chemit
 */
public class ToggleActionConfigConfigurationResolver extends AbstractActionConfigurationResolver<ToggleActionConfig, AbstractButton> {

    public ToggleActionConfigConfigurationResolver() {
        super(ToggleActionConfig.class, AbstractButton.class);
    }

    protected ToggleActionConfig applyConfiguration0(AbstractButton component, MyAbstractAction action) {
        ToggleActionConfig anno = resolveConfiguration(action);
        if (anno == null) {
            return null;
        }
        // inject les données
        if (!anno.name().isEmpty()) {
            //System.out.println("found action with name : " + anno.name());
            action.putValue(Action.NAME, _(anno.name()));
        }
        if (!anno.name2().isEmpty()) {
            //System.out.println("found action with name2 : " + anno.name2());
            action.putValue(Action.NAME + "2", _(anno.name2()));
        }

        if (!anno.shortDescription().isEmpty()) {
            action.putValue(Action.SHORT_DESCRIPTION, _(anno.shortDescription()));
        }
        if (!anno.shortDescription2().isEmpty()) {
            action.putValue(Action.SHORT_DESCRIPTION + "2", _(anno.shortDescription2()));
        }

        if (!anno.smallIcon().isEmpty()) {
            action.putValue(Action.SMALL_ICON, org.nuiton.jaxx.util.UIHelper.createImageIcon(anno.smallIcon()));
        }
        if (!anno.smallIcon2().isEmpty()) {
            action.putValue(Action.SMALL_ICON + "2", org.nuiton.jaxx.util.UIHelper.createImageIcon(anno.smallIcon2()));
        }

        if (anno.mnemonic() != '\0') {
            action.putValue(Action.MNEMONIC_KEY, anno.mnemonic());
        } else if (component != null) {
            action.putValue(Action.MNEMONIC_KEY, component.getMnemonic());
        }
        if (anno.mnemonic2() != '\0') {
            action.putValue(Action.MNEMONIC_KEY + "2", anno.mnemonic2());
        }
        //TODO Convert it from String action.putValue(Action.ACCELERATOR_KEY, anno.accelerator());


        action.putValue("hideActionText", anno.hideActionText());
        action.putValue(Action.SELECTED_KEY, anno.selected());
        action.setEnabled(anno.enabled());

        return anno;
    }
}