/**
 * ##% Copyright (C) 2008 Code Lutin, Tony Chemit
 * This program is free software; you
 * can redistribute it and/or modify it under the terms of the GNU General
 * Public License as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version. This program is
 * distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
 * without even the implied warranty of MERCHANTABILITY or FITNESS FOR A
 * PARTICULAR PURPOSE. See the GNU General Public License for more details. You
 * should have received a copy of the GNU General Public License along with this
 * program; if not, write to the Free Software Foundation, Inc., 59 Temple Place
 * - Suite 330, Boston, MA 02111-1307, USA. 
 * ##%
 */
package org.nuiton.jaxx.action;

import javax.swing.JComponent;

/**
 * The contract to be realized to resolve an {@link MyAbstractAction} configuration.
 * <p/>
 * Configuration is done by a Annotation of type {@link A} placed on the action class.
 * <p/>
 * If the instanciated action box the real action, we should always search on the boxed action.
 * <p/>
 * Moreover, a action can only be fired by a certain type of component (for example a Button or a ComboBox), the class
 * of the component type is given by the {@link C} class.
 *
 * @param <A> type of annotation for config
 * @param <C> type of component
 * @author chemit
 */
public interface ActionConfigurationResolver<A extends java.lang.annotation.Annotation, C extends JComponent> {
    /**
     * Search the annotation that configure the given action (or the boxed action).
     *
     * @param action current action
     * @return the configuration of the action
     */
    A resolveConfiguration(MyAbstractAction action);

    /**
     * @param component widget that requires the action
     * @param action    given action
     * @return the configuration of the action
     */
    A applyConfiguration(JComponent component, MyAbstractAction action);

    /** @return the configuration annotation dealed by this resolver */
    Class<A> getAnnotationImpl();

    /** @return the class  of the component which can fired the action */
    Class<C> getComponentImpl();
}
