/*
 * Decompiled with CFR 0.152.
 */
package jaxx.runtime;

import java.awt.Component;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeListenerProxy;
import java.beans.PropertyChangeSupport;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EventListener;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import jaxx.runtime.Base64Coder;
import jaxx.runtime.DataBindingListener;
import jaxx.runtime.DataBindingUpdateListener;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.context.JAXXContextEntryDef;
import jaxx.runtime.context.JAXXInitialContext;
import org.apache.commons.beanutils.ConstructorUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class JAXXUtil {
    private static final Log log = LogFactory.getLog(JAXXUtil.class);
    public static final String PARENT = "parent";
    private static Map<Object, WeakReference<List<EventListenerDescriptor>>> eventListeners = new WeakHashMap<Object, WeakReference<List<EventListenerDescriptor>>>();
    private static Map<JAXXObject, WeakReference<List<DataBindingUpdateListener>>> dataBindingUpdateListeners = new WeakHashMap<JAXXObject, WeakReference<List<DataBindingUpdateListener>>>();
    private static final PropertyChangeListener[] EMPTY_ARRAY_PROPERTY_CHANGE_LISTENERS = new PropertyChangeListener[0];

    public static JAXXObjectDescriptor decodeJAXXObjectDescriptor(String descriptor) {
        try {
            return (JAXXObjectDescriptor)Base64Coder.deserialize(descriptor, false);
        }
        catch (IOException e) {
            throw new RuntimeException("Internal error: can't-happen error", e);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("Internal error: can't-happen error", e);
        }
    }

    public static JAXXObjectDescriptor decodeCompressedJAXXObjectDescriptor(String descriptor) {
        try {
            return (JAXXObjectDescriptor)Base64Coder.deserialize(descriptor, true);
        }
        catch (IOException e) {
            throw new RuntimeException("Internal error: can't-happen error", e);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("Internal error: can't-happen error", e);
        }
    }

    public static <O> JAXXContextEntryDef<O> newContextEntryDef(Class<O> klass) {
        return JAXXUtil.newContextEntryDef(null, klass);
    }

    public static <O> JAXXContextEntryDef<O> newContextEntryDef(String name, Class<?> klass) {
        return new JAXXContextEntryDef(name, klass);
    }

    public static <O> JAXXContextEntryDef<List<O>> newListContextEntryDef() {
        return JAXXUtil.newListContextEntryDef(null);
    }

    public static <O> JAXXContextEntryDef<List<O>> newListContextEntryDef(String name) {
        Class<List<O>> castList = JAXXUtil.castList();
        return new JAXXContextEntryDef<List<O>>(name, castList);
    }

    public static <K, V> JAXXContextEntryDef<Map<K, V>> newMapContextEntryDef(String name) {
        return new JAXXContextEntryDef<Map<K, V>>(Map.class, name);
    }

    protected static <K, V> Class<Map<K, V>> castMap() {
        return Collections.emptyMap().getClass();
    }

    protected static <O> Class<List<O>> castList() {
        return Collections.emptyList().getClass();
    }

    public static void initContext(JAXXObject ui, JAXXContext parentContext) {
        if (parentContext instanceof JAXXInitialContext) {
            ((JAXXInitialContext)parentContext).to(ui);
        } else {
            ui.setContextValue(parentContext);
        }
        if (parentContext instanceof JAXXObject) {
            ui.setContextValue(parentContext, PARENT);
        }
    }

    public static <E extends EventListener> E getEventListener(Class<E> listenerClass, final String listenerMethodName, final Object methodContainer, String methodName) {
        ArrayList<EventListenerDescriptor> descriptors;
        WeakReference<List<EventListenerDescriptor>> ref = eventListeners.get(methodContainer);
        ArrayList<EventListenerDescriptor> arrayList = descriptors = ref != null ? (ArrayList<EventListenerDescriptor>)ref.get() : null;
        if (descriptors == null) {
            descriptors = new ArrayList<EventListenerDescriptor>();
            eventListeners.put(methodContainer, new WeakReference(descriptors));
        } else {
            for (EventListenerDescriptor descriptor : descriptors) {
                if (!descriptor.listenerClass.equals(listenerClass) || !(listenerMethodName == null ? descriptor.listenerMethodName == null : listenerMethodName.equals(descriptor.listenerMethodName)) || !methodName.equals(descriptor.methodName)) continue;
                return (E)((EventListener)descriptor.eventListener);
            }
        }
        final EventListenerDescriptor descriptor = new EventListenerDescriptor();
        descriptor.listenerClass = listenerClass;
        descriptor.listenerMethodName = listenerMethodName;
        descriptor.methodName = methodName;
        try {
            final List<Method> listenerMethods = Arrays.asList(listenerClass.getMethods());
            Method listenerMethod = null;
            if (listenerMethodName != null) {
                for (Method listenerMethod1 : listenerMethods) {
                    if (!listenerMethod1.getName().equals(listenerMethodName)) continue;
                    listenerMethod = listenerMethod1;
                    break;
                }
            }
            if (listenerMethodName != null && listenerMethod == null) {
                throw new IllegalArgumentException("no method named " + listenerMethodName + " found in class " + listenerClass.getName());
            }
            Class<?>[] parameterTypes = listenerMethodName != null ? listenerMethod.getParameterTypes() : listenerMethods.get(0).getParameterTypes();
            Class<?> methodContainerClass = methodContainer.getClass();
            final Method targetMethod = methodContainerClass.getMethod(methodName, parameterTypes);
            descriptor.eventListener = Proxy.newProxyInstance(listenerClass.getClassLoader(), new Class[]{listenerClass}, new InvocationHandler(){

                @Override
                public Object invoke(Object proxy, Method method, Object[] args) {
                    String methodName = method.getName();
                    if (listenerMethodName == null && listenerMethods.contains(method) || methodName.equals(listenerMethodName)) {
                        try {
                            targetMethod.setAccessible(true);
                            return targetMethod.invoke(methodContainer, args);
                        }
                        catch (IllegalAccessException e) {
                            throw new RuntimeException("could not invoke on container " + methodContainer, e);
                        }
                        catch (InvocationTargetException e) {
                            throw new RuntimeException(e);
                        }
                    }
                    if (methodName.equals("toString")) {
                        return this.toString();
                    }
                    if (methodName.equals("equals")) {
                        return descriptor.eventListener == args[0];
                    }
                    if (methodName.equals("hashCode")) {
                        return this.hashCode();
                    }
                    return null;
                }
            });
            descriptors.add(descriptor);
            return (E)((EventListener)descriptor.eventListener);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
    }

    public static <E extends EventListener> E getEventListener(Class<E> listenerClass, Object methodContainer, String methodName) {
        return JAXXUtil.getEventListener(listenerClass, null, methodContainer, methodName);
    }

    public static DataBindingUpdateListener getDataBindingUpdateListener(JAXXObject object, String bindingName) {
        ArrayList<DataBindingUpdateListener> listeners;
        WeakReference<List<DataBindingUpdateListener>> ref = dataBindingUpdateListeners.get(object);
        ArrayList<DataBindingUpdateListener> arrayList = listeners = ref == null ? null : (ArrayList<DataBindingUpdateListener>)ref.get();
        if (listeners == null) {
            listeners = new ArrayList<DataBindingUpdateListener>();
            dataBindingUpdateListeners.put(object, new WeakReference(listeners));
        } else {
            for (DataBindingUpdateListener listener : listeners) {
                if (!bindingName.equals(listener.getBindingName())) continue;
                return listener;
            }
        }
        DataBindingUpdateListener listener = new DataBindingUpdateListener(object, bindingName);
        listeners.add(listener);
        return listener;
    }

    public static void destroy(PropertyChangeSupport pcs) {
        PropertyChangeListener[] listeners;
        for (PropertyChangeListener l : listeners = pcs.getPropertyChangeListeners()) {
            if (log.isInfoEnabled()) {
                if (l instanceof PropertyChangeListenerProxy) {
                    PropertyChangeListenerProxy ll = (PropertyChangeListenerProxy)l;
                    log.info((Object)("remove property change listener " + ll.getPropertyName() + " : " + l));
                } else {
                    log.info((Object)("remove property change listener " + l));
                }
            }
            pcs.removePropertyChangeListener(l);
        }
    }

    public static void destroy(Component component) {
        PropertyChangeListener[] listeners;
        for (PropertyChangeListener l : listeners = component.getPropertyChangeListeners()) {
            if (log.isInfoEnabled()) {
                if (l instanceof PropertyChangeListenerProxy) {
                    PropertyChangeListenerProxy ll = (PropertyChangeListenerProxy)l;
                    log.info((Object)("remove property change listener " + ll.getPropertyName() + " : " + l));
                } else {
                    log.info((Object)("remove property change listener " + l));
                }
            }
            component.removePropertyChangeListener(l);
        }
    }

    @Deprecated
    public static boolean assignment(boolean value, String name, JAXXObject src) {
        src.firePropertyChange(name.trim(), null, "dummy value");
        return value;
    }

    @Deprecated
    public static byte assignment(byte value, String name, JAXXObject src) {
        src.firePropertyChange(name.trim(), null, "dummy value");
        return value;
    }

    @Deprecated
    public static short assignment(short value, String name, JAXXObject src) {
        src.firePropertyChange(name.trim(), null, "dummy value");
        return value;
    }

    @Deprecated
    public static int assignment(int value, String name, JAXXObject src) {
        src.firePropertyChange(name.trim(), null, "dummy value");
        return value;
    }

    @Deprecated
    public static long assignment(long value, String name, JAXXObject src) {
        src.firePropertyChange(name.trim(), null, "dummy value");
        return value;
    }

    @Deprecated
    public static float assignment(float value, String name, JAXXObject src) {
        src.firePropertyChange(name.trim(), null, "dummy value");
        return value;
    }

    @Deprecated
    public static double assignment(double value, String name, JAXXObject src) {
        src.firePropertyChange(name.trim(), null, "dummy value");
        return value;
    }

    @Deprecated
    public static char assignment(char value, String name, JAXXObject src) {
        src.firePropertyChange(name.trim(), null, "dummy value");
        return value;
    }

    @Deprecated
    public static Object assignment(Object value, String name, JAXXObject src) {
        src.firePropertyChange(name.trim(), null, "dummy value");
        return value;
    }

    public static String getStringValue(Object value) {
        String result = value == null ? "" : value.toString();
        return result;
    }

    public static void checkJAXXContextEntries(JAXXContext context, JAXXContextEntryDef<?> ... defs) throws IllegalArgumentException {
        for (JAXXContextEntryDef<?> def : defs) {
            Object value = def.getContextValue(context);
            if (value != null) continue;
            throw new IllegalArgumentException("the context entry [" + def + "] ] was not found in context " + context);
        }
    }

    public static <T> T checkJAXXContextEntry(JAXXContext context, JAXXContextEntryDef<T> def) throws IllegalArgumentException {
        T value = def.getContextValue(context);
        if (value == null) {
            throw new IllegalArgumentException("the context entry [" + def + "] ] was not found in context " + context);
        }
        return value;
    }

    public static void reloadBinding(JAXXBinding binding) {
        binding.removeDataBinding();
        binding.applyDataBinding();
    }

    public static void reloadBinding(JAXXObject src, String bindingId) {
        JAXXBinding dataBinding = src.getDataBinding(bindingId);
        if (dataBinding != null) {
            JAXXUtil.reloadBinding(dataBinding);
        } else if (log.isWarnEnabled()) {
            log.warn((Object)("Could not found binding[" + bindingId + "] on ui " + src));
        }
    }

    public static void applyDataBinding(JAXXObject src, String ... bindings) {
        for (String binding : bindings) {
            src.applyDataBinding(binding);
        }
    }

    public static void applyDataBinding(JAXXObject src, Collection<String> bindings) {
        for (String binding : bindings) {
            src.applyDataBinding(binding);
        }
    }

    public static void processDataBinding(JAXXObject src, String ... bindings) {
        for (String binding : bindings) {
            src.processDataBinding(binding);
        }
    }

    public static void removeDataBinding(JAXXObject src, String ... bindings) {
        for (String binding : bindings) {
            src.removeDataBinding(binding);
        }
    }

    public static void removeAllDataBindings(JAXXObject src) {
        JAXXBinding[] bindings;
        for (JAXXBinding binding : bindings = src.getDataBindings()) {
            JAXXUtil.removeDataBinding(src, binding.getId());
        }
    }

    public static PropertyChangeListener[] findJaxxPropertyChangeListener(String[] propertyNames, PropertyChangeListener ... listeners) {
        if (listeners == null || listeners.length == 0) {
            return EMPTY_ARRAY_PROPERTY_CHANGE_LISTENERS;
        }
        List<String> pNames = Arrays.asList(propertyNames);
        ArrayList<PropertyChangeListenerProxy> toRemove = new ArrayList<PropertyChangeListenerProxy>();
        for (PropertyChangeListener listener : listeners) {
            String pName = null;
            PropertyChangeListenerProxy plistener = null;
            if (listener instanceof PropertyChangeListenerProxy) {
                plistener = (PropertyChangeListenerProxy)listener;
                if (!pNames.contains(plistener.getPropertyName())) continue;
                listener = (PropertyChangeListener)plistener.getListener();
                pName = plistener.getPropertyName();
            }
            if (plistener == null || pName == null || !(listener instanceof DataBindingListener)) continue;
            if (log.isDebugEnabled()) {
                log.debug((Object)("find config listener to remove  [" + pName + "] : " + listener));
            }
            toRemove.add(plistener);
        }
        return toRemove.toArray(new PropertyChangeListener[toRemove.size()]);
    }

    public static <O> O invokeConstructor(Class<O> type, Class<?>[] prototype, Object ... parms) throws Exception {
        return (O)ConstructorUtils.invokeConstructor(type, (Object[])parms, (Class[])prototype);
    }

    public static void copyToClipBoard(String text) {
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        if (log.isInfoEnabled()) {
            log.info((Object)("Put in clipboard :\n" + text));
        }
        StringSelection selection = new StringSelection(text);
        clipboard.setContents(selection, selection);
    }

    private static class EventListenerDescriptor {
        Class<?> listenerClass;
        String listenerMethodName;
        String methodName;
        Object eventListener;

        private EventListenerDescriptor() {
        }
    }
}

