/*
 * Decompiled with CFR 0.152.
 */
package jaxx.runtime.swing.navigation;

import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.util.regex.Pattern;
import jaxx.runtime.Decorator;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.swing.navigation.NavigationTreeModel;
import jaxx.runtime.swing.navigation.NavigationTreeSelectionAdapter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;

public class NavigationUtil {
    private static final Log log = LogFactory.getLog(NavigationUtil.class);

    public static String getCurrentNavigationNath(JAXXContext context) {
        return (String)NavigationTreeSelectionAdapter.NAVIGATION_SELECTED_PATH_ENTRY_DEF.getContextValue(context);
    }

    public static NavigationTreeModel.NavigationTreeNode getSelectedNode(JAXXContext context) {
        return (NavigationTreeModel.NavigationTreeNode)NavigationTreeSelectionAdapter.NAVIGATION_SELECTED_NODE_ENTRY_DEF.getContextValue(context);
    }

    public static <O> O getSelectedBean(JAXXContext context, Class<O> clazz) {
        return (O)context.getContextValue(clazz, "navigation-selected-bean");
    }

    public static Object getContextValue(JAXXContext context, String contextKey, String navigationPath) throws InvocationTargetException, NoSuchMethodException, IllegalAccessException {
        NavigationTreeModel navigationModel = (NavigationTreeModel)context.getContextValue(NavigationTreeModel.class, contextKey);
        return navigationModel.getJAXXContextValue(context, navigationPath);
    }

    public static NavigationTreeModel.NavigationTreeNode findNode(JAXXContext context, String contextKey, String navigationPath) {
        NavigationTreeModel navigationModel = (NavigationTreeModel)context.getContextValue(NavigationTreeModel.class, contextKey);
        return navigationModel.findNode(navigationPath);
    }

    public static NavigationTreeModel.NavigationTreeNode findNode(JAXXContext context, String contextKey, String navigationPath, String regex) {
        NavigationTreeModel navigationModel = (NavigationTreeModel)context.getContextValue(NavigationTreeModel.class, contextKey);
        return navigationModel.findNode(navigationPath, regex);
    }

    public static NavigationTreeModel.NavigationTreeNode findNode(JAXXContext context, String contextKey, String navigationPath, Pattern regex) {
        NavigationTreeModel navigationModel = (NavigationTreeModel)context.getContextValue(NavigationTreeModel.class, contextKey);
        return navigationModel.findNode(navigationPath, regex);
    }

    public static NavigationTreeModel.NavigationTreeNode findNode(JAXXContext context, String contextKey, String navigationPath, String regex, String suffix) {
        NavigationTreeModel navigationModel = (NavigationTreeModel)context.getContextValue(NavigationTreeModel.class, contextKey);
        NavigationTreeModel.NavigationTreeNode navigationTreeNode = navigationModel.findNode(navigationPath, regex);
        if (navigationTreeNode != null && suffix != null) {
            navigationTreeNode = navigationModel.findNode(navigationTreeNode, suffix);
        }
        return navigationTreeNode;
    }

    public static NavigationTreeModel.NavigationTreeNode findNode(JAXXContext context, String contextKey, String navigationPath, Pattern regex, String suffix) {
        NavigationTreeModel navigationModel = (NavigationTreeModel)context.getContextValue(NavigationTreeModel.class, contextKey);
        NavigationTreeModel.NavigationTreeNode navigationTreeNode = navigationModel.findNode(navigationPath, regex);
        if (navigationTreeNode != null && suffix != null) {
            navigationTreeNode = navigationModel.findNode(navigationTreeNode, suffix);
        }
        return navigationTreeNode;
    }

    public static class NodeRenderer
    implements Serializable {
        protected String libelle;
        protected Decorator<?> decorator;
        protected NavigationTreeModel.NavigationTreeNode node;
        protected Class<?> internalClass;
        protected String rendererCachedValue;
        private static final long serialVersionUID = -1238962588426200861L;

        public NodeRenderer(String libelle) {
            this.libelle = libelle;
            this.internalClass = String.class;
        }

        public NodeRenderer(Decorator<?> decorator) {
            this.decorator = decorator;
            this.internalClass = decorator.getInternalClass();
        }

        public String toString(JAXXContext context) {
            String result;
            if (this.rendererCachedValue != null) {
                return this.rendererCachedValue;
            }
            if (this.libelle != null) {
                result = I18n._((String)this.libelle);
            } else {
                try {
                    Object bean = this.node.getJAXXContextValue(context);
                    result = this.decorator.toString(bean);
                }
                catch (Exception e) {
                    result = "";
                }
            }
            this.setRendererCachedValue(result);
            return result;
        }

        public void setNode(NavigationTreeModel.NavigationTreeNode node) {
            this.node = node;
        }

        public Class<?> getInternalClass() {
            return this.internalClass;
        }

        public void setRendererCachedValue(String rendererCachedValue) {
            this.rendererCachedValue = rendererCachedValue;
            if (log.isDebugEnabled()) {
                log.debug((Object)rendererCachedValue);
            }
        }

        public String getRendererCachedValue() {
            return this.rendererCachedValue;
        }
    }
}

