package jaxx.runtime.validator.swing;

import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JList;
import java.awt.Component;
import javax.swing.DefaultListCellRenderer;
import jaxx.runtime.validator.BeanValidatorScope;
import jaxx.runtime.SwingValidatorUtil;
import static org.nuiton.i18n.I18n._;

/**
 * A simple render of a table of validator's messages, says a table that use
 * a {@link SwingValidatorMessageTableModel} model.
 *
 * @author chemit
 * @since 1.3
 * @see SwingValidatorMessageTableModel
 */
public class SwingValidatorMessageListRenderer extends DefaultListCellRenderer {

    private static final long serialVersionUID = 1L;
    protected String format = "%1$-20s - %2$s";
    protected String formatTip = "%1$-20s - %2$-20s :  %3$s";

    public SwingValidatorMessageListRenderer() {
    }

    public SwingValidatorMessageListRenderer(String format) {
        this.format = format;
    }

    public String getFormat() {
        return format;
    }

    public void setFormat(String format) {
        this.format = format;
    }

    @Override
    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {

        JLabel rendererComponent = (JLabel) super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);

        SwingValidatorMessage model = (SwingValidatorMessage) value;

        // scope
        ImageIcon icon = SwingValidatorUtil.getIcon(model.getScope());

        // field name
        String fieldName = getFieldName(list, model.getField().getName(), index);

        // message
        String message = getMessage(model);

        // text to display
        String text = String.format(format, fieldName, message);

        String label = _(model.getScope().getLabel());
        String tmp = _("validator.scope.tip", label);
        String tmp2 = _("validator.field.tip", fieldName);

        String tooltTipText = String.format(formatTip, tmp, tmp2, message);


        rendererComponent.setText(text);
        rendererComponent.setToolTipText(tooltTipText);
        rendererComponent.setIcon(icon);

        return rendererComponent;
    }

    public ImageIcon getIcon(BeanValidatorScope scope) {
        ImageIcon icon = SwingValidatorUtil.getIcon(scope);
        return icon;
    }

    public String getMessage(SwingValidatorMessage model) {
        String text = SwingValidatorUtil.getMessage(model);
        return text;
    }

    public String getFieldName(JList list, String value, int row) {
        SwingValidatorMessageListModel tableModel = (SwingValidatorMessageListModel) list.getModel();
        SwingValidatorMessage model = (SwingValidatorMessage) tableModel.getElementAt(row);
        String fieldName = SwingValidatorUtil.getFieldName(model, value);
        return fieldName;
    }
}