package jaxx.runtime.swing;

import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;
import java.awt.Component;
import javax.swing.table.DefaultTableCellRenderer;

/**
 * A {@link TableCellRenderer} which does not display numbers when they are
 * equals to 0.
 *
 * @author chemit
 * @since 1.5
 */
public class EmptyNumberTableCellRenderer implements TableCellRenderer {

    protected final Integer ZERO = 0;
    protected final Float ZEROF = 0F;
    protected final Double ZEROD = 0D;
    private TableCellRenderer delegate;

    public EmptyNumberTableCellRenderer() {
        this(new DefaultTableCellRenderer());
    }

    public EmptyNumberTableCellRenderer(TableCellRenderer delegate) {
        this.delegate = delegate;
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        if (value == null || ZERO.equals(value) || ZEROF.equals(value) || ZEROD.equals(value)) {
            value = null;
        }
        return delegate.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
    }
}
