/*
 * Copyright 2006 Ethan Nicholas. All rights reserved.
 * Use is subject to license terms.
 */
package jaxx.runtime.swing;

import javax.swing.Icon;
import javax.swing.JTabbedPane;
import java.awt.Color;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;

public class TabInfoPropertyChangeListener implements PropertyChangeListener {

    private JTabbedPane tabs;
    private int tabIndex;

    public TabInfoPropertyChangeListener(JTabbedPane tabs, int tabIndex) {
        this.tabs = tabs;
        this.tabIndex = tabIndex;
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        String name = e.getPropertyName();
        if (name.equals(TabInfo.TITLE_PROPERTY)) {
            tabs.setTitleAt(tabIndex, (String) e.getNewValue());
        } else if (name.equals(TabInfo.TOOL_TIP_TEXT_PROPERTY)) {
            tabs.setToolTipTextAt(tabIndex, (String) e.getNewValue());
        } else if (name.equals(TabInfo.FOREGROUND_PROPERTY)) {
            tabs.setForegroundAt(tabIndex, (Color) e.getNewValue());
        } else if (name.equals(TabInfo.BACKGROUND_PROPERTY)) {
            tabs.setBackgroundAt(tabIndex, (Color) e.getNewValue());
        } else if (name.equals(TabInfo.MNEMONIC_PROPERTY)) {
            tabs.setMnemonicAt(tabIndex, (Integer) e.getNewValue());
        } else if (name.equals(TabInfo.DISPLAYED_MNEMONIC_INDEX_PROPERTY)) {
            tabs.setDisplayedMnemonicIndexAt(tabIndex, (Integer) e.getNewValue());
        } else if (name.equals(TabInfo.ICON_PROPERTY)) {
            tabs.setIconAt(tabIndex, (Icon) e.getNewValue());
        } else if (name.equals(TabInfo.DISABLED_ICON_PROPERTY)) {
            tabs.setDisabledIconAt(tabIndex, (Icon) e.getNewValue());
        }
    }
}    
