/*
 * Decompiled with CFR 0.152.
 */
package jaxx.runtime;

import java.awt.Component;
import java.awt.Dimension;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeListenerProxy;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventListener;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.UIManager;
import jaxx.Base64Coder;
import jaxx.runtime.DataBindingListener;
import jaxx.runtime.DataBindingUpdateListener;
import jaxx.runtime.Decorator;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXContextEntryDef;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.JAXXObjectDescriptor;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class Util {
    public static final String DEFAULT_ICON_PATH = "/icons/";
    public static final String DEFAULT_ICON_PATH_PROPERTY = "default.icon.path";
    private static final Log log = LogFactory.getLog(Util.class);
    private static Map<Object, WeakReference<List<EventListenerDescriptor>>> eventListeners = new WeakHashMap<Object, WeakReference<List<EventListenerDescriptor>>>();
    private static Map<JAXXObject, WeakReference<List<DataBindingUpdateListener>>> dataBindingUpdateListeners = new WeakHashMap<JAXXObject, WeakReference<List<DataBindingUpdateListener>>>();

    public static JAXXObjectDescriptor decodeJAXXObjectDescriptor(String descriptor) {
        try {
            return (JAXXObjectDescriptor)Base64Coder.deserialize(descriptor, false);
        }
        catch (IOException e) {
            throw new RuntimeException("Internal error: can't-happen error", e);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("Internal error: can't-happen error", e);
        }
    }

    public static JAXXObjectDescriptor decodeCompressedJAXXObjectDescriptor(String descriptor) {
        try {
            return (JAXXObjectDescriptor)Base64Coder.deserialize(descriptor, true);
        }
        catch (IOException e) {
            throw new RuntimeException("Internal error: can't-happen error", e);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("Internal error: can't-happen error", e);
        }
    }

    public static Object getEventListener(Class<? extends EventListener> listenerClass, final String listenerMethodName, final Object methodContainer, String methodName) {
        ArrayList<EventListenerDescriptor> descriptors;
        WeakReference<List<EventListenerDescriptor>> ref = eventListeners.get(methodContainer);
        ArrayList<EventListenerDescriptor> arrayList = descriptors = ref != null ? (ArrayList<EventListenerDescriptor>)ref.get() : null;
        if (descriptors == null) {
            descriptors = new ArrayList<EventListenerDescriptor>();
            eventListeners.put(methodContainer, new WeakReference(descriptors));
        } else {
            for (EventListenerDescriptor descriptor : descriptors) {
                if (listenerClass != descriptor.listenerClass || !(listenerMethodName == null ? descriptor.listenerMethodName == null : listenerMethodName.equals(descriptor.listenerMethodName)) || !methodName.equals(descriptor.methodName)) continue;
                return descriptor.eventListener;
            }
        }
        final EventListenerDescriptor descriptor = new EventListenerDescriptor();
        descriptor.listenerClass = listenerClass;
        descriptor.listenerMethodName = listenerMethodName;
        descriptor.methodName = methodName;
        try {
            final List<Method> listenerMethods = Arrays.asList(listenerClass.getMethods());
            Method listenerMethod = null;
            if (listenerMethodName != null) {
                for (Method listenerMethod1 : listenerMethods) {
                    if (!listenerMethod1.getName().equals(listenerMethodName)) continue;
                    listenerMethod = listenerMethod1;
                    break;
                }
            }
            if (listenerMethodName != null && listenerMethod == null) {
                throw new IllegalArgumentException("no method named " + listenerMethodName + " found in class " + listenerClass.getName());
            }
            Class<?>[] parameterTypes = listenerMethods.get(0).getParameterTypes();
            Class<?> methodContainerClass = methodContainer.getClass();
            final Method targetMethod = methodContainerClass.getMethod(methodName, parameterTypes);
            descriptor.eventListener = Proxy.newProxyInstance(listenerClass.getClassLoader(), new Class[]{listenerClass}, new InvocationHandler(){

                @Override
                public Object invoke(Object proxy, Method method, Object[] args) {
                    String methodName = method.getName();
                    if (listenerMethodName == null && listenerMethods.contains(method) || methodName.equals(listenerMethodName)) {
                        try {
                            return targetMethod.invoke(methodContainer, args);
                        }
                        catch (IllegalAccessException e) {
                            throw new RuntimeException(e);
                        }
                        catch (InvocationTargetException e) {
                            throw new RuntimeException(e);
                        }
                    }
                    if (methodName.equals("toString")) {
                        return this.toString();
                    }
                    if (methodName.equals("equals")) {
                        return descriptor.eventListener == args[0];
                    }
                    if (methodName.equals("hashCode")) {
                        return this.hashCode();
                    }
                    return null;
                }
            });
            descriptors.add(descriptor);
            return descriptor.eventListener;
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
    }

    public static Object getEventListener(Class<? extends EventListener> listenerClass, Object methodContainer, String methodName) {
        return Util.getEventListener(listenerClass, null, methodContainer, methodName);
    }

    public static DataBindingUpdateListener getDataBindingUpdateListener(JAXXObject object, String bindingName) {
        ArrayList<DataBindingUpdateListener> listeners;
        WeakReference<List<DataBindingUpdateListener>> ref = dataBindingUpdateListeners.get(object);
        ArrayList<DataBindingUpdateListener> arrayList = listeners = ref == null ? null : (ArrayList<DataBindingUpdateListener>)ref.get();
        if (listeners == null) {
            listeners = new ArrayList<DataBindingUpdateListener>();
            dataBindingUpdateListeners.put(object, new WeakReference(listeners));
        } else {
            for (DataBindingUpdateListener listener : listeners) {
                if (!bindingName.equals(listener.getBindingName())) continue;
                return listener;
            }
        }
        DataBindingUpdateListener listener = new DataBindingUpdateListener(object, bindingName);
        listeners.add(listener);
        return listener;
    }

    public static void setComponentWidth(Component component, int width) {
        component.setSize(width, component.getHeight());
        if (component instanceof JComponent) {
            JComponent jcomponent = (JComponent)component;
            jcomponent.setPreferredSize(new Dimension(width, jcomponent.getPreferredSize().height));
            jcomponent.setMinimumSize(new Dimension(width, jcomponent.getPreferredSize().height));
            if (jcomponent.isDisplayable()) {
                jcomponent.revalidate();
            }
        }
    }

    public static void setComponentHeight(Component component, int height) {
        component.setSize(component.getWidth(), height);
        if (component instanceof JComponent) {
            JComponent jcomponent = (JComponent)component;
            jcomponent.setPreferredSize(new Dimension(jcomponent.getPreferredSize().width, height));
            jcomponent.setMinimumSize(new Dimension(jcomponent.getPreferredSize().width, height));
            if (jcomponent.isDisplayable()) {
                jcomponent.revalidate();
            }
        }
    }

    public static boolean assignment(boolean value, String name, JAXXObject src) {
        src.firePropertyChange(name.trim(), null, "dummy value");
        return value;
    }

    public static byte assignment(byte value, String name, JAXXObject src) {
        src.firePropertyChange(name.trim(), null, "dummy value");
        return value;
    }

    public static short assignment(short value, String name, JAXXObject src) {
        src.firePropertyChange(name.trim(), null, "dummy value");
        return value;
    }

    public static int assignment(int value, String name, JAXXObject src) {
        src.firePropertyChange(name.trim(), null, "dummy value");
        return value;
    }

    public static long assignment(long value, String name, JAXXObject src) {
        src.firePropertyChange(name.trim(), null, "dummy value");
        return value;
    }

    public static float assignment(float value, String name, JAXXObject src) {
        src.firePropertyChange(name.trim(), null, "dummy value");
        return value;
    }

    public static double assignment(double value, String name, JAXXObject src) {
        src.firePropertyChange(name.trim(), null, "dummy value");
        return value;
    }

    public static char assignment(char value, String name, JAXXObject src) {
        src.firePropertyChange(name.trim(), null, "dummy value");
        return value;
    }

    public static Object assignment(Object value, String name, JAXXObject src) {
        src.firePropertyChange(name.trim(), null, "dummy value");
        return value;
    }

    public static String getStringValue(Object value) {
        String result = value == null ? "" : value.toString();
        return result;
    }

    public static <T> T checkJAXXContextEntry(JAXXContext context, JAXXContextEntryDef<T> def) throws IllegalArgumentException {
        T value = def.getContextValue(context);
        if (value == null) {
            throw new IllegalArgumentException("the context entry [" + def + "] ] was not found in context " + context);
        }
        return value;
    }

    public static void applyDataBinding(JAXXObject src, String ... bindings) {
        for (String binding : bindings) {
            src.applyDataBinding(binding);
        }
    }

    public static void processDataBinding(JAXXObject src, String ... bindings) {
        for (String binding : bindings) {
            src.processDataBinding(binding);
        }
    }

    public static void removeDataBinding(JAXXObject src, String ... bindings) {
        for (String binding : bindings) {
            src.removeDataBinding(binding);
        }
    }

    public static <O> DefaultListCellRenderer newDecoratedListCellRenderer(final Decorator<O> decorator) {
        return new DefaultListCellRenderer(){
            private static final long serialVersionUID = 1L;

            @Override
            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                String decorated = value instanceof String ? (String)value : decorator.toString(value);
                return super.getListCellRendererComponent((JList<?>)list, decorated, index, isSelected, cellHasFocus);
            }
        };
    }

    public static ImageIcon createIcon(String path) {
        URL imgURL = Util.class.getResource(path);
        if (imgURL != null) {
            return new ImageIcon(imgURL);
        }
        throw new IllegalArgumentException("could not find icon " + path);
    }

    public static ImageIcon createImageIcon(String path) {
        String iconPath = Util.getIconPath();
        return Util.createIcon(iconPath + path);
    }

    public static Icon getUIManagerIcon(String key) {
        return UIManager.getIcon(key);
    }

    public static Icon getUIManagerActionIcon(String key) {
        return Util.getUIManagerIcon("action." + key);
    }

    public static ImageIcon createActionIcon(String name) {
        String iconPath = Util.getIconPath();
        return Util.createIcon(iconPath + "action-" + name + ".png");
    }

    public static ImageIcon createI18nIcon(String name) {
        String iconPath = Util.getIconPath();
        return Util.createIcon(iconPath + "i18n/" + name + ".png");
    }

    public static PropertyChangeListener[] findJaxxPropertyChangeListener(String[] propertyNames, PropertyChangeListener ... listeners) {
        if (listeners == null || listeners.length == 0) {
            return new PropertyChangeListener[0];
        }
        List<String> pNames = Arrays.asList(propertyNames);
        ArrayList<PropertyChangeListenerProxy> toRemove = new ArrayList<PropertyChangeListenerProxy>();
        for (PropertyChangeListener listener : listeners) {
            String pName = null;
            PropertyChangeListenerProxy plistener = null;
            if (listener instanceof PropertyChangeListenerProxy) {
                plistener = (PropertyChangeListenerProxy)listener;
                if (!pNames.contains(plistener.getPropertyName())) continue;
                listener = (PropertyChangeListener)plistener.getListener();
                pName = plistener.getPropertyName();
            }
            if (plistener == null || pName == null || !(listener instanceof DataBindingListener)) continue;
            if (log.isDebugEnabled()) {
                log.debug((Object)("find config listener to remove  [" + pName + "] : " + listener));
            }
            toRemove.add(plistener);
        }
        return toRemove.toArray(new PropertyChangeListener[toRemove.size()]);
    }

    private static String getIconPath() {
        String iconPath = UIManager.getString(DEFAULT_ICON_PATH_PROPERTY);
        if (iconPath == null) {
            iconPath = DEFAULT_ICON_PATH;
        } else if (!iconPath.endsWith("/")) {
            iconPath = iconPath + "/";
        }
        return iconPath;
    }

    private static class EventListenerDescriptor {
        Class listenerClass;
        String listenerMethodName;
        String methodName;
        Object eventListener;

        private EventListenerDescriptor() {
        }
    }
}

