/*
 * Decompiled with CFR 0.152.
 */
package jaxx.compiler.binding;

import java.beans.Introspector;
import java.beans.PropertyChangeListener;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import jaxx.compiler.CompiledObject;
import jaxx.compiler.CompilerException;
import jaxx.compiler.JAXXCompiler;
import jaxx.compiler.UnsupportedAttributeException;
import jaxx.compiler.java.JavaField;
import jaxx.compiler.java.JavaFileGenerator;
import jaxx.compiler.java.parser.JavaParser;
import jaxx.compiler.java.parser.JavaParserConstants;
import jaxx.compiler.java.parser.JavaParserTreeConstants;
import jaxx.compiler.java.parser.SimpleNode;
import jaxx.compiler.reflect.ClassDescriptor;
import jaxx.compiler.reflect.ClassDescriptorLoader;
import jaxx.compiler.reflect.FieldDescriptor;
import jaxx.compiler.reflect.MethodDescriptor;
import jaxx.compiler.tags.DefaultObjectHandler;
import jaxx.compiler.tags.TagManager;
import jaxx.compiler.types.TypeManager;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DataSource {
    protected static final Log log = LogFactory.getLog(DataSource.class);
    private String id;
    private String source;
    private JAXXCompiler compiler;
    private List<String> dependencySymbols = new ArrayList<String>();
    private StringBuffer addListenerCode = new StringBuffer();
    private StringBuffer removeListenerCode = new StringBuffer();
    private boolean compiled;
    private String objectCode;
    private String listenerId;

    public DataSource(String id, String source, JAXXCompiler compiler) {
        this.id = id;
        this.source = source;
        this.compiler = compiler;
        if (log.isDebugEnabled()) {
            log.debug((Object)("id=" + id + " source=" + source));
        }
    }

    public String getId() {
        return this.id;
    }

    public String getSource() {
        return this.source;
    }

    public String getObjectCode() {
        return this.objectCode;
    }

    public String getListenerId() {
        return this.listenerId;
    }

    public boolean compile(String propertyChangeListenerCode) throws CompilerException, IllegalStateException {
        if (this.compiled) {
            throw new IllegalStateException(this + " has already been compiled");
        }
        this.listenerId = this.compiler.getAutoId(this.getClass().getSimpleName());
        if (log.isDebugEnabled()) {
            log.debug((Object)("listenerId=" + this.listenerId));
        }
        JavaParser p = new JavaParser(new StringReader(this.source));
        while (!p.Line()) {
            SimpleNode node = p.popNode();
            if (log.isDebugEnabled()) {
                log.debug((Object)("will scan node " + node.getText()));
            }
            this.scanNode(node);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("dependencySymbols=" + this.dependencySymbols));
        }
        if (this.dependencySymbols.size() > 0) {
            this.compiler.addSimpleField(new JavaField(2, PropertyChangeListener.class.getSimpleName(), this.listenerId, false, propertyChangeListenerCode));
            String javaCodeId = TypeManager.getJavaCode(this.id);
            String eol = JAXXCompiler.getLineSeparator();
            if (this.compiler.hasApplyDataBinding()) {
                this.compiler.appendApplyDataBinding(" else ");
            }
            this.compiler.appendApplyDataBinding("if (" + javaCodeId + ".equals($binding)) {");
            this.compiler.appendApplyDataBinding("    " + this.addListenerCode + eol);
            this.compiler.appendApplyDataBinding("}");
            if (this.compiler.hasRemoveDataBinding()) {
                this.compiler.appendRemoveDataBinding(" else ");
            }
            this.compiler.appendRemoveDataBinding("if (" + javaCodeId + ".equals($binding)) {");
            this.compiler.appendRemoveDataBinding("    " + this.removeListenerCode + eol);
            this.compiler.appendRemoveDataBinding("}");
        }
        this.compiled = true;
        return this.dependencySymbols.size() > 0;
    }

    private void scanNode(SimpleNode node) throws CompilerException {
        if (node.getId() == 22 || node.getId() == 17) {
            return;
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)node.getText());
        }
        int count = node.jjtGetNumChildren();
        for (int i = 0; i < count; ++i) {
            this.scanNode(node.getChild(i));
        }
        ClassDescriptor type = null;
        if (node.jjtGetNumChildren() == 1) {
            type = node.getChild(0).getJavaType();
        }
        switch (node.getId()) {
            case 31: {
                type = ClassDescriptorLoader.getClassDescriptor(Class.class);
                break;
            }
            case 62: {
                type = this.determineExpressionType(node);
                break;
            }
            case 66: {
                type = this.determineLiteralType(node);
                break;
            }
            case 61: {
                type = TagManager.resolveClass(node.getChild(0).getText(), this.compiler);
            }
        }
        node.setJavaType(type);
    }

    private ClassDescriptor determineExpressionType(SimpleNode expression) {
        assert (expression.getId() == 62);
        SimpleNode prefix = expression.getChild(0);
        if (prefix.jjtGetNumChildren() == 1) {
            int type = prefix.getChild(0).getId();
            if (type == 66 || type == 39) {
                prefix.setJavaType(prefix.getChild(0).getJavaType());
            } else if (type == 37 && expression.jjtGetNumChildren() == 1) {
                prefix.setJavaType(this.scanCompoundSymbol(prefix.getText().trim(), this.compiler.getRootObject().getObjectClass(), false));
            }
        }
        if (expression.jjtGetNumChildren() == 1) {
            return prefix.getJavaType();
        }
        ClassDescriptor contextClass = prefix.getJavaType();
        if (contextClass == null) {
            contextClass = this.compiler.getRootObject().getObjectClass();
        }
        String lastNode = prefix.getText().trim();
        for (int i = 1; i < expression.jjtGetNumChildren(); ++i) {
            SimpleNode suffix;
            block17: {
                suffix = expression.getChild(i);
                if (suffix.jjtGetNumChildren() == 1 && suffix.getChild(0).getId() == 69 && suffix.getChild(0).jjtGetNumChildren() == 0) {
                    if ((contextClass = this.scanCompoundSymbol(lastNode, contextClass, true)) == null) {
                        return null;
                    }
                    int dotPos = lastNode.lastIndexOf(".");
                    String code = dotPos == -1 ? "" : lastNode.substring(0, dotPos);
                    for (int j = i - 2; j >= 0; --j) {
                        code = expression.getChild(j).getText() + code;
                    }
                    if (code.length() == 0) {
                        code = this.compiler.getRootObject().getJavaCode();
                    }
                    String methodName = lastNode.substring(dotPos + 1).trim();
                    try {
                        MethodDescriptor method = contextClass.getMethodDescriptor(methodName, new ClassDescriptor[0]);
                        this.trackMemberIfPossible(code, contextClass, method.getName(), true);
                        return method.getReturnType();
                    }
                    catch (NoSuchMethodException e) {
                        MethodDescriptor newMethod;
                        String propertyName = null;
                        if (methodName.startsWith("is")) {
                            propertyName = Introspector.decapitalize(methodName.substring("is".length()));
                        } else if (methodName.startsWith("get")) {
                            propertyName = Introspector.decapitalize(methodName.substring("get".length()));
                        }
                        if (propertyName == null || (newMethod = this.compiler.getScriptMethod(methodName)) == null) break block17;
                        this.addListener(this.compiler.getRootObject().getId(), null, "addPropertyChangeListener(\"" + propertyName + "\", " + this.listenerId + ");" + JAXXCompiler.getLineSeparator(), "removePropertyChangeListener(\"" + propertyName + "\", " + this.listenerId + ");" + JAXXCompiler.getLineSeparator());
                        contextClass = newMethod.getReturnType();
                    }
                }
            }
            if (!(lastNode = suffix.getText().trim()).startsWith(".")) continue;
            lastNode = lastNode.substring(1);
        }
        return null;
    }

    private ClassDescriptor determineLiteralType(SimpleNode node) {
        assert (node.getId() == 66);
        if (node.jjtGetNumChildren() == 1) {
            int childId = node.getChild(0).getId();
            if (childId == 67) {
                return ClassDescriptorLoader.getClassDescriptor(Boolean.TYPE);
            }
            if (childId == 68) {
                return ClassDescriptorLoader.getClassDescriptor(NULL.class);
            }
            throw new RuntimeException("Expected BooleanLiteral or NullLiteral, found " + JavaParserTreeConstants.jjtNodeName[childId]);
        }
        int nodeId = node.firstToken.kind;
        switch (nodeId) {
            case 61: {
                if (node.firstToken.image.toLowerCase().endsWith("l")) {
                    return ClassDescriptorLoader.getClassDescriptor(Long.TYPE);
                }
                return ClassDescriptorLoader.getClassDescriptor(Integer.TYPE);
            }
            case 70: {
                return ClassDescriptorLoader.getClassDescriptor(Character.TYPE);
            }
            case 65: {
                if (node.firstToken.image.toLowerCase().endsWith("f")) {
                    return ClassDescriptorLoader.getClassDescriptor(Float.TYPE);
                }
                return ClassDescriptorLoader.getClassDescriptor(Double.TYPE);
            }
            case 71: {
                return ClassDescriptorLoader.getClassDescriptor(String.class);
            }
        }
        throw new RuntimeException("Expected literal token, found " + JavaParserConstants.tokenImage[nodeId]);
    }

    private ClassDescriptor scanCompoundSymbol(String symbol, ClassDescriptor contextClass, boolean isMethod) {
        String[] tokens = symbol.split("\\s*\\.\\s*");
        StringBuffer currentSymbol = new StringBuffer();
        StringBuffer tokensSeenSoFar = new StringBuffer();
        boolean recognizeClassNames = true;
        for (int j = 0; j < tokens.length - (isMethod ? 1 : 0); ++j) {
            boolean accepted;
            block11: {
                accepted = false;
                if (tokensSeenSoFar.length() > 0) {
                    tokensSeenSoFar.append('.');
                }
                tokensSeenSoFar.append(tokens[j]);
                if (currentSymbol.length() > 0) {
                    currentSymbol.append('.');
                }
                currentSymbol.append(tokens[j]);
                if (currentSymbol.indexOf(".") == -1) {
                    String memberName = currentSymbol.toString();
                    CompiledObject object = this.compiler.getCompiledObject(memberName);
                    if (object != null) {
                        contextClass = object.getObjectClass();
                        currentSymbol.setLength(0);
                        accepted = true;
                        recognizeClassNames = false;
                    } else {
                        try {
                            FieldDescriptor field = contextClass.getFieldDescriptor(memberName);
                            this.trackMemberIfPossible(tokensSeenSoFar.toString(), contextClass, field.getName(), false);
                            contextClass = field.getType();
                            currentSymbol.setLength(0);
                            accepted = true;
                            recognizeClassNames = false;
                        }
                        catch (NoSuchFieldException e) {
                            FieldDescriptor[] newFields;
                            if (j != 0 && (j != 1 || !tokens[0].equals(this.compiler.getRootObject().getId()))) break block11;
                            for (FieldDescriptor newField : newFields = this.compiler.getScriptFields()) {
                                if (!newField.getName().equals(memberName)) continue;
                                this.addListener(tokensSeenSoFar.toString(), null, "addPropertyChangeListener(\"" + memberName + "\", " + this.listenerId + ");" + JAXXCompiler.getLineSeparator(), "removePropertyChangeListener(\"" + memberName + "\", " + this.listenerId + ");" + JAXXCompiler.getLineSeparator());
                                contextClass = newField.getType();
                                assert (contextClass != null) : "script field '" + memberName + "' is defined, but has type null";
                                currentSymbol.setLength(0);
                                accepted = true;
                                recognizeClassNames = false;
                                break;
                            }
                        }
                    }
                }
            }
            if (currentSymbol.length() > 0 && recognizeClassNames && (contextClass = TagManager.resolveClass(currentSymbol.toString(), this.compiler)) != null) {
                currentSymbol.setLength(0);
                return null;
            }
            if (accepted) continue;
            return null;
        }
        return contextClass;
    }

    private void trackMemberIfPossible(String objectCode, ClassDescriptor objectClass, String memberName, boolean method) {
        DefaultObjectHandler handler = TagManager.getTagHandler(objectClass);
        try {
            if (handler.isMemberBound(memberName)) {
                this.addListener(objectCode + "." + memberName + (method ? "()" : ""), objectCode, handler.getAddMemberListenerCode(objectCode, this.id, memberName, this.listenerId, this.compiler), handler.getRemoveMemberListenerCode(objectCode, this.id, memberName, this.listenerId, this.compiler));
            }
        }
        catch (UnsupportedAttributeException e) {
            // empty catch block
        }
    }

    private void addListener(String dependencySymbol, String objectCode, String addCode, String removeCode) {
        boolean needTest;
        this.objectCode = objectCode;
        boolean bl = needTest = objectCode != null && !this.compiler.getRootObject().getId().equals(objectCode);
        if (!this.dependencySymbols.contains(dependencySymbol)) {
            this.dependencySymbols.add(dependencySymbol);
            String eol = JAXXCompiler.getLineSeparator();
            this.addListenerCode.append(eol);
            if (needTest) {
                this.addListenerCode.append("    if (").append(objectCode).append(" != null) {").append(eol);
            }
            this.addListenerCode.append(JavaFileGenerator.indent(addCode, needTest ? 8 : 4, false, eol));
            if (needTest) {
                this.addListenerCode.append(eol).append("    }");
            }
            this.removeListenerCode.append(eol);
            if (needTest) {
                this.removeListenerCode.append("    if (").append(objectCode).append(" != null) {").append(eol);
            }
            this.removeListenerCode.append(JavaFileGenerator.indent(removeCode, needTest ? 8 : 4, false, eol));
            if (needTest) {
                this.removeListenerCode.append(eol).append("    }");
            }
        }
    }

    private class NULL {
        private NULL() {
        }
    }
}

