/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.i18n.plugin.parser.impl;

import java.io.File;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.nuiton.i18n.plugin.parser.ParserEvent;
import org.nuiton.i18n.plugin.parser.impl.ParserJava;

public class ParserJavaActionConfig
extends ParserJava {
    protected static final Pattern MATCH_PATTERN = Pattern.compile("(name|shortDescription|longDescription|name2|shortDescription2|longDescription2)\\s*=\\s*\"([\\w|\\.]+)\"(|\\s*|\\s*,\\s*$)");

    @Override
    protected String getKeyModifierStart() {
        return "[\\w|\\.]+\\s*=\\s*\"";
    }

    @Override
    protected String getKeyModifierEnd() {
        return "\"\\s*(\\)|,|\\+|$)";
    }

    @Override
    protected String getOutGetter() {
        return "java-action-config.getter";
    }

    public String extract(String i18nString) {
        Matcher matcher = MATCH_PATTERN.matcher(i18nString.trim());
        if (matcher.matches()) {
            return matcher.group(2);
        }
        return null;
    }

    @Override
    public void parseLine(File srcFile, String line) {
        String key = this.extract(line);
        if (key != null) {
            this.touchFile = true;
            String keyModified = key;
            for (ParserEvent event : this.events) {
                event.eventChangeKey(key, !this.oldLanguage.containsKey((Object)key));
                keyModified = event.eventGetRealKey();
            }
            if (this.oldParser.containsKey((Object)key)) {
                this.result.put((Object)keyModified, this.oldParser.get((Object)key));
            } else {
                this.result.put((Object)keyModified, (Object)key);
            }
        }
    }
}

