/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.i18n.plugin.bundle;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.SortedSet;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Execute;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.nuiton.i18n.bundle.I18nBundleEntry;
import org.nuiton.i18n.bundle.I18nBundleUtil;
import org.nuiton.i18n.init.DefaultI18nInitializer;
import org.nuiton.i18n.plugin.I18nUtil;
import org.nuiton.i18n.plugin.bundle.AbstractI18nBundleMojo;
import org.nuiton.i18n.plugin.bundle.BundleFormatConverter;
import org.nuiton.io.SortedProperties;
import org.nuiton.plugin.PluginHelper;

@Mojo(name="bundle", defaultPhase=LifecyclePhase.GENERATE_RESOURCES, requiresProject=true, requiresDependencyResolution=ResolutionScope.RUNTIME)
@Execute(goal="collect-i18n-artifacts")
public class BundleMojo
extends AbstractI18nBundleMojo {
    @Parameter(property="i18n.bundleInputEncoding")
    protected String bundleInputEncoding;
    @Parameter(property="i18n.bundleOutputEncoding")
    protected String bundleOutputEncoding;
    @Parameter(property="i18n.bundleOutputDir", defaultValue="${basedir}/target/generated-sources/resources", required=true)
    protected File bundleOutputDir;
    @Parameter(property="i18n.bundleOutputPackage", defaultValue="META-INF", required=true)
    protected String bundleOutputPackage;
    @Parameter(property="i18n.bundleOutputName", defaultValue="${project.artifactId}-i18n", required=true)
    protected String bundleOutputName;
    @Parameter(property="i18n.generateDefaultLocale", defaultValue="false")
    protected boolean generateDefaultLocale;
    @Parameter(property="i18n.checkBundle", defaultValue="true")
    protected boolean checkBundle;
    @Parameter(property="i18n.showEmpty", defaultValue="false")
    protected boolean showEmpty;
    @Parameter(property="i18n.failsIfWarning", defaultValue="false")
    protected boolean failsIfWarning;
    protected Map<Locale, SortedSet<String>> unsafeMapping;
    protected File outputFolder;
    @Parameter(property="i18n.generateDefinitionFile", defaultValue="true")
    protected boolean generateDefinitionFile;
    @Deprecated
    @Parameter(property="i18n.generateCsvFile", defaultValue="false")
    protected boolean generateCsvFile;
    @Deprecated
    @Parameter(property="i18n.bundleCsvFile", defaultValue="${basedir}/target/${project.artifactId}-i18n.csv")
    protected File bundleCsvFile;
    @Deprecated
    @Parameter(property="i18n.bundleCsvSeparator", defaultValue="\t")
    protected String bundleCsvSeparator;
    @Parameter(property="i18n.bundleFormatConverter")
    protected String bundleFormatConverter;
    @Component(role=BundleFormatConverter.class)
    protected Map<String, BundleFormatConverter> bundleFormatConverters;
    protected BundleFormatConverter converter;

    @Override
    public void init() throws Exception {
        super.init();
        if (this.failsIfWarning) {
            this.checkBundle = true;
            this.unsafeMapping = new HashMap<Locale, SortedSet<String>>();
        } else {
            this.unsafeMapping = null;
        }
        this.outputFolder = this.getBundleOutputFolder();
        if (this.isVerbose()) {
            this.getLog().info((CharSequence)("Will generates bundles in " + this.outputFolder));
        }
        this.createDirectoryIfNecessary(this.outputFolder);
        if (StringUtils.isEmpty((CharSequence)this.bundleInputEncoding)) {
            this.bundleInputEncoding = this.getEncoding();
            if (this.getLog().isDebugEnabled()) {
                this.getLog().debug((CharSequence)("Use as input encoding the default one : " + this.bundleInputEncoding));
            }
        }
        if (StringUtils.isEmpty((CharSequence)this.bundleOutputEncoding)) {
            this.bundleOutputEncoding = this.getEncoding();
            if (this.getLog().isDebugEnabled()) {
                this.getLog().debug((CharSequence)("Use as output encoding the default one : " + this.bundleOutputEncoding));
            }
        }
        this.addResourceDir(this.bundleOutputDir, new String[]{"**/*.properties"});
        if (this.generateCsvFile) {
            this.getLog().warn((CharSequence)"");
            this.getLog().warn((CharSequence)"--------------------------------------------------------------------------------------------");
            this.getLog().warn((CharSequence)"Please use now the i18n:generate-csv-bundle mojo.");
            this.getLog().warn((CharSequence)"The csv bundle generation will be removed from this mojo soon.");
            this.getLog().warn((CharSequence)"--------------------------------------------------------------------------------------------");
            this.getLog().warn((CharSequence)"");
            this.addResourceDir(this.bundleOutputDir, new String[]{"**/*.csv"});
        }
        if (StringUtils.isNotEmpty((CharSequence)this.bundleFormatConverter)) {
            this.converter = this.bundleFormatConverters.get(this.bundleFormatConverter);
            if (this.converter == null) {
                throw new MojoExecutionException("There is no bundleFormatConverter named \"" + this.bundleFormatConverter + "\", known ones are " + this.bundleFormatConverters.keySet());
            }
        }
    }

    protected void doAction() throws Exception {
        long t00 = System.nanoTime();
        String version = this.getProject().getVersion();
        version = PluginHelper.removeSnapshotSuffix((String)version);
        String inputEncoding = this.getBundleInputEncoding();
        String outputEncoding = this.getBundleOutputEncoding();
        if (!this.silent) {
            this.getLog().info((CharSequence)("config - resources dir    : " + this.bundleOutputDir));
            this.getLog().info((CharSequence)("config - package name     : " + this.bundleOutputPackage));
            this.getLog().info((CharSequence)("config - bundle name      : " + this.bundleOutputName));
            this.getLog().info((CharSequence)("config - input  encoding  : " + inputEncoding));
            this.getLog().info((CharSequence)("config - output encoding  : " + outputEncoding));
            if (this.bundleFormatConverter != null) {
                this.getLog().info((CharSequence)("config - format converter : " + this.bundleFormatConverter));
            }
            this.getLog().info((CharSequence)("config - locales          : " + Arrays.toString(this.locales)));
            this.getLog().info((CharSequence)("config - version          : " + version));
        }
        LinkedHashMap<Locale, String> bundleDico = new LinkedHashMap<Locale, String>(this.locales.length);
        for (Locale locale : this.locales) {
            long t0 = System.nanoTime();
            File bundleOut = I18nUtil.getI18nFile(this.outputFolder, this.bundleOutputName, locale, false);
            SortedProperties propertiesOut = new SortedProperties(outputEncoding, false);
            StringBuilder buffer = new StringBuilder();
            URL[] urls = this.getCollectI18nResources(locale);
            if (urls.length == 0) {
                this.getLog().warn((CharSequence)("no bundle for locale " + locale));
                continue;
            }
            if (!this.silent) {
                this.getLog().info((CharSequence)("generate bundle for locale " + locale + " from " + urls.length + " i18n resource(s)"));
            }
            ArrayList<String> bundlesUrls = new ArrayList<String>();
            Charset loadEncoding = Charset.forName(inputEncoding);
            for (URL url : urls) {
                long t000 = System.nanoTime();
                I18nBundleEntry bundleEntry = new I18nBundleEntry(url, locale, null);
                bundleEntry.load((Properties)propertiesOut, loadEncoding);
                String strPath = bundleEntry.getPath().toString();
                int index = strPath.indexOf("i18n/");
                String str = strPath.substring(index);
                bundlesUrls.add(str);
                buffer.append(',').append(str);
                if (!this.verbose) continue;
                this.getLog().info((CharSequence)("loaded " + bundleEntry.getPath() + " in " + PluginHelper.convertTime((long)t000, (long)System.nanoTime())));
            }
            if (!bundlesUrls.isEmpty()) {
                bundleDico.put(locale, buffer.substring(1));
                if (!this.silent) {
                    if (this.getLog().isDebugEnabled()) {
                        this.getLog().debug((CharSequence)(bundlesUrls.size() + " i18n resource(s) detected"));
                    }
                    for (String u : bundlesUrls) {
                        this.getLog().info((CharSequence)u);
                    }
                }
            }
            if (this.converter != null) {
                this.applyConversion((Properties)propertiesOut);
            }
            propertiesOut.store(bundleOut);
            if (!this.silent && this.verbose) {
                this.getLog().info((CharSequence)("bundle created in " + PluginHelper.convertTime((long)t0, (long)System.nanoTime()) + " (detected sentences : " + propertiesOut.size() + ")"));
            }
            if (!this.checkBundle) continue;
            this.checkBundle(locale, (Properties)propertiesOut, this.showEmpty, this.unsafeMapping);
        }
        this.failsIfWarning();
        if (this.generateDefaultLocale) {
            this.generateDefaultBundle();
        }
        if (this.generateDefinitionFile) {
            this.generateDefinitionFile(version, bundleDico);
        }
        if (this.generateCsvFile) {
            this.generateCsvFile();
        }
        if (!this.silent && this.verbose) {
            this.getLog().info((CharSequence)("done in " + PluginHelper.convertTime((long)t00, (long)System.nanoTime())));
        }
    }

    protected File getBundleFile(File root, String artifactId, Locale locale, boolean create) throws IOException {
        return I18nUtil.getI18nFile(root, artifactId, locale, create);
    }

    protected void generateDefinitionFile(String version, Map<Locale, String> bundleDico) throws IOException {
        String f = String.format(DefaultI18nInitializer.UNIQUE_BUNDLE_DEF, this.bundleOutputName);
        File defOut = new File(this.outputFolder, f);
        if (!this.silent) {
            this.getLog().info((CharSequence)("prepare i18n definition file in " + defOut.getAbsolutePath()));
        }
        SortedProperties p = new SortedProperties(this.encoding, false);
        p.setProperty(DefaultI18nInitializer.BUNDLE_DEF_LOCALES, this.bundles);
        p.setProperty(DefaultI18nInitializer.BUNDLE_DEF_VERSION, version);
        p.setProperty(DefaultI18nInitializer.BUNDLE_DEF_ENCODING, this.encoding);
        for (Map.Entry<Locale, String> e : bundleDico.entrySet()) {
            p.setProperty(DefaultI18nInitializer.BUNDLES_FOR_LOCALE + e.getKey().toString(), e.getValue());
        }
        p.store(defOut);
    }

    @Override
    protected URL[] getCollectI18nResources(Locale locale) throws IOException {
        File file = this.getCollectOutputFile(locale, false);
        if (!file.exists()) {
            return I18nBundleUtil.EMPTY_URL_ARRAY;
        }
        URL[] urls = PluginHelper.getLinesAsURL((File)file);
        return urls;
    }

    protected void applyConversion(Properties properties) {
        for (Map.Entry<Object, Object> entry : properties.entrySet()) {
            String convertedValue = this.converter.convert((String)entry.getValue());
            properties.setProperty((String)entry.getKey(), convertedValue);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void generateCsvFile() throws IOException {
        if (!this.bundleCsvFile.exists()) {
            this.createNewFile(this.bundleCsvFile);
        }
        HashSet<String> allKeys = new HashSet<String>();
        LinkedHashMap<Locale, SortedProperties> bundlesByLocale = new LinkedHashMap<Locale, SortedProperties>();
        for (Locale locale : this.locales) {
            File bundleFile = this.getBundleFile(this.outputFolder, this.bundleOutputName, locale, false);
            SortedProperties properties = new SortedProperties(this.bundleOutputEncoding);
            properties.load(bundleFile);
            for (Object o : properties.keySet()) {
                allKeys.add((String)o);
            }
            bundlesByLocale.put(locale, properties);
        }
        ArrayList keys = new ArrayList(allKeys);
        Collections.sort(keys);
        BufferedWriter writer = new BufferedWriter(new FileWriter(this.bundleCsvFile));
        try {
            StringBuilder builder = new StringBuilder("Key");
            for (Locale locale : this.locales) {
                builder.append(this.bundleCsvSeparator).append(locale.getCountry());
            }
            writer.write(builder.toString());
            for (String key : keys) {
                writer.newLine();
                builder = new StringBuilder(key);
                for (Locale locale : this.locales) {
                    SortedProperties properties = (SortedProperties)bundlesByLocale.get(locale);
                    Object value = properties.get((Object)key);
                    builder.append(this.bundleCsvSeparator).append("\"");
                    builder.append(value == null ? "" : value);
                    builder.append("\"");
                }
                writer.write(builder.toString());
            }
            writer.close();
        }
        finally {
            IOUtils.closeQuietly((Writer)writer);
        }
        if (!this.isSilent()) {
            this.getLog().info((CharSequence)("Generate csv bundle file at " + this.bundleCsvFile));
        }
    }

    protected void failsIfWarning() throws MojoFailureException {
        if (!this.failsIfWarning) {
            return;
        }
        if (this.unsafeMapping != null && !this.unsafeMapping.isEmpty()) {
            throw new MojoFailureException("Bundles for locale(s) " + this.unsafeMapping.keySet() + " are not complete. Use the -Di18n.showEmpty to see " + "missing translations.");
        }
    }

    protected void generateDefaultBundle() throws IOException {
        File bundleFirstLocale = this.getBundleFile(this.outputFolder, this.bundleOutputName, this.locales[0], false);
        File bundleWithoutLocale = this.getBundleFile(this.outputFolder, this.bundleOutputName, null, false);
        if (!this.isSilent()) {
            this.getLog().info((CharSequence)("Generate default bundle at " + bundleWithoutLocale));
        }
        FileUtils.copyFile((File)bundleFirstLocale, (File)bundleWithoutLocale);
    }

    protected File getBundleOutputFolder() {
        File result = this.bundleOutputDir;
        if (StringUtils.isNotEmpty((CharSequence)this.bundleOutputPackage)) {
            String[] paths;
            for (String path : paths = this.bundleOutputPackage.split("\\.")) {
                result = new File(result, path);
            }
        }
        return result;
    }

    public String getBundleOutputEncoding() {
        return this.bundleOutputEncoding;
    }

    public String getBundleInputEncoding() {
        return this.bundleInputEncoding;
    }
}

