/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.io;

import java.io.File;
import org.nuiton.io.MirroredFileUpdater;

public class FileUpdaterHelper {
    public static MirroredFileUpdater newJavaFileUpdater() {
        return FileUpdaterHelper.newJavaFileUpdater(null, null);
    }

    public static MirroredFileUpdater newJaxxFileUpdater() {
        return FileUpdaterHelper.newJaxxFileUpdater(null, null);
    }

    public static MirroredFileUpdater newJavaFileUpdater(File src, File dst) {
        return new JavaFileUpdater(src, dst);
    }

    public static MirroredFileUpdater newJaxxFileUpdater(File src, File dst) {
        return new JaxxFileUpdater(src, dst);
    }

    public static class JaxxFileUpdater
    extends MirroredFileUpdater {
        protected JaxxFileUpdater(File sourceDirectory, File destinationDirectory) {
            super(".jaxx", ".java", sourceDirectory, destinationDirectory);
        }

        @Override
        public File getMirrorFile(File f) {
            String file = f.getAbsolutePath().substring(this.prefixSourceDirecotory);
            String mirrorRelativePath = file.substring(0, file.length() - 4) + "java";
            return new File(this.destinationDirectory + File.separator + mirrorRelativePath);
        }
    }

    public static class JavaFileUpdater
    extends MirroredFileUpdater {
        protected JavaFileUpdater(File sourceDirectory, File destinationDirectory) {
            super(".java", ".class", sourceDirectory, destinationDirectory);
        }

        @Override
        public File getMirrorFile(File f) {
            String file = f.getAbsolutePath().substring(this.prefixSourceDirecotory);
            String mirrorRelativePath = file.substring(0, file.length() - 4) + "class";
            return new File(this.destinationDirectory + File.separator + mirrorRelativePath);
        }
    }
}

