/*
 * Decompiled with CFR 0.152.
 */
package rice.tutorial.transportlayer;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import org.mpisws.p2p.transport.ErrorHandler;
import org.mpisws.p2p.transport.MessageCallback;
import org.mpisws.p2p.transport.MessageRequestHandle;
import org.mpisws.p2p.transport.P2PSocket;
import org.mpisws.p2p.transport.P2PSocketReceiver;
import org.mpisws.p2p.transport.SocketCallback;
import org.mpisws.p2p.transport.SocketRequestHandle;
import org.mpisws.p2p.transport.TransportLayer;
import org.mpisws.p2p.transport.TransportLayerCallback;
import org.mpisws.p2p.transport.liveness.LivenessProvider;
import org.mpisws.p2p.transport.liveness.Pinger;
import org.mpisws.p2p.transport.multiaddress.MultiInetSocketAddress;
import org.mpisws.p2p.transport.proximity.ProximityProvider;
import org.mpisws.p2p.transport.sourceroute.SourceRoute;
import org.mpisws.p2p.transport.sourceroute.factory.MultiAddressSourceRouteFactory;
import org.mpisws.p2p.transport.util.DefaultErrorHandler;
import org.mpisws.p2p.transport.util.MessageRequestHandleImpl;
import org.mpisws.p2p.transport.util.SocketRequestHandleImpl;
import org.mpisws.p2p.transport.util.SocketWrapperSocket;
import rice.environment.Environment;
import rice.environment.logging.Logger;
import rice.pastry.NodeIdFactory;
import rice.pastry.PastryNode;
import rice.pastry.PastryNodeFactory;
import rice.pastry.socket.SocketPastryNodeFactory;
import rice.selector.TimerTask;
import rice.tutorial.transportlayer.NotEnoughBandwidthException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BandwidthLimitingTransportLayer<Identifier>
implements TransportLayer<Identifier, ByteBuffer>,
TransportLayerCallback<Identifier, ByteBuffer> {
    protected TransportLayer<Identifier, ByteBuffer> tl;
    protected Environment environment;
    protected Logger logger;
    protected int BUCKET_SIZE;
    protected int BUCKET_TIME_LIMIT;
    protected int bucket;
    protected ErrorHandler<Identifier> errorHandler;
    TransportLayerCallback<Identifier, ByteBuffer> callback;
    Collection<BandwidthLimitingSocket> sockets = new ArrayList<BandwidthLimitingSocket>();

    public BandwidthLimitingTransportLayer(TransportLayer<Identifier, ByteBuffer> tl, int bucketSize, int bucketTimelimit, Environment env) {
        this.environment = env;
        this.tl = tl;
        this.BUCKET_SIZE = bucketSize;
        this.BUCKET_TIME_LIMIT = bucketTimelimit;
        this.logger = env.getLogManager().getLogger(BandwidthLimitingTransportLayer.class, null);
        this.errorHandler = new DefaultErrorHandler(this.logger);
        tl.setCallback(this);
        this.environment.getSelectorManager().getTimer().schedule(new TimerTask(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                1 var1_1 = this;
                synchronized (var1_1) {
                    BandwidthLimitingTransportLayer.this.bucket = BandwidthLimitingTransportLayer.this.BUCKET_SIZE;
                    for (BandwidthLimitingSocket s : BandwidthLimitingTransportLayer.this.sockets) {
                        s.notifyBandwidthRefilled();
                    }
                }
            }
        }, 0L, this.BUCKET_TIME_LIMIT);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MessageRequestHandle<Identifier, ByteBuffer> sendMessage(Identifier i, ByteBuffer m, final MessageCallback<Identifier, ByteBuffer> deliverAckToMe, Map<String, Object> options) {
        final MessageRequestHandleImpl<Identifier, ByteBuffer> returnMe = new MessageRequestHandleImpl<Identifier, ByteBuffer>(i, m, options);
        boolean success = true;
        BandwidthLimitingTransportLayer bandwidthLimitingTransportLayer = this;
        synchronized (bandwidthLimitingTransportLayer) {
            if (m.remaining() > this.bucket) {
                success = false;
            } else {
                this.bucket -= m.remaining();
            }
        }
        if (!success) {
            if (this.logger.level <= 500) {
                this.logger.log("Dropping message " + m + " because not enough bandwidth:" + this.bucket);
            }
            if (deliverAckToMe != null) {
                deliverAckToMe.sendFailed(returnMe, new NotEnoughBandwidthException(this.bucket, m.remaining()));
            }
            return returnMe;
        }
        returnMe.setSubCancellable(this.tl.sendMessage(i, m, new MessageCallback<Identifier, ByteBuffer>(){

            @Override
            public void ack(MessageRequestHandle<Identifier, ByteBuffer> msg) {
                if (deliverAckToMe != null) {
                    deliverAckToMe.ack(returnMe);
                }
            }

            @Override
            public void sendFailed(MessageRequestHandle<Identifier, ByteBuffer> msg, Exception reason) {
                if (deliverAckToMe != null) {
                    deliverAckToMe.sendFailed(returnMe, reason);
                }
            }
        }, options));
        return returnMe;
    }

    @Override
    public SocketRequestHandle<Identifier> openSocket(Identifier i, final SocketCallback<Identifier> deliverSocketToMe, Map<String, Object> options) {
        final SocketRequestHandleImpl<Identifier> returnMe = new SocketRequestHandleImpl<Identifier>(i, options, this.logger);
        returnMe.setSubCancellable(this.tl.openSocket(i, new SocketCallback<Identifier>(){

            @Override
            public void receiveResult(SocketRequestHandle<Identifier> cancellable, P2PSocket<Identifier> sock) {
                deliverSocketToMe.receiveResult(returnMe, new BandwidthLimitingSocket(sock));
            }

            @Override
            public void receiveException(SocketRequestHandle<Identifier> s, Exception ex) {
                deliverSocketToMe.receiveException(returnMe, ex);
            }
        }, options));
        return returnMe;
    }

    @Override
    public void setCallback(TransportLayerCallback<Identifier, ByteBuffer> callback) {
        this.callback = callback;
    }

    @Override
    public void incomingSocket(P2PSocket<Identifier> s) throws IOException {
        this.callback.incomingSocket(new BandwidthLimitingSocket(s));
    }

    @Override
    public void acceptMessages(boolean b) {
        this.tl.acceptMessages(b);
    }

    @Override
    public void acceptSockets(boolean b) {
        this.tl.acceptSockets(b);
    }

    @Override
    public Identifier getLocalIdentifier() {
        return this.tl.getLocalIdentifier();
    }

    @Override
    public void setErrorHandler(ErrorHandler<Identifier> handler) {
        this.errorHandler = handler;
        this.tl.setErrorHandler(handler);
    }

    @Override
    public void destroy() {
        this.tl.destroy();
    }

    @Override
    public void messageReceived(Identifier i, ByteBuffer m, Map<String, Object> options) throws IOException {
        this.callback.messageReceived(i, m, options);
    }

    public static PastryNodeFactory exampleA(int bindport, Environment env, NodeIdFactory nidFactory, final int amt, final int time) throws IOException {
        SocketPastryNodeFactory factory = new SocketPastryNodeFactory(nidFactory, bindport, env){

            @Override
            protected TransportLayer<InetSocketAddress, ByteBuffer> getWireTransportLayer(InetSocketAddress innermostAddress, PastryNode pn) throws IOException {
                TransportLayer<InetSocketAddress, ByteBuffer> wtl = super.getWireTransportLayer(innermostAddress, pn);
                return new BandwidthLimitingTransportLayer<InetSocketAddress>(wtl, amt, time, pn.getEnvironment());
            }
        };
        return factory;
    }

    public static PastryNodeFactory exampleB(int bindport, Environment env, NodeIdFactory nidFactory, final int amt, final int time) throws IOException {
        SocketPastryNodeFactory factory = new SocketPastryNodeFactory(nidFactory, bindport, env){

            @Override
            protected SocketPastryNodeFactory.TransLivenessProximity<MultiInetSocketAddress, ByteBuffer> getSourceRouteManagerLayer(TransportLayer<SourceRoute<MultiInetSocketAddress>, ByteBuffer> ltl, LivenessProvider<SourceRoute<MultiInetSocketAddress>> livenessProvider, Pinger<SourceRoute<MultiInetSocketAddress>> pinger, PastryNode pn, MultiInetSocketAddress proxyAddress, MultiAddressSourceRouteFactory esrFactory) throws IOException {
                final SocketPastryNodeFactory.TransLivenessProximity<MultiInetSocketAddress, ByteBuffer> srm = super.getSourceRouteManagerLayer(ltl, livenessProvider, pinger, pn, proxyAddress, esrFactory);
                final BandwidthLimitingTransportLayer<MultiInetSocketAddress> bll = new BandwidthLimitingTransportLayer<MultiInetSocketAddress>(srm.getTransportLayer(), amt, time, pn.getEnvironment());
                return new SocketPastryNodeFactory.TransLivenessProximity<MultiInetSocketAddress, ByteBuffer>(){

                    @Override
                    public TransportLayer<MultiInetSocketAddress, ByteBuffer> getTransportLayer() {
                        return bll;
                    }

                    @Override
                    public LivenessProvider<MultiInetSocketAddress> getLivenessProvider() {
                        return srm.getLivenessProvider();
                    }

                    @Override
                    public ProximityProvider<MultiInetSocketAddress> getProximityProvider() {
                        return srm.getProximityProvider();
                    }
                };
            }
        };
        return factory;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class BandwidthLimitingSocket
    extends SocketWrapperSocket<Identifier, Identifier> {
        P2PSocketReceiver<Identifier> storedWriter;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public BandwidthLimitingSocket(P2PSocket<Identifier> socket) {
            super(socket.getIdentifier(), socket, BandwidthLimitingTransportLayer.this.logger, BandwidthLimitingTransportLayer.this.errorHandler, socket.getOptions());
            BandwidthLimitingTransportLayer bandwidthLimitingTransportLayer2 = BandwidthLimitingTransportLayer.this;
            synchronized (bandwidthLimitingTransportLayer2) {
                BandwidthLimitingTransportLayer.this.sockets.add(this);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public long write(ByteBuffer srcs) throws IOException {
            if (srcs.remaining() <= BandwidthLimitingTransportLayer.this.bucket) {
                long ret = super.write(srcs);
                if (ret >= 0L) {
                    BandwidthLimitingSocket bandwidthLimitingSocket = this;
                    synchronized (bandwidthLimitingSocket) {
                        BandwidthLimitingTransportLayer.this.bucket = (int)((long)BandwidthLimitingTransportLayer.this.bucket - ret);
                    }
                }
                return ret;
            }
            if (this.logger.level <= 500) {
                this.logger.log("Limiting " + this.socket + " to " + BandwidthLimitingTransportLayer.this.bucket + " bytes.");
            }
            int originalPosition = srcs.position();
            ByteBuffer temp = ByteBuffer.wrap(srcs.array(), originalPosition, BandwidthLimitingTransportLayer.this.bucket);
            long ret = super.write(temp);
            if (ret < 0L) {
                return ret;
            }
            BandwidthLimitingSocket bandwidthLimitingSocket = this;
            synchronized (bandwidthLimitingSocket) {
                BandwidthLimitingTransportLayer.this.bucket = (int)((long)BandwidthLimitingTransportLayer.this.bucket - ret);
            }
            srcs.position(originalPosition + (int)ret);
            return ret;
        }

        @Override
        public void register(boolean wantToRead, boolean wantToWrite, P2PSocketReceiver<Identifier> receiver) {
            boolean canWrite = wantToWrite;
            if (wantToWrite && BandwidthLimitingTransportLayer.this.bucket == 0) {
                canWrite = false;
                this.storedWriter = receiver;
            }
            if (wantToRead || canWrite) {
                super.register(wantToRead, canWrite, receiver);
            }
        }

        public void notifyBandwidthRefilled() {
            if (this.storedWriter != null) {
                P2PSocketReceiver temp = this.storedWriter;
                this.storedWriter = null;
                super.register(false, true, temp);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void close() {
            super.close();
            BandwidthLimitingTransportLayer bandwidthLimitingTransportLayer = BandwidthLimitingTransportLayer.this;
            synchronized (bandwidthLimitingTransportLayer) {
                BandwidthLimitingTransportLayer.this.sockets.remove(this);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void shutdownOutput() {
            super.shutdownOutput();
            BandwidthLimitingTransportLayer bandwidthLimitingTransportLayer = BandwidthLimitingTransportLayer.this;
            synchronized (bandwidthLimitingTransportLayer) {
                BandwidthLimitingTransportLayer.this.sockets.remove(this);
            }
        }
    }
}

