/*
 * Decompiled with CFR 0.152.
 */
package rice.tutorial.gtitm;

import java.io.File;
import java.io.IOException;
import java.util.Vector;
import rice.environment.Environment;
import rice.p2p.commonapi.rawserialization.RawMessage;
import rice.pastry.Id;
import rice.pastry.NodeHandle;
import rice.pastry.PastryNode;
import rice.pastry.PastryNodeFactory;
import rice.pastry.direct.DirectNodeHandle;
import rice.pastry.direct.DirectPastryNodeFactory;
import rice.pastry.direct.GenericNetwork;
import rice.pastry.leafset.LeafSet;
import rice.pastry.standard.RandomNodeIdFactory;
import rice.tutorial.gtitm.MyApp;

public class DirectTutorial {
    Vector<MyApp> apps = new Vector();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DirectTutorial(int numNodes, Environment env, String fileName) throws Exception {
        RandomNodeIdFactory nidFactory = new RandomNodeIdFactory(env);
        GenericNetwork<DirectNodeHandle, RawMessage> simulator = new GenericNetwork<DirectNodeHandle, RawMessage>(env, new File(fileName));
        simulator.setMaxSpeed(1.0f);
        DirectPastryNodeFactory factory = new DirectPastryNodeFactory(nidFactory, simulator, env);
        NodeHandle bootHandle = null;
        for (int curNode = 0; curNode < numNodes; ++curNode) {
            PastryNode node = ((PastryNodeFactory)factory).newNode();
            MyApp app = new MyApp(node);
            this.apps.add(app);
            node.boot(bootHandle);
            bootHandle = node.getLocalHandle();
            simulator.setMaxSpeed(curNode + 1);
            PastryNode pastryNode = node;
            synchronized (pastryNode) {
                while (!node.isReady() && !node.joinFailed()) {
                    node.wait(500L);
                    if (!node.joinFailed()) continue;
                    throw new IOException("Could not join the FreePastry ring.  Reason:" + node.joinFailedReason());
                }
            }
            System.out.println("Finished creating new node " + node);
        }
        env.getTimeSource().sleep(10000L);
        simulator.setFullSpeed();
        for (int i = 0; i < 10; ++i) {
            for (MyApp app : this.apps) {
                Id randId = nidFactory.generateNodeId();
                app.routeMyMsg(randId);
                env.getTimeSource().sleep(100L);
            }
        }
        env.getTimeSource().sleep(1000L);
        for (MyApp app : this.apps) {
            PastryNode node = (PastryNode)app.getNode();
            LeafSet leafSet = node.getLeafSet();
            for (int i = -leafSet.ccwSize(); i <= leafSet.cwSize(); ++i) {
                if (i == 0) continue;
                NodeHandle nh = leafSet.get(i);
                app.routeMyMsgDirect(nh);
                env.getTimeSource().sleep(100L);
            }
        }
    }

    public static void main(String[] args) throws Exception {
        Environment env = Environment.directEnvironment();
        try {
            int numNodes = Integer.parseInt(args[0]);
            String fileName = "GNPINPUT";
            if (args.length > 1) {
                fileName = args[1];
            }
            DirectTutorial dt = new DirectTutorial(numNodes, env, fileName);
        }
        catch (Exception e) {
            System.out.println("Usage:");
            System.out.println("java [-cp FreePastry-<version>.jar] rice.tutorial.gtitm.DirectTutorial numNodes <filename>");
            System.out.println("example java rice.tutorial.gtitm.DirectTutorial 100 GNPINPUT");
            throw e;
        }
    }
}

