/*
 * Decompiled with CFR 0.152.
 */
package rice.tutorial.deterministicsimulator;

import java.io.IOException;
import java.util.Iterator;
import java.util.Observable;
import java.util.Observer;
import java.util.Vector;
import rice.environment.Environment;
import rice.p2p.commonapi.rawserialization.RawMessage;
import rice.pastry.Id;
import rice.pastry.JoinFailedException;
import rice.pastry.NodeHandle;
import rice.pastry.NodeIdFactory;
import rice.pastry.PastryNode;
import rice.pastry.PastryNodeFactory;
import rice.pastry.direct.DirectNodeHandle;
import rice.pastry.direct.DirectPastryNodeFactory;
import rice.pastry.direct.EuclideanNetwork;
import rice.pastry.leafset.LeafSet;
import rice.pastry.standard.RandomNodeIdFactory;
import rice.selector.TimerTask;
import rice.tutorial.deterministicsimulator.MyApp;

public class DirectTutorial {
    Vector apps = new Vector();

    public DirectTutorial(int numNodes, Environment env) throws Exception {
        RandomNodeIdFactory nidFactory = new RandomNodeIdFactory(env);
        EuclideanNetwork<DirectNodeHandle, RawMessage> simulator = new EuclideanNetwork<DirectNodeHandle, RawMessage>(env);
        simulator.stop();
        DirectPastryNodeFactory factory = new DirectPastryNodeFactory(nidFactory, simulator, env);
        this.scheduleBootTask(numNodes, nidFactory, factory, env);
        simulator.start();
    }

    public void scheduleBootTask(final int numNodes, final NodeIdFactory nidFactory, final PastryNodeFactory factory, final Environment env) {
        env.getSelectorManager().getTimer().schedule(new TimerTask(){
            NodeHandle bootHandle = null;
            int curNode = 0;

            public void run() {
                try {
                    final PastryNode node = factory.newNode();
                    System.out.println("Creating new node " + node + " at " + env.getTimeSource().currentTimeMillis());
                    MyApp app = new MyApp(node);
                    DirectTutorial.this.apps.add(app);
                    ++this.curNode;
                    final int myCurNode = this.curNode;
                    node.addObserver(new Observer(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        public void update(Observable o, Object arg) {
                            try {
                                if (arg instanceof Boolean) {
                                    System.out.println("Finished creating new node " + node + " at " + env.getTimeSource().currentTimeMillis());
                                    if (myCurNode == numNodes) {
                                        DirectTutorial.this.scheduleDeliveryTask(nidFactory, env);
                                    }
                                } else if (arg instanceof JoinFailedException) {
                                    JoinFailedException jfe = (JoinFailedException)arg;
                                    jfe.printStackTrace();
                                    throw new RuntimeException(jfe);
                                }
                            }
                            finally {
                                o.deleteObserver(this);
                            }
                        }
                    });
                    node.boot(this.bootHandle);
                    this.bootHandle = node.getLocalHandle();
                    if (this.curNode >= numNodes) {
                        this.cancel();
                    }
                }
                catch (IOException ioe) {
                    throw new RuntimeException(ioe);
                }
            }
        }, 0L, 1000L);
    }

    public void scheduleDeliveryTask(final NodeIdFactory nidFactory, Environment env) {
        env.getSelectorManager().getTimer().schedule(new TimerTask(){
            int i = 0;

            public void run() {
                for (MyApp app : DirectTutorial.this.apps) {
                    Id randId = nidFactory.generateNodeId();
                    app.routeMyMsg(randId);
                }
                ++this.i;
                if (this.i >= 10) {
                    this.cancel();
                }
            }
        }, 10000L, 1000L);
        env.getSelectorManager().getTimer().schedule(new TimerTask(){
            Iterator<MyApp> appIterator;
            {
                this.appIterator = DirectTutorial.this.apps.iterator();
            }

            public void run() {
                if (this.appIterator.hasNext()) {
                    MyApp app = this.appIterator.next();
                    PastryNode node = (PastryNode)app.getNode();
                    LeafSet leafSet = node.getLeafSet();
                    for (int i = -leafSet.ccwSize(); i <= leafSet.cwSize(); ++i) {
                        if (i == 0) continue;
                        NodeHandle nh = leafSet.get(i);
                        app.routeMyMsgDirect(nh);
                    }
                } else {
                    this.cancel();
                }
            }
        }, 20000L, 1000L);
    }

    public static void main(String[] args) throws Exception {
        Environment env;
        if (args.length > 1) {
            int randSeed = Integer.parseInt(args[1]);
            env = Environment.directEnvironment(randSeed);
        } else {
            env = Environment.directEnvironment();
        }
        try {
            int numNodes = Integer.parseInt(args[0]);
            DirectTutorial directTutorial = new DirectTutorial(numNodes, env);
        }
        catch (Exception e) {
            System.out.println("Usage:");
            System.out.println("java [-cp FreePastry-<version>.jar] rice.tutorial.direct.DirectTutorial numNodes");
            System.out.println("example java rice.tutorial.direct.DirectTutorial 100");
            throw e;
        }
    }
}

