/*
 * Decompiled with CFR 0.152.
 */
package rice.persistence.testing;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.zip.GZIPInputStream;
import rice.p2p.glacier.v2.FragmentAndManifest;
import rice.p2p.util.XMLObjectInputStream;

public class GlacierPersistentStorageTest {
    File root;

    public GlacierPersistentStorageTest(String root) throws IOException {
        this.root = new File("FreePastry-Storage-Root/" + root);
    }

    public void start() throws Exception {
        this.process(this.root);
    }

    protected void process(File file) throws Exception {
        File[] files = file.listFiles();
        for (int i = 0; i < files.length; ++i) {
            if (files[i].isFile() && files[i].getName().length() > 20) {
                XMLObjectInputStream objin = new XMLObjectInputStream(new BufferedInputStream(new GZIPInputStream(new FileInputStream(files[i]))));
                objin.readObject();
                Object o = objin.readObject();
                if (o instanceof FragmentAndManifest) {
                    FragmentAndManifest fm = (FragmentAndManifest)o;
                    int total = fm.fragment.payload.length + 24;
                    total += fm.manifest.getObjectHash().length + fm.manifest.getSignature().length;
                    System.out.println(files[i].getName() + "\t" + (total += fm.manifest.getFragmentHashes().length * fm.manifest.getFragmentHashes()[0].length) + "\t" + files[i].length());
                } else {
                    System.out.println("ERROR: Found class " + o.getClass().getName());
                }
                ((ObjectInputStream)objin).close();
                continue;
            }
            if (!files[i].isDirectory()) continue;
            this.process(files[i]);
        }
    }

    public static void main(String[] args) throws Exception {
        GlacierPersistentStorageTest test = new GlacierPersistentStorageTest("sys08.cs.rice.edu-10001-glacier-immutable");
        test.start();
    }
}

