/*
 * Decompiled with CFR 0.152.
 */
package rice.pastry.socket.nat.rendezvous;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.util.Map;
import org.mpisws.p2p.transport.MessageCallback;
import org.mpisws.p2p.transport.MessageRequestHandle;
import org.mpisws.p2p.transport.exception.NodeIsFaultyException;
import org.mpisws.p2p.transport.rendezvous.RendezvousStrategy;
import org.mpisws.p2p.transport.rendezvous.RendezvousTransportLayer;
import org.mpisws.p2p.transport.util.MessageRequestHandleImpl;
import org.mpisws.p2p.transport.util.OptionsFactory;
import rice.Continuation;
import rice.p2p.commonapi.Cancellable;
import rice.p2p.commonapi.rawserialization.InputBuffer;
import rice.p2p.commonapi.rawserialization.MessageDeserializer;
import rice.p2p.util.AttachableCancellable;
import rice.pastry.NodeHandle;
import rice.pastry.PastryNode;
import rice.pastry.client.PastryAppl;
import rice.pastry.leafset.LeafSet;
import rice.pastry.messaging.Message;
import rice.pastry.routing.RouteMessage;
import rice.pastry.routing.RouteMessageNotification;
import rice.pastry.socket.nat.rendezvous.ByteBufferMsg;
import rice.pastry.socket.nat.rendezvous.OpenChannelMsg;
import rice.pastry.socket.nat.rendezvous.PilotForwardMsg;
import rice.pastry.socket.nat.rendezvous.RendezvousSocketNodeHandle;
import rice.pastry.transport.PMessageNotification;
import rice.pastry.transport.PMessageReceipt;
import rice.selector.SelectorManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RendezvousApp
extends PastryAppl
implements RendezvousStrategy<RendezvousSocketNodeHandle> {
    protected LeafSet leafSet;
    protected SelectorManager selectorManager;
    protected RendezvousTransportLayer<RendezvousSocketNodeHandle> tl;

    public RendezvousApp(PastryNode pn) {
        super(pn, null, 0, null);
        this.setDeserializer(new MessageDeserializer(){

            public rice.p2p.commonapi.Message deserialize(InputBuffer buf, short type, int priority, rice.p2p.commonapi.NodeHandle sender) throws IOException {
                switch (type) {
                    case 1: {
                        byte version = buf.readByte();
                        if (version == 0) {
                            NodeHandle originalSender = RendezvousApp.this.thePastryNode.readNodeHandle(buf);
                            int length = buf.readInt();
                            byte[] msg = new byte[length];
                            buf.read(msg);
                            return new ByteBufferMsg(ByteBuffer.wrap(msg), originalSender, priority, RendezvousApp.this.getAddress());
                        }
                        throw new IllegalArgumentException("Unknown version for ByteBufferMsg: " + version);
                    }
                    case 2: {
                        byte version = buf.readByte();
                        if (version == 0) {
                            RendezvousSocketNodeHandle target = (RendezvousSocketNodeHandle)RendezvousApp.this.thePastryNode.readNodeHandle(buf);
                            ByteBufferMsg subMsg = (ByteBufferMsg)this.deserialize(buf, (short)1, priority, sender);
                            return new PilotForwardMsg(RendezvousApp.this.getAddress(), subMsg, target);
                        }
                        throw new IllegalArgumentException("Unknown version for PilotForwardMsg: " + version);
                    }
                    case 3: {
                        byte version = buf.readByte();
                        if (version == 0) {
                            RendezvousSocketNodeHandle rendezvous = (RendezvousSocketNodeHandle)RendezvousApp.this.thePastryNode.readNodeHandle(buf);
                            RendezvousSocketNodeHandle source = (RendezvousSocketNodeHandle)RendezvousApp.this.thePastryNode.readNodeHandle(buf);
                            int uid = buf.readInt();
                            return new OpenChannelMsg(RendezvousApp.this.getAddress(), rendezvous, source, uid);
                        }
                        throw new IllegalArgumentException("Unknown version for PilotForwardMsg: " + version);
                    }
                }
                throw new IllegalArgumentException("Unknown type: " + type);
            }
        });
        this.leafSet = pn.getLeafSet();
        this.selectorManager = pn.getEnvironment().getSelectorManager();
    }

    public void isNatted(rice.p2p.commonapi.NodeHandle bootstrap, Continuation<InetSocketAddress, Exception> receiveResult) {
    }

    @Override
    public void messageForAppl(Message msg) {
        if (msg instanceof ByteBufferMsg) {
            block7: {
                ByteBufferMsg bbm = (ByteBufferMsg)msg;
                if (this.logger.level <= 500) {
                    this.logger.log("messageForAppl(" + bbm + ")");
                }
                try {
                    this.tl.messageReceivedFromOverlay((RendezvousSocketNodeHandle)bbm.getOriginalSender(), bbm.buffer, null);
                }
                catch (IOException ioe) {
                    if (this.logger.level > 900) break block7;
                    this.logger.logException("dropping " + bbm, ioe);
                }
            }
            return;
        }
        if (msg instanceof PilotForwardMsg) {
            PilotForwardMsg pfm = (PilotForwardMsg)msg;
            if (this.logger.level <= 400) {
                this.logger.log("Forwarding message " + pfm);
            }
            this.thePastryNode.send(pfm.getTarget(), pfm.getBBMsg(), null, null);
            return;
        }
        if (msg instanceof OpenChannelMsg) {
            OpenChannelMsg ocm = (OpenChannelMsg)msg;
            this.tl.openChannel(ocm.getSource(), ocm.getRendezvous(), ocm.getUid());
            return;
        }
    }

    @Override
    public boolean deliverWhenNotReady() {
        return true;
    }

    @Override
    public Cancellable openChannel(final RendezvousSocketNodeHandle target, final RendezvousSocketNodeHandle rendezvous, final RendezvousSocketNodeHandle source, final int uid, final Continuation<Integer, Exception> deliverAckToMe, final Map<String, Object> options) {
        if (this.logger.level <= 800) {
            this.logger.log("openChannel()" + source + "->" + target + " via " + rendezvous + " uid:" + uid + "," + deliverAckToMe + "," + options);
        }
        if (target.getLiveness() > 3) {
            if (this.logger.level <= 800) {
                this.logger.log("openChannel() attempted to open to dead_forever target. Dropping." + source + "->" + target + " via " + rendezvous + " uid:" + uid + "," + deliverAckToMe + "," + options);
            }
            if (deliverAckToMe != null) {
                deliverAckToMe.receiveException(new NodeIsFaultyException(target));
            }
            return null;
        }
        if (target.canContactDirect()) {
            throw new IllegalArgumentException("Target must be firewalled.  Target:" + target);
        }
        if (!this.selectorManager.isSelectorThread()) {
            final AttachableCancellable ret = new AttachableCancellable();
            this.selectorManager.invoke(new Runnable(){

                public void run() {
                    ret.attach(RendezvousApp.this.openChannel(target, rendezvous, source, uid, (Continuation<Integer, Exception>)deliverAckToMe, (Map<String, Object>)options));
                }
            });
            return ret;
        }
        OpenChannelMsg msg = new OpenChannelMsg(this.getAddress(), rendezvous, source, uid);
        if (this.logger.level <= 500) {
            this.logger.log("routing " + msg + " to " + target);
        }
        final RouteMessage rm = new RouteMessage(target.getNodeId(), msg, (byte)this.thePastryNode.getEnvironment().getParameters().getInt("pastry_protocol_router_routeMsgVersion"));
        rm.setDestinationHandle(target);
        if (this.logger.level <= 400) {
            this.logger.log("openChannel(" + target + "," + rendezvous + "," + source + "," + uid + "," + deliverAckToMe + "," + options + ") sending via " + rm);
        }
        Cancellable ret = new Cancellable(){

            public boolean cancel() {
                if (((RendezvousApp)RendezvousApp.this).logger.level <= 500) {
                    RendezvousApp.this.logger.log("openChannel(" + target + "," + rendezvous + "," + source + "," + uid + "," + deliverAckToMe + "," + options + ").cancel()");
                }
                return rm.cancel();
            }
        };
        if (deliverAckToMe != null || this.logger.level <= 800) {
            rm.setRouteMessageNotification(new RouteMessageNotification(){

                public void sendSuccess(RouteMessage message, NodeHandle nextHop) {
                    if (((RendezvousApp)RendezvousApp.this).logger.level <= 400) {
                        RendezvousApp.this.logger.log("openChannel(" + target + "," + rendezvous + "," + source + "," + uid + "," + deliverAckToMe + "," + options + ").sendSuccess():" + nextHop);
                    }
                    if (deliverAckToMe != null) {
                        deliverAckToMe.receiveResult(uid);
                    }
                }

                public void sendFailed(RouteMessage message, Exception e) {
                    if (((RendezvousApp)RendezvousApp.this).logger.level <= 500) {
                        RendezvousApp.this.logger.log("openChannel(" + target + "," + rendezvous + "," + source + "," + uid + "," + deliverAckToMe + "," + options + ").sendFailed(" + e + ")");
                    }
                    if (deliverAckToMe != null) {
                        deliverAckToMe.receiveException(e);
                    }
                }
            });
        }
        rm.setTLOptions(options);
        this.thePastryNode.getRouter().route(rm);
        return ret;
    }

    @Override
    public MessageRequestHandle<RendezvousSocketNodeHandle, ByteBuffer> sendMessage(final RendezvousSocketNodeHandle i, final ByteBuffer m, final MessageCallback<RendezvousSocketNodeHandle, ByteBuffer> deliverAckToMe, Map<String, Object> ops) {
        if (this.logger.level <= 500) {
            this.logger.log("sendMessage(" + i + "," + m + "," + deliverAckToMe + "," + ops + ")");
        }
        final Map<String, Object> options = OptionsFactory.removeOption(ops, "transport_type");
        int priority = 0;
        if (options.containsKey("OPTION_PRIORITY")) {
            priority = (Integer)options.get("OPTION_PRIORITY");
        }
        ByteBufferMsg msg = new ByteBufferMsg(m, this.thePastryNode.getLocalHandle(), priority, this.getAddress());
        if (options.containsKey("USE_PILOT")) {
            RendezvousSocketNodeHandle pilot = (RendezvousSocketNodeHandle)options.get("USE_PILOT");
            if (this.logger.level <= 400) {
                this.logger.log("sendMessage(" + i + "," + m + "," + deliverAckToMe + "," + options + ") sending via " + pilot);
            }
            final MessageRequestHandleImpl<RendezvousSocketNodeHandle, ByteBuffer> ret = new MessageRequestHandleImpl<RendezvousSocketNodeHandle, ByteBuffer>(i, m, options);
            ret.setSubCancellable(this.thePastryNode.send(pilot, new PilotForwardMsg(this.getAddress(), msg, i), new PMessageNotification(){

                public void sent(PMessageReceipt msg) {
                    if (deliverAckToMe != null) {
                        deliverAckToMe.ack(ret);
                    }
                }

                public void sendFailed(PMessageReceipt msg, Exception reason) {
                    if (deliverAckToMe != null) {
                        deliverAckToMe.sendFailed(ret, reason);
                    }
                }
            }, null));
            return ret;
        }
        final RouteMessage rm = new RouteMessage(i.getNodeId(), msg, (byte)this.thePastryNode.getEnvironment().getParameters().getInt("pastry_protocol_router_routeMsgVersion"));
        rm.setDestinationHandle(i);
        rm.setTLOptions(options);
        if (this.logger.level <= 400) {
            this.logger.log("sendMessage(" + i + "," + m + "," + deliverAckToMe + "," + options + ") sending via " + rm);
        }
        final MessageRequestHandle<RendezvousSocketNodeHandle, ByteBuffer> ret = new MessageRequestHandle<RendezvousSocketNodeHandle, ByteBuffer>(){

            @Override
            public boolean cancel() {
                if (((RendezvousApp)RendezvousApp.this).logger.level <= 500) {
                    RendezvousApp.this.logger.log("sendMessage(" + i + "," + m + "," + deliverAckToMe + "," + options + ").cancel()");
                }
                return rm.cancel();
            }

            @Override
            public ByteBuffer getMessage() {
                return m;
            }

            @Override
            public RendezvousSocketNodeHandle getIdentifier() {
                return i;
            }

            @Override
            public Map<String, Object> getOptions() {
                return options;
            }
        };
        if (deliverAckToMe != null || this.logger.level <= 500) {
            rm.setRouteMessageNotification(new RouteMessageNotification(){

                public void sendSuccess(RouteMessage message, NodeHandle nextHop) {
                    if (((RendezvousApp)RendezvousApp.this).logger.level <= 400) {
                        RendezvousApp.this.logger.log("sendMessage(" + i + "," + m + "," + deliverAckToMe + "," + options + ").sendSuccess():" + nextHop);
                    }
                    if (deliverAckToMe != null) {
                        deliverAckToMe.ack(ret);
                    }
                }

                public void sendFailed(RouteMessage message, Exception e) {
                    if (((RendezvousApp)RendezvousApp.this).logger.level <= 500) {
                        RendezvousApp.this.logger.log("sendMessage(" + i + "," + m + "," + deliverAckToMe + "," + options + ").sendFailed(" + e + ")");
                    }
                    if (deliverAckToMe != null) {
                        deliverAckToMe.sendFailed(ret, e);
                    }
                }
            });
        }
        rm.setTLOptions(options);
        this.thePastryNode.getRouter().route(rm);
        return ret;
    }

    public String toString() {
        return "RendezvousApp{" + this.thePastryNode + "}";
    }

    @Override
    public void setTransportLayer(RendezvousTransportLayer<RendezvousSocketNodeHandle> tl) {
        this.tl = tl;
    }
}

