/*
 * Decompiled with CFR 0.152.
 */
package rice.pastry.socket.internet;

import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.BindException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import org.mpisws.p2p.transport.multiaddress.MultiInetSocketAddress;
import org.mpisws.p2p.transport.networkinfo.CantVerifyConnectivityException;
import org.mpisws.p2p.transport.networkinfo.ConnectivityResult;
import rice.Continuation;
import rice.environment.Environment;
import rice.environment.params.Parameters;
import rice.p2p.commonapi.Cancellable;
import rice.pastry.Id;
import rice.pastry.NodeIdFactory;
import rice.pastry.PastryNode;
import rice.pastry.socket.nat.CantFindFirewallException;
import rice.pastry.socket.nat.NATHandler;
import rice.pastry.socket.nat.StubNATHandler;
import rice.pastry.socket.nat.connectivityverifiier.ConnectivityVerifier;
import rice.pastry.socket.nat.connectivityverifiier.ConnectivityVerifierImpl;
import rice.pastry.socket.nat.rendezvous.RendezvousSocketPastryNodeFactory;
import rice.selector.TimerTask;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InternetPastryNodeFactory
extends RendezvousSocketPastryNodeFactory {
    public static final int ALWAYS = 1;
    public static final int PREFIX_MATCH = 2;
    public static final int NEVER = 3;
    public static final int BOOT = 4;
    public static final int OVERWRITE = 1;
    public static final int USE_DIFFERENT_PORT = 2;
    public static final int FAIL = 3;
    public static final int RENDEZVOUS = 4;
    NATHandler natHandler;
    ConnectivityVerifier connectivityVerifier;
    Collection<InetSocketAddress> probeAddresses;
    InetAddress[] externalAddresses;

    public InternetPastryNodeFactory(NodeIdFactory nf, int startPort, Environment env) throws IOException {
        this(nf, null, startPort, env, null, null, null);
    }

    public InternetPastryNodeFactory(NodeIdFactory nf, InetAddress bindAddress, int startPort, Environment env, NATHandler handler, Collection<InetSocketAddress> probeAddresses, InetAddress[] externalAddresses) throws IOException {
        super(nf, bindAddress, startPort, env, false);
        Parameters params = env.getParameters();
        this.natHandler = handler;
        if (this.natHandler == null) {
            this.natHandler = this.getDefaultNatHandler(env, this.localAddress);
        }
        this.probeAddresses = probeAddresses;
        this.externalAddresses = externalAddresses;
        if (params.contains("external_address")) {
            externalAddresses = new InetAddress[]{params.getInetSocketAddress("external_address").getAddress()};
        }
        this.connectivityVerifier = new ConnectivityVerifierImpl(this);
        this.findExternalAddressIfNecessary(this.localAddress);
    }

    protected NATHandler getDefaultNatHandler(Environment env, InetAddress localAddress) {
        Parameters params = env.getParameters();
        if (params.contains("nat_handler_class")) {
            try {
                Class<?> natHandlerClass = Class.forName(params.getString("nat_handler_class"));
                Class[] args = new Class[]{Environment.class, InetAddress.class};
                Constructor<?> constructor = natHandlerClass.getConstructor(args);
                Object[] foo = new Object[]{env, localAddress};
                return (NATHandler)constructor.newInstance(foo);
            }
            catch (ClassNotFoundException e) {
                if (this.logger.level <= 800) {
                    this.logger.log("Didn't find UPnP libs, skipping UPnP");
                }
                return new StubNATHandler(env, localAddress);
            }
            catch (NoClassDefFoundError e) {
                if (this.logger.level <= 800) {
                    this.logger.log("Didn't find UPnP libs, skipping UPnP");
                }
                return new StubNATHandler(env, localAddress);
            }
            catch (InvocationTargetException e) {
                if (this.logger.level <= 800) {
                    this.logger.log("Didn't find UPnP libs, skipping UPnP");
                }
                return new StubNATHandler(env, localAddress);
            }
            catch (Exception e) {
                if (this.logger.level <= 900) {
                    this.logger.logException("Error constructing NATHandler.", e);
                }
                throw new RuntimeException(e);
            }
        }
        return new StubNATHandler(env, localAddress);
    }

    protected boolean shouldFindExternalAddress(InetAddress address) {
        switch (this.getFireWallPolicyVariable("nat_search_policy")) {
            case 3: {
                return false;
            }
            case 2: {
                return !this.isInternetRoutablePrefix(address);
            }
            case 1: {
                return true;
            }
        }
        return true;
    }

    protected boolean findExternalAddressIfNecessary(InetAddress address) throws IOException {
        if (!this.shouldFindExternalAddress(address)) {
            return true;
        }
        try {
            this.natHandler.findFireWall(address);
        }
        catch (CantFindFirewallException cffe) {
            if (this.logger.level <= 800) {
                this.logger.log("Can't find firewall, continuing. For better performance, enable UPnP.  Will try to verify if user configured a port forward rule..." + cffe);
            }
            return false;
        }
        catch (IOException ioe) {
            if (this.logger.level <= 900) {
                this.logger.log(ioe.toString());
            }
            return false;
        }
        if (this.externalAddresses == null) {
            this.externalAddresses = new InetAddress[1];
            this.externalAddresses[0] = this.natHandler.getFireWallExternalAddress();
            return this.externalAddresses[0] != null;
        }
        if (this.externalAddresses[0].equals(this.natHandler.getFireWallExternalAddress())) {
            return true;
        }
        throw new IOException("Firewall disagrees with the externalAddresses. externalAddresses:" + this.externalAddresses[0] + " firewall:" + this.natHandler.getFireWallExternalAddress());
    }

    @Override
    protected void newNodeSelector(Id nodeId, MultiInetSocketAddress proxyAddress, Continuation<PastryNode, IOException> deliverResultToMe, Map<String, Object> initialVars) {
        if (!proxyAddress.getInnermostAddress().getAddress().equals(this.localAddress)) {
            throw new RuntimeException("proxyAddress.innermostAddress() must be the local bind address. proxyAddress:" + proxyAddress + " bindAddress:" + this.localAddress);
        }
        if (!this.shouldFindExternalAddress(proxyAddress.getInnermostAddress().getAddress())) {
            this.verifyConnectivityThenMakeNewNode(nodeId, proxyAddress, deliverResultToMe);
            return;
        }
        if (proxyAddress.getNumAddresses() > 2) {
            throw new RuntimeException("this factory only supports 1 layer deep NAT configurations try setting nat_search_policy = never if you are sure that your NAT configuration is " + proxyAddress);
        }
        if (proxyAddress.getNumAddresses() == 1) {
            this.findExternalAddress(nodeId, proxyAddress.getInnermostAddress(), deliverResultToMe);
        } else {
            this.openFirewallPort(nodeId, proxyAddress.getInnermostAddress(), deliverResultToMe, proxyAddress.getOutermostAddress().getAddress(), proxyAddress.getOutermostAddress().getPort());
        }
    }

    protected void findExternalAddress(Id nodeId, InetSocketAddress bindAddress, Continuation<PastryNode, IOException> deliverResultToMe) {
        if (this.environment.getParameters().contains("external_address")) {
            try {
                InetSocketAddress pAddress = this.environment.getParameters().getInetSocketAddress("external_address");
                this.openFirewallPort(nodeId, bindAddress, deliverResultToMe, pAddress.getAddress(), pAddress.getPort());
            }
            catch (UnknownHostException uhe) {
                deliverResultToMe.receiveException(uhe);
            }
        } else {
            ArrayList<InetSocketAddress> myProbeAddresses = null;
            ArrayList<InetSocketAddress> nonInternetRoutable = null;
            if (this.probeAddresses != null) {
                myProbeAddresses = new ArrayList<InetSocketAddress>(this.probeAddresses);
                nonInternetRoutable = new ArrayList<InetSocketAddress>();
                while (myProbeAddresses.remove(bindAddress)) {
                }
                Iterator i = myProbeAddresses.iterator();
                while (i.hasNext()) {
                    InetSocketAddress foo = (InetSocketAddress)i.next();
                    if (this.isInternetRoutablePrefix(foo.getAddress())) continue;
                    nonInternetRoutable.add(foo);
                    i.remove();
                }
            }
            if ((myProbeAddresses == null || myProbeAddresses.isEmpty()) && nonInternetRoutable != null && !nonInternetRoutable.isEmpty()) {
                this.findExternalNodes(nodeId, bindAddress, nonInternetRoutable, deliverResultToMe);
            } else {
                this.findExternalAddressHelper(nodeId, bindAddress, deliverResultToMe, myProbeAddresses);
            }
        }
    }

    protected void findExternalNodes(final Id nodeId, final InetSocketAddress bindAddress, final Collection<InetSocketAddress> nonInternetRoutable, final Continuation<PastryNode, IOException> deliverResultToMe) {
        if (nonInternetRoutable == null || nonInternetRoutable.isEmpty()) {
            this.findExternalAddressHelper(nodeId, bindAddress, deliverResultToMe, null);
        }
        this.connectivityVerifier.findExternalNodes(bindAddress, nonInternetRoutable, new Continuation<Collection<InetSocketAddress>, IOException>(){

            @Override
            public void receiveResult(Collection<InetSocketAddress> result) {
                InternetPastryNodeFactory.this.findExternalAddressHelper(nodeId, bindAddress, deliverResultToMe, result);
            }

            @Override
            public void receiveException(IOException exception) {
                if (nonInternetRoutable == null || nonInternetRoutable.isEmpty()) {
                    InternetPastryNodeFactory.this.findExternalAddressHelper(nodeId, bindAddress, deliverResultToMe, null);
                }
            }
        });
    }

    protected void findExternalAddressHelper(final Id nodeId, final InetSocketAddress bindAddress, final Continuation<PastryNode, IOException> deliverResultToMe, Collection<InetSocketAddress> myProbeAddresses) {
        if (myProbeAddresses != null && !myProbeAddresses.isEmpty()) {
            this.connectivityVerifier.findExternalAddress(bindAddress, myProbeAddresses, new Continuation<InetAddress, IOException>(){

                @Override
                public void receiveResult(InetAddress result) {
                    if (InternetPastryNodeFactory.this.externalAddresses != null && !InternetPastryNodeFactory.this.externalAddresses[0].equals(result)) {
                        deliverResultToMe.receiveException(new IOException("Probe address (" + result + ") does not match specified externalAddress (" + InternetPastryNodeFactory.this.externalAddresses[0] + ")."));
                        return;
                    }
                    InternetPastryNodeFactory.this.openFirewallPort(nodeId, bindAddress, deliverResultToMe, result, -1);
                }

                @Override
                public void receiveException(IOException exception) {
                    deliverResultToMe.receiveException(exception);
                }
            });
        } else {
            this.openFirewallPort(nodeId, bindAddress, deliverResultToMe, this.natHandler.getFireWallExternalAddress(), -1);
        }
    }

    protected void openFirewallPort(Id nodeId, InetSocketAddress bindAddress, Continuation<PastryNode, IOException> deliverResultToMe, InetAddress externalAddress, int requestedPort) {
        Parameters params = this.environment.getParameters();
        int firewallSearchTries = params.getInt("nat_find_port_max_tries");
        String firewallAppName = params.getString("nat_app_name");
        int port = requestedPort == -1 ? bindAddress.getPort() : requestedPort;
        boolean rendezvous = false;
        try {
            if (this.natHandler.getFireWallExternalAddress() == null) {
                rendezvous = true;
            } else {
                int availableFireWallPort = this.natHandler.findAvailableFireWallPort(bindAddress.getPort(), port, firewallSearchTries, firewallAppName);
                if (requestedPort == -1 || availableFireWallPort == port) {
                    port = availableFireWallPort;
                } else {
                    switch (this.getFireWallPolicyVariable("nat_state_policy")) {
                        case 1: {
                            break;
                        }
                        case 3: {
                            deliverResultToMe.receiveException(new BindException("Firewall is already bound to the requested port:" + externalAddress + ":" + port));
                            return;
                        }
                        case 4: {
                            rendezvous = true;
                            break;
                        }
                        case 2: {
                            port = availableFireWallPort;
                        }
                    }
                }
            }
            if (rendezvous) {
                port = bindAddress.getPort();
            } else {
                this.natHandler.openFireWallPort(bindAddress.getPort(), port, firewallAppName);
            }
        }
        catch (IOException ioe) {
            port = 0;
        }
        MultiInetSocketAddress fullAddress = externalAddress == null ? new MultiInetSocketAddress(bindAddress) : new MultiInetSocketAddress(new InetSocketAddress(externalAddress, port), bindAddress);
        this.verifyConnectivityThenMakeNewNode(nodeId, fullAddress, deliverResultToMe);
    }

    protected void verifyConnectivityThenMakeNewNode(final Id nodeId, final MultiInetSocketAddress proxyAddress, final Continuation<PastryNode, IOException> deliverResultToMe) {
        if (proxyAddress.getOutermostAddress().getPort() < 1) {
            this.newNodeSelector(nodeId, proxyAddress, deliverResultToMe, null, true);
            return;
        }
        if (!this.shouldCheckConnectivity(proxyAddress, this.probeAddresses)) {
            this.newNodeSelector(nodeId, proxyAddress, deliverResultToMe, null, false);
            return;
        }
        final boolean[] timeout = new boolean[]{false};
        final Cancellable[] cancelme = new Cancellable[1];
        final TimerTask timer = new TimerTask(){

            public void run() {
                timeout[0] = true;
                cancelme[0].cancel();
                InternetPastryNodeFactory.this.environment.getSelectorManager().schedule(new TimerTask(){

                    public void run() {
                        InternetPastryNodeFactory.this.newNodeSelector(nodeId, proxyAddress, (Continuation<PastryNode, IOException>)deliverResultToMe, (Map<String, Object>)null, true);
                    }
                }, 1000L);
            }
        };
        this.environment.getSelectorManager().getTimer().schedule(timer, 10000L);
        cancelme[0] = this.connectivityVerifier.verifyConnectivity(proxyAddress, this.probeAddresses, new ConnectivityResult(){
            boolean udpSuccess = false;
            boolean tcpSuccess = false;

            @Override
            public void udpSuccess(InetSocketAddress from, Map<String, Object> options) {
                this.udpSuccess = true;
                this.complete();
            }

            @Override
            public void tcpSuccess(InetSocketAddress from, Map<String, Object> options) {
                this.tcpSuccess = true;
                this.complete();
            }

            public void complete() {
                if (this.tcpSuccess && this.udpSuccess && !timeout[0]) {
                    timer.cancel();
                    InternetPastryNodeFactory.this.newNodeSelector(nodeId, proxyAddress, (Continuation<PastryNode, IOException>)deliverResultToMe, (Map<String, Object>)null, false);
                }
            }

            @Override
            public void receiveException(Exception e) {
                timer.cancel();
                if (e instanceof CantVerifyConnectivityException) {
                    if (InternetPastryNodeFactory.this.shouldFindExternalAddress(proxyAddress.getInnermostAddress().getAddress())) {
                        InternetPastryNodeFactory.this.newNodeSelector(nodeId, proxyAddress, (Continuation<PastryNode, IOException>)deliverResultToMe, (Map<String, Object>)null, true);
                    } else {
                        InternetPastryNodeFactory.this.newNodeSelector(nodeId, proxyAddress, (Continuation<PastryNode, IOException>)deliverResultToMe, (Map<String, Object>)null, false);
                    }
                } else {
                    InternetPastryNodeFactory.this.newNodeSelector(nodeId, proxyAddress, (Continuation<PastryNode, IOException>)deliverResultToMe, (Map<String, Object>)null, true);
                }
            }
        });
    }

    protected boolean isInternetRoutable(MultiInetSocketAddress proxyAddress) {
        InetSocketAddress address;
        return proxyAddress.getNumAddresses() == 1 && this.isInternetRoutablePrefix((address = proxyAddress.getInnermostAddress()).getAddress());
    }

    protected int getFireWallPolicyVariable(String key) {
        String val = this.environment.getParameters().getString(key);
        if (val.equalsIgnoreCase("prefix")) {
            return 2;
        }
        if (val.equalsIgnoreCase("change")) {
            return 2;
        }
        if (val.equalsIgnoreCase("never")) {
            return 3;
        }
        if (val.equalsIgnoreCase("overwrite")) {
            return 1;
        }
        if (val.equalsIgnoreCase("always")) {
            return 1;
        }
        if (val.equalsIgnoreCase("boot")) {
            return 4;
        }
        if (val.equalsIgnoreCase("fail")) {
            return 3;
        }
        if (val.equalsIgnoreCase("rendezvous")) {
            return 4;
        }
        throw new RuntimeException("Unknown value " + val + " for " + key);
    }

    protected boolean shouldCheckConnectivity(MultiInetSocketAddress proxyAddress, Collection<InetSocketAddress> bootstraps) {
        if (bootstraps == null) {
            return false;
        }
        switch (this.getFireWallPolicyVariable("firewall_test_policy")) {
            case 3: {
                return false;
            }
            case 4: {
                if (!bootstraps.contains(proxyAddress.getOutermostAddress())) {
                    return true;
                }
            }
            case 2: {
                return !this.isInternetRoutable(proxyAddress);
            }
            case 1: {
                return true;
            }
        }
        return true;
    }
}

