/*
 * Decompiled with CFR 0.152.
 */
package rice.pastry.routing;

import java.io.IOException;
import java.io.Serializable;
import java.util.Date;
import rice.p2p.commonapi.rawserialization.InputBuffer;
import rice.p2p.commonapi.rawserialization.OutputBuffer;
import rice.pastry.NodeHandle;
import rice.pastry.messaging.PRawMessage;
import rice.pastry.routing.RouteProtocolAddress;

public class RequestRouteRow
extends PRawMessage
implements Serializable {
    public static final short TYPE = 1;
    private short row;

    public RequestRouteRow(NodeHandle nh, short r) {
        this(null, nh, r);
    }

    public RequestRouteRow(Date stamp, NodeHandle nh, short r) {
        super(RouteProtocolAddress.getCode(), stamp);
        this.setSender(nh);
        this.row = r;
        this.setPriority(-15);
    }

    public NodeHandle returnHandle() {
        return this.getSender();
    }

    public short getRow() {
        return this.row;
    }

    public String toString() {
        String s = "";
        s = s + "RequestRouteRow(row " + this.row + " by " + this.getSender().getNodeId() + ")";
        return s;
    }

    public short getType() {
        return 1;
    }

    public void serialize(OutputBuffer buf) throws IOException {
        buf.writeByte((byte)0);
        buf.writeShort(this.row);
    }

    public RequestRouteRow(NodeHandle sender, InputBuffer buf) throws IOException {
        super(RouteProtocolAddress.getCode(), null);
        this.setSender(sender);
        byte version = buf.readByte();
        switch (version) {
            case 0: {
                this.row = buf.readShort();
                this.setPriority(-15);
                break;
            }
            default: {
                throw new IOException("Unknown Version: " + version);
            }
        }
    }
}

