/*
 * Decompiled with CFR 0.152.
 */
package rice.pastry.pns.messages;

import java.io.IOException;
import rice.p2p.commonapi.rawserialization.InputBuffer;
import rice.p2p.commonapi.rawserialization.OutputBuffer;
import rice.pastry.NodeHandle;
import rice.pastry.PastryNode;
import rice.pastry.messaging.PRawMessage;
import rice.pastry.routing.RouteSet;

public class RouteRowResponse
extends PRawMessage {
    public static final short TYPE = 4;
    public short index;
    public RouteSet[] row;

    public RouteRowResponse(NodeHandle sender, short index, RouteSet[] row, int address) {
        super(address);
        if (sender == null) {
            throw new IllegalArgumentException("sender == null!");
        }
        this.setSender(sender);
        this.index = index;
        this.row = row;
        this.setPriority(-10);
    }

    public String toString() {
        return "RRresp[" + this.index + "]:" + this.getSender();
    }

    public void serialize(OutputBuffer buf) throws IOException {
        buf.writeByte((byte)0);
        buf.writeShort(this.index);
        buf.writeInt(this.row.length);
        for (int i = 0; i < this.row.length; ++i) {
            if (this.row[i] == null) {
                buf.writeBoolean(false);
                continue;
            }
            buf.writeBoolean(true);
            this.row[i].serialize(buf);
        }
    }

    public RouteRowResponse(InputBuffer buf, PastryNode localNode, NodeHandle sender, int dest) throws IOException {
        super(dest);
        byte version = buf.readByte();
        switch (version) {
            case 0: {
                this.setSender(sender);
                this.index = buf.readShort();
                int numRouteSets = buf.readInt();
                this.row = new RouteSet[numRouteSets];
                for (int i = 0; i < numRouteSets; ++i) {
                    if (!buf.readBoolean()) continue;
                    this.row[i] = new RouteSet(buf, localNode, localNode);
                }
                break;
            }
            default: {
                throw new IOException("Unknown Version: " + version);
            }
        }
    }

    public short getType() {
        return 4;
    }
}

