/*
 * Decompiled with CFR 0.152.
 */
package rice.pastry.peerreview;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import org.mpisws.p2p.transport.ErrorHandler;
import org.mpisws.p2p.transport.MessageCallback;
import org.mpisws.p2p.transport.MessageRequestHandle;
import org.mpisws.p2p.transport.P2PSocket;
import org.mpisws.p2p.transport.SocketCallback;
import org.mpisws.p2p.transport.SocketRequestHandle;
import org.mpisws.p2p.transport.TransportLayer;
import org.mpisws.p2p.transport.TransportLayerCallback;
import org.mpisws.p2p.transport.multiaddress.MultiInetSocketAddress;
import org.mpisws.p2p.transport.peerreview.PeerReviewCallback;
import org.mpisws.p2p.transport.peerreview.WitnessListener;
import org.mpisws.p2p.transport.peerreview.replay.Verifier;
import rice.Continuation;
import rice.environment.Environment;
import rice.environment.logging.Logger;
import rice.p2p.commonapi.rawserialization.InputBuffer;
import rice.p2p.commonapi.rawserialization.OutputBuffer;
import rice.pastry.Id;
import rice.pastry.NodeHandle;
import rice.pastry.NodeHandleFactory;
import rice.pastry.PastryNode;
import rice.pastry.peerreview.CallbackFactory;
import rice.pastry.peerreview.FetchLeafsetApp;
import rice.pastry.socket.TransportLayerNodeHandle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PeerReviewCallbackImpl
implements PeerReviewCallback<TransportLayerNodeHandle<MultiInetSocketAddress>, Id>,
TransportLayer<TransportLayerNodeHandle<MultiInetSocketAddress>, ByteBuffer> {
    CallbackFactory nodeFactory;
    PastryNode pn;
    TransportLayer<TransportLayerNodeHandle<MultiInetSocketAddress>, ByteBuffer> tl;
    TransportLayerCallback<TransportLayerNodeHandle<MultiInetSocketAddress>, ByteBuffer> callback;
    FetchLeafsetApp fetchLeafSetApp;
    Logger logger;

    public PeerReviewCallbackImpl(PastryNode pn, TransportLayer<TransportLayerNodeHandle<MultiInetSocketAddress>, ByteBuffer> tl, CallbackFactory nodeFactory) {
        this(tl);
        this.pn = pn;
        this.nodeFactory = nodeFactory;
        this.logger = pn.getEnvironment().getLogManager().getLogger(this.getClass(), null);
        this.fetchLeafSetApp = new FetchLeafsetApp(pn, 4);
        this.fetchLeafSetApp.register();
    }

    protected PeerReviewCallbackImpl(TransportLayer<TransportLayerNodeHandle<MultiInetSocketAddress>, ByteBuffer> tl) {
        this.tl = tl;
    }

    @Override
    public PeerReviewCallback<TransportLayerNodeHandle<MultiInetSocketAddress>, Id> getReplayInstance(Verifier<TransportLayerNodeHandle<MultiInetSocketAddress>> v) {
        return new PeerReviewCallbackImpl(v);
    }

    @Override
    public void storeCheckpoint(OutputBuffer buffer) throws IOException {
        this.pn.getId().serialize(buffer);
        this.pn.getLocalHandle().serialize(buffer);
    }

    @Override
    public boolean loadCheckpoint(InputBuffer buffer) throws IOException {
        Environment environment = ((Verifier)this.tl).getEnvironment();
        Id nodeId = Id.build(buffer);
        this.pn = new PastryNode(nodeId, environment);
        NodeHandleFactory nodeHandleFactory = this.nodeFactory.getNodeHandleFactory(this.pn);
        Object handle = nodeHandleFactory.readNodeHandle(buffer);
        this.nodeFactory.localHandleTable.put(this.pn, (NodeHandle)handle);
        this.nodeFactory.nodeHandleHelper(this.pn);
        return true;
    }

    @Override
    public Collection<TransportLayerNodeHandle<MultiInetSocketAddress>> getMyWitnessedNodes() {
        Collection<NodeHandle> foo = this.pn.getLeafSet().getUniqueSet();
        ArrayList<TransportLayerNodeHandle<MultiInetSocketAddress>> ret = new ArrayList<TransportLayerNodeHandle<MultiInetSocketAddress>>(foo.size());
        for (NodeHandle h : foo) {
            ret.add((TransportLayerNodeHandle)h);
        }
        this.logger.log("myWitnessedNodes: " + ret);
        return ret;
    }

    @Override
    public void init() {
    }

    @Override
    public void destroy() {
    }

    @Override
    public void notifyCertificateAvailable(Id id) {
    }

    @Override
    public void incomingSocket(P2PSocket<TransportLayerNodeHandle<MultiInetSocketAddress>> s) throws IOException {
        this.callback.incomingSocket(s);
    }

    @Override
    public void messageReceived(TransportLayerNodeHandle<MultiInetSocketAddress> i, ByteBuffer m, Map<String, Object> options) throws IOException {
        this.callback.messageReceived(i, m, options);
    }

    @Override
    public void notifyStatusChange(Id id, int newStatus) {
    }

    @Override
    public void acceptMessages(boolean b) {
    }

    @Override
    public void acceptSockets(boolean b) {
    }

    @Override
    public void getWitnesses(final Id subject, final WitnessListener<TransportLayerNodeHandle<MultiInetSocketAddress>, Id> callback) {
        this.fetchLeafSetApp.getNeighbors(subject, new Continuation<Collection<NodeHandle>, Exception>(){

            @Override
            public void receiveResult(Collection<NodeHandle> result) {
                ArrayList<TransportLayerNodeHandle> ret = new ArrayList<TransportLayerNodeHandle>(result.size());
                for (NodeHandle nh : result) {
                    if (nh.getId().equals(subject)) continue;
                    ret.add((TransportLayerNodeHandle)nh);
                }
                PeerReviewCallbackImpl.this.logger.log("returning witnesses for " + subject + " " + ret);
                callback.notifyWitnessSet(subject, ret);
            }

            @Override
            public void receiveException(Exception exception) {
                throw new RuntimeException(exception);
            }
        });
    }

    @Override
    public TransportLayerNodeHandle<MultiInetSocketAddress> getLocalIdentifier() {
        return this.tl.getLocalIdentifier();
    }

    @Override
    public SocketRequestHandle<TransportLayerNodeHandle<MultiInetSocketAddress>> openSocket(TransportLayerNodeHandle<MultiInetSocketAddress> i, SocketCallback<TransportLayerNodeHandle<MultiInetSocketAddress>> deliverSocketToMe, Map<String, Object> options) {
        return this.tl.openSocket(i, deliverSocketToMe, options);
    }

    @Override
    public void setCallback(TransportLayerCallback<TransportLayerNodeHandle<MultiInetSocketAddress>, ByteBuffer> callback) {
        this.callback = callback;
    }

    @Override
    public void setErrorHandler(ErrorHandler<TransportLayerNodeHandle<MultiInetSocketAddress>> handler) {
    }

    @Override
    public MessageRequestHandle<TransportLayerNodeHandle<MultiInetSocketAddress>, ByteBuffer> sendMessage(TransportLayerNodeHandle<MultiInetSocketAddress> i, ByteBuffer m, MessageCallback<TransportLayerNodeHandle<MultiInetSocketAddress>, ByteBuffer> deliverAckToMe, Map<String, Object> options) {
        return this.tl.sendMessage(i, m, deliverAckToMe, options);
    }
}

