/*
 * Decompiled with CFR 0.152.
 */
package rice.pastry.peerreview;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import rice.Continuation;
import rice.p2p.commonapi.rawserialization.InputBuffer;
import rice.p2p.commonapi.rawserialization.MessageDeserializer;
import rice.p2p.util.tuples.Tuple;
import rice.pastry.Id;
import rice.pastry.NodeHandle;
import rice.pastry.NodeSet;
import rice.pastry.PastryNode;
import rice.pastry.client.PastryAppl;
import rice.pastry.messaging.Message;
import rice.pastry.messaging.PRawMessage;
import rice.pastry.peerreview.FetchLeafsetRequest;
import rice.pastry.peerreview.FetchLeafsetResponse;
import rice.pastry.routing.RouteMessage;
import rice.selector.TimerTask;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FetchLeafsetApp
extends PastryAppl {
    public static final int APP_ID = -133359640;
    protected Map<Id, Tuple<TimerTask, Collection<Continuation<Collection<NodeHandle>, Exception>>>> pendingLookups = new HashMap<Id, Tuple<TimerTask, Collection<Continuation<Collection<NodeHandle>, Exception>>>>();
    protected int numNeighbors;
    protected byte routeMsgVersion = (byte)this.thePastryNode.getEnvironment().getParameters().getInt("pastry_protocol_router_routeMsgVersion");

    public FetchLeafsetApp(final PastryNode pn, int numNeighbors) {
        super(pn, null, -133359640, new MessageDeserializer(){

            public Message deserialize(InputBuffer buf, short type, int priority, rice.p2p.commonapi.NodeHandle sender) throws IOException {
                switch (type) {
                    case 1: {
                        if (sender == null) {
                            throw new IOException("Sender is null for FetchLeafsetRequest");
                        }
                        return new FetchLeafsetRequest((NodeHandle)sender, Id.build(buf));
                    }
                    case 2: {
                        return new FetchLeafsetResponse(buf, pn, (NodeHandle)sender);
                    }
                }
                throw new IOException("Unknown type:" + type);
            }
        });
        this.numNeighbors = numNeighbors;
    }

    @Override
    public void messageForAppl(Message msg) {
        PRawMessage m = (PRawMessage)msg;
        switch (m.getType()) {
            case 1: {
                FetchLeafsetRequest req = (FetchLeafsetRequest)m;
                this.logger.log("getNeighbors(" + req.subject + ") sending response");
                this.thePastryNode.send(req.getSender(), new FetchLeafsetResponse(req.subject, this.thePastryNode.getLeafSet()), null, null);
                return;
            }
            case 2: {
                this.handleResponse((FetchLeafsetResponse)m);
                return;
            }
        }
    }

    protected void handleResponse(FetchLeafsetResponse response) {
        this.logger.log("handleResponse(" + response.subject + ")");
        Tuple<TimerTask, Collection<Continuation<Collection<NodeHandle>, Exception>>> foo = this.pendingLookups.remove(response.subject);
        if (foo == null) {
            return;
        }
        foo.a().cancel();
        NodeSet ns = response.leafSet.replicaSet(response.subject, this.numNeighbors + 1);
        Collection<NodeHandle> ret = ns.getCollection();
        for (Continuation<Collection<NodeHandle>, Exception> c : foo.b()) {
            c.receiveResult(ret);
        }
    }

    public void getNeighbors(final Id subject, Continuation<Collection<NodeHandle>, Exception> continuation) {
        this.logger.log("getNeighbors(" + subject + ")");
        Tuple<TimerTask, Collection<Continuation<Collection<NodeHandle>, Exception>>> foo = this.pendingLookups.get(subject);
        boolean startTask = false;
        if (foo == null) {
            startTask = true;
            foo = new Tuple(new TimerTask(){

                public void run() {
                    FetchLeafsetApp.this.logger.log("getNeighbors(" + subject + ") sending fetch");
                    FetchLeafsetApp.this.thePastryNode.getRouter().route(new RouteMessage(subject, new FetchLeafsetRequest(FetchLeafsetApp.this.thePastryNode.getLocalHandle(), subject), FetchLeafsetApp.this.routeMsgVersion));
                }
            }, new ArrayList());
            this.pendingLookups.put(subject, foo);
        }
        foo.b().add(continuation);
        if (startTask) {
            this.thePastryNode.getEnvironment().getSelectorManager().schedule(foo.a(), 0L, 3000L);
        }
    }
}

