/*
 * Decompiled with CFR 0.152.
 */
package rice.pastry.direct;

import java.io.IOException;
import java.util.Observable;
import java.util.Observer;
import rice.p2p.commonapi.rawserialization.OutputBuffer;
import rice.p2p.commonapi.rawserialization.SizeCheckOutputBuffer;
import rice.pastry.Id;
import rice.pastry.NodeHandle;
import rice.pastry.PastryNode;
import rice.pastry.direct.DirectPastryNode;
import rice.pastry.direct.NetworkSimulator;
import rice.pastry.direct.NodeRecord;
import rice.pastry.messaging.Message;
import rice.pastry.socket.TransportLayerNodeHandle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DirectNodeHandle
extends TransportLayerNodeHandle<NodeRecord>
implements Observer {
    public transient NetworkSimulator simulator;

    protected DirectNodeHandle(PastryNode ln, NetworkSimulator sim) {
        this.localnode = ln;
        this.logger = ln.getEnvironment().getLogManager().getLogger(this.getClass(), null);
        this.simulator = sim;
        ln.addObserver(this);
    }

    public PastryNode getRemote() {
        return this.localnode;
    }

    @Override
    public Id getNodeId() {
        return this.localnode.getNodeId();
    }

    @Override
    public int getLiveness() {
        if (this.simulator.isAlive(this)) {
            return 1;
        }
        return 3;
    }

    public NetworkSimulator getSimulator() {
        return this.simulator;
    }

    @Override
    public void notifyObservers(Object arg) {
        this.setChanged();
        super.notifyObservers(arg);
    }

    @Override
    public boolean ping() {
        return this.isAlive();
    }

    @Override
    public final void assertLocalNode() {
        if (DirectPastryNode.getCurrentNode() == null) {
            throw new RuntimeException("PANIC: localnode is null in " + this + "@" + System.identityHashCode(this));
        }
    }

    @Override
    public int proximity() {
        this.assertLocalNode();
        return this.getLocalNode().proximity(this);
    }

    @Override
    public void receiveMessage(Message msg) {
        DirectPastryNode.getCurrentNode().send(this, msg, null, null);
    }

    @Override
    public boolean equals(Object obj) {
        return obj == this;
    }

    @Override
    public int hashCode() {
        return this.getNodeId().hashCode();
    }

    public String toString() {
        return "[DNH " + this.getNodeId() + "]";
    }

    @Override
    public void update(Observable arg0, Object arg1) {
        if (!this.simulator.isAlive(this)) {
            this.notifyObservers(NodeHandle.DECLARED_DEAD);
        }
    }

    @Override
    public void serialize(OutputBuffer buf) throws IOException {
        if (!(buf instanceof SizeCheckOutputBuffer)) {
            throw new RuntimeException("DirectNodeHandle.serialize() Should not be called.  If you are doing this to determine the size, please use a SizeCheckOutputBuffer such as the DirectSizeChecker.");
        }
        ((SizeCheckOutputBuffer)buf).writeSpecial(this);
    }

    @Override
    public NodeRecord getAddress() {
        return this.simulator.getNodeRecord(this);
    }

    @Override
    public long getEpoch() {
        return 0L;
    }
}

