/*
 * Decompiled with CFR 0.152.
 */
package rice.pastry;

import rice.environment.logging.Logger;
import rice.pastry.PastryNode;
import rice.pastry.messaging.Message;
import rice.selector.TimerTask;

public class ScheduledMessage
extends TimerTask {
    protected PastryNode localNode;
    protected Message msg;

    public ScheduledMessage(PastryNode pn, Message msg) {
        this.localNode = pn;
        this.msg = msg;
    }

    public Message getMessage() {
        return this.msg;
    }

    public PastryNode getLocalNode() {
        return this.localNode;
    }

    public void run() {
        block3: {
            try {
                Message m = this.msg;
                if (m != null) {
                    this.localNode.receiveMessage(this.msg);
                }
            }
            catch (Exception e) {
                Logger logger = this.localNode.getEnvironment().getLogManager().getLogger(this.getClass(), null);
                if (logger.level > 900) break block3;
                logger.logException("Delivering " + this + " caused exception ", e);
            }
        }
    }

    public String toString() {
        return "SchedMsg for " + this.msg;
    }

    public boolean cancel() {
        this.msg = null;
        this.localNode = null;
        return super.cancel();
    }
}

