/*
 * Decompiled with CFR 0.152.
 */
package rice.pastry;

import rice.pastry.PastryNode;
import rice.pastry.ScheduledMessage;
import rice.pastry.messaging.Message;
import rice.selector.Timer;
import rice.selector.TimerTask;

public class ExponentialBackoffScheduledMessage
extends ScheduledMessage {
    boolean cancelled = false;
    EBTimerTask myTask;
    Timer timer;
    long initialPeriod;
    double expBase;
    int numTimes = 0;
    long lastTime = 0L;
    long maxTime = -1L;

    public ExponentialBackoffScheduledMessage(PastryNode node, Message msg, Timer timer, long initialDelay, long initialPeriod, double expBase, long maxPeriod) {
        super(node, msg);
        this.timer = timer;
        this.initialPeriod = initialPeriod;
        this.expBase = expBase;
        this.maxTime = maxPeriod;
        this.schedule(initialDelay);
    }

    public ExponentialBackoffScheduledMessage(PastryNode node, Message msg, Timer timer, long initialDelay, double expBase) {
        this(node, msg, timer, initialDelay, initialDelay, expBase, -1L);
        this.numTimes = 1;
    }

    private void schedule(long time) {
        this.myTask = new EBTimerTask();
        this.timer.schedule(this.myTask, time);
    }

    public boolean cancel() {
        super.cancel();
        if (this.myTask != null) {
            this.myTask.cancel();
            this.myTask = null;
        }
        boolean temp = this.cancelled;
        this.cancelled = true;
        return temp;
    }

    public void run() {
        if (!this.cancelled) {
            if (this.myTask != null) {
                this.lastTime = this.myTask.scheduledExecutionTime();
            }
            super.run();
            long time = (long)((double)this.initialPeriod * Math.pow(this.expBase, this.numTimes));
            if (this.maxTime >= 0L) {
                time = Math.min(time, this.maxTime);
            }
            this.schedule(time);
            ++this.numTimes;
        }
    }

    public long scheduledExecutionTime() {
        return this.lastTime;
    }

    class EBTimerTask
    extends TimerTask {
        EBTimerTask() {
        }

        public void run() {
            ExponentialBackoffScheduledMessage.this.run();
        }
    }
}

