/*
 * Decompiled with CFR 0.152.
 */
package rice.p2p.past.messaging;

import java.io.IOException;
import rice.Continuation;
import rice.environment.Environment;
import rice.environment.logging.Logger;
import rice.p2p.commonapi.Id;
import rice.p2p.commonapi.Message;
import rice.p2p.commonapi.NodeHandle;
import rice.p2p.commonapi.rawserialization.OutputBuffer;
import rice.p2p.past.PastException;
import rice.p2p.past.messaging.PastMessage;

public class MessageLostMessage
extends PastMessage {
    public static final short TYPE = 7;
    private static final long serialVersionUID = -8664827144233122095L;
    protected Id id;
    protected NodeHandle hint;
    protected String messageString;

    public MessageLostMessage(int uid, NodeHandle local, Id id, Message message, NodeHandle hint) {
        super(uid, local, local.getId());
        this.setResponse();
        this.hint = hint;
        this.messageString = message != null ? message.toString() : "";
        this.id = id;
    }

    public void returnResponse(Continuation c, Environment env, String instance) {
        Logger logger = env.getLogManager().getLogger(this.getClass(), instance);
        PastException e = new PastException("Outgoing message '" + this.messageString + "' to " + this.id + "/" + this.hint + " was lost - please try again.");
        if (logger.level <= 900) {
            logger.logException("ERROR: Outgoing PAST message " + this.messageString + " with UID " + this.getUID() + " was lost", e);
        }
        c.receiveException(e);
    }

    public String toString() {
        return "[MessageLostMessage]";
    }

    public short getType() {
        return 7;
    }

    public void serialize(OutputBuffer buf) throws IOException {
        throw new RuntimeException("serialize() not supported in MessageLostMessage");
    }
}

