/*
 * Decompiled with CFR 0.152.
 */
package rice.p2p.past.messaging;

import java.io.IOException;
import rice.p2p.commonapi.Endpoint;
import rice.p2p.commonapi.Id;
import rice.p2p.commonapi.NodeHandle;
import rice.p2p.commonapi.rawserialization.InputBuffer;
import rice.p2p.commonapi.rawserialization.OutputBuffer;
import rice.p2p.past.PastContentHandle;
import rice.p2p.past.messaging.ContinuationMessage;
import rice.p2p.past.rawserialization.JavaSerializedPastContentHandle;
import rice.p2p.past.rawserialization.PastContentDeserializer;
import rice.p2p.past.rawserialization.PastContentHandleDeserializer;
import rice.p2p.past.rawserialization.RawPastContent;
import rice.p2p.past.rawserialization.RawPastContentHandle;

public class FetchMessage
extends ContinuationMessage {
    public static final short TYPE = 3;
    private RawPastContentHandle handle;
    private boolean cached = false;

    public FetchMessage(int uid, PastContentHandle handle, NodeHandle source, Id dest) {
        this(uid, handle instanceof RawPastContentHandle ? (RawPastContentHandle)handle : new JavaSerializedPastContentHandle(handle), source, dest);
    }

    public FetchMessage(int uid, RawPastContentHandle handle, NodeHandle source, Id dest) {
        super(uid, source, dest);
        this.handle = handle;
    }

    public PastContentHandle getHandle() {
        if (this.handle.getType() == 0) {
            return ((JavaSerializedPastContentHandle)this.handle).getPCH();
        }
        return this.handle;
    }

    public boolean isCached() {
        return this.cached;
    }

    public void setCached() {
        this.cached = true;
    }

    public String toString() {
        return "[FetchMessage for " + this.handle + " cached? " + this.cached + "]";
    }

    public short getType() {
        return 3;
    }

    public void serialize(OutputBuffer buf) throws IOException {
        buf.writeByte((byte)0);
        if (this.response != null && this.response instanceof RawPastContent) {
            super.serialize(buf, false);
            RawPastContent rpc = (RawPastContent)this.response;
            buf.writeShort(rpc.getType());
            rpc.serialize(buf);
        } else {
            super.serialize(buf, true);
        }
        buf.writeBoolean(this.cached);
        buf.writeShort(this.handle.getType());
        this.handle.serialize(buf);
    }

    public static FetchMessage build(InputBuffer buf, Endpoint endpoint, PastContentDeserializer pcd, PastContentHandleDeserializer pchd) throws IOException {
        byte version = buf.readByte();
        switch (version) {
            case 0: {
                return new FetchMessage(buf, endpoint, pcd, pchd);
            }
        }
        throw new IOException("Unknown Version: " + version);
    }

    private FetchMessage(InputBuffer buf, Endpoint endpoint, PastContentDeserializer pcd, PastContentHandleDeserializer pchd) throws IOException {
        super(buf, endpoint);
        if (this.serType == S_SUB) {
            short type2 = buf.readShort();
            this.response = pcd.deserializePastContent(buf, endpoint, type2);
        }
        this.cached = buf.readBoolean();
        short type = buf.readShort();
        this.handle = type == 0 ? new JavaSerializedPastContentHandle(pchd.deserializePastContentHandle(buf, endpoint, type)) : (RawPastContentHandle)pchd.deserializePastContentHandle(buf, endpoint, type);
    }
}

