/*
 * Decompiled with CFR 0.152.
 */
package rice.p2p.past.messaging;

import java.io.IOException;
import rice.p2p.commonapi.Endpoint;
import rice.p2p.commonapi.Id;
import rice.p2p.commonapi.NodeHandle;
import rice.p2p.commonapi.rawserialization.InputBuffer;
import rice.p2p.commonapi.rawserialization.OutputBuffer;
import rice.p2p.past.messaging.ContinuationMessage;
import rice.p2p.past.rawserialization.PastContentHandleDeserializer;
import rice.p2p.past.rawserialization.RawPastContentHandle;

public class FetchHandleMessage
extends ContinuationMessage {
    public static final short TYPE = 2;
    private Id id;

    public FetchHandleMessage(int uid, Id id, NodeHandle source, Id dest) {
        super(uid, source, dest);
        this.id = id;
    }

    public Id getId() {
        return this.id;
    }

    public String toString() {
        return "[FetchHandleMessage for " + this.id + "]";
    }

    public short getType() {
        return 2;
    }

    public void serialize(OutputBuffer buf) throws IOException {
        buf.writeByte((byte)0);
        if (this.response != null && this.response instanceof RawPastContentHandle) {
            super.serialize(buf, false);
            RawPastContentHandle rpch = (RawPastContentHandle)this.response;
            buf.writeShort(rpch.getType());
            rpch.serialize(buf);
        } else {
            super.serialize(buf, true);
        }
        buf.writeShort(this.id.getType());
        this.id.serialize(buf);
    }

    public static FetchHandleMessage build(InputBuffer buf, Endpoint endpoint, PastContentHandleDeserializer pchd) throws IOException {
        byte version = buf.readByte();
        switch (version) {
            case 0: {
                return new FetchHandleMessage(buf, endpoint, pchd);
            }
        }
        throw new IOException("Unknown Version: " + version);
    }

    private FetchHandleMessage(InputBuffer buf, Endpoint endpoint, PastContentHandleDeserializer pchd) throws IOException {
        super(buf, endpoint);
        if (this.serType == S_SUB) {
            short type = buf.readShort();
            this.response = pchd.deserializePastContentHandle(buf, endpoint, type);
        }
        this.id = endpoint.readId(buf, buf.readShort());
    }
}

