/*
 * Decompiled with CFR 0.152.
 */
package rice.p2p.glacier.v2.messaging;

import java.io.IOException;
import rice.p2p.commonapi.Endpoint;
import rice.p2p.commonapi.Id;
import rice.p2p.commonapi.NodeHandle;
import rice.p2p.commonapi.rawserialization.InputBuffer;
import rice.p2p.commonapi.rawserialization.OutputBuffer;
import rice.p2p.glacier.VersionKey;
import rice.p2p.glacier.v2.messaging.GlacierMessage;

public class GlacierRefreshPatchMessage
extends GlacierMessage {
    public static final short TYPE = 10;
    protected VersionKey[] keys;
    protected long[] lifetimes;
    protected byte[][] signatures;

    public GlacierRefreshPatchMessage(int uid, VersionKey[] keys, long[] lifetimes, byte[][] signatures, NodeHandle source, Id dest, char tag) {
        super(uid, source, dest, false, tag);
        this.keys = keys;
        this.lifetimes = lifetimes;
        this.signatures = signatures;
    }

    public int numKeys() {
        return this.keys.length;
    }

    public VersionKey getKey(int index) {
        return this.keys[index];
    }

    public VersionKey[] getAllKeys() {
        return this.keys;
    }

    public long getLifetime(int index) {
        return this.lifetimes[index];
    }

    public byte[] getSignature(int index) {
        return this.signatures[index];
    }

    public String toString() {
        return "[GlacierRefreshPatch for " + this.keys[0] + " (" + (this.numKeys() - 1) + " more keys)]";
    }

    public short getType() {
        return 10;
    }

    public void serialize(OutputBuffer buf) throws IOException {
        int i;
        buf.writeByte((byte)0);
        super.serialize(buf);
        buf.writeInt(this.lifetimes.length);
        for (i = 0; i < this.lifetimes.length; ++i) {
            buf.writeLong(this.lifetimes[i]);
        }
        buf.writeInt(this.keys.length);
        for (i = 0; i < this.keys.length; ++i) {
            this.keys[i].serialize(buf);
        }
        buf.writeInt(this.signatures.length);
        for (i = 0; i < this.signatures.length; ++i) {
            buf.writeInt(this.signatures[i].length);
            buf.write(this.signatures[i], 0, this.signatures[i].length);
        }
    }

    public static GlacierRefreshPatchMessage build(InputBuffer buf, Endpoint endpoint) throws IOException {
        byte version = buf.readByte();
        switch (version) {
            case 0: {
                return new GlacierRefreshPatchMessage(buf, endpoint);
            }
        }
        throw new IOException("Unknown Version: " + version);
    }

    private GlacierRefreshPatchMessage(InputBuffer buf, Endpoint endpoint) throws IOException {
        super(buf, endpoint);
        int i;
        this.lifetimes = new long[buf.readInt()];
        for (i = 0; i < this.lifetimes.length; ++i) {
            this.lifetimes[i] = buf.readLong();
        }
        this.keys = new VersionKey[buf.readInt()];
        for (i = 0; i < this.keys.length; ++i) {
            this.keys[i] = new VersionKey(buf, endpoint);
        }
        this.signatures = new byte[buf.readInt()][];
        for (i = 0; i < this.signatures.length; ++i) {
            this.signatures[i] = new byte[buf.readInt()];
            buf.read(this.signatures[i]);
        }
    }
}

