/*
 * Decompiled with CFR 0.152.
 */
package rice.p2p.glacier.v2.messaging;

import java.io.IOException;
import rice.p2p.commonapi.Endpoint;
import rice.p2p.commonapi.Id;
import rice.p2p.commonapi.IdRange;
import rice.p2p.commonapi.NodeHandle;
import rice.p2p.commonapi.rawserialization.InputBuffer;
import rice.p2p.commonapi.rawserialization.OutputBuffer;
import rice.p2p.glacier.v2.messaging.GlacierMessage;

public class GlacierRangeForwardMessage
extends GlacierMessage {
    public static final short TYPE = 6;
    protected IdRange requestedRange;
    protected NodeHandle requestor;

    public GlacierRangeForwardMessage(int uid, IdRange requestedRange, NodeHandle requestor, NodeHandle source, Id dest, char tag) {
        super(uid, source, dest, false, tag);
        this.requestedRange = requestedRange;
        this.requestor = requestor;
    }

    public IdRange getRequestedRange() {
        return this.requestedRange;
    }

    public NodeHandle getRequestor() {
        return this.requestor;
    }

    public String toString() {
        return "[GlacierRangeForward #" + this.getUID() + " for " + this.requestedRange + " by " + this.requestor + "]";
    }

    public short getType() {
        return 6;
    }

    public void serialize(OutputBuffer buf) throws IOException {
        buf.writeByte((byte)0);
        super.serialize(buf);
        this.requestedRange.serialize(buf);
        this.requestor.serialize(buf);
    }

    public static GlacierRangeForwardMessage build(InputBuffer buf, Endpoint endpoint) throws IOException {
        byte version = buf.readByte();
        switch (version) {
            case 0: {
                return new GlacierRangeForwardMessage(buf, endpoint);
            }
        }
        throw new IOException("Unknown Version: " + version);
    }

    private GlacierRangeForwardMessage(InputBuffer buf, Endpoint endpoint) throws IOException {
        super(buf, endpoint);
        this.requestedRange = endpoint.readIdRange(buf);
        this.requestor = endpoint.readNodeHandle(buf);
    }
}

